/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Entrez2_docsum_field_info_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'entrez2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ENTREZ2_ENTREZ2_DOCSUM_FIELD_INFO_BASE_HPP
#define OBJECTS_ENTREZ2_ENTREZ2_DOCSUM_FIELD_INFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/entrez2/Entrez2_docsum_field_type.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ENTREZ2_EXPORT CEntrez2_docsum_field_info_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CEntrez2_docsum_field_info_Base(void);
    // destructor
    virtual ~CEntrez2_docsum_field_info_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TField_name;
    typedef string TField_description;
    typedef int TField_type;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_field_name,
        e_field_description,
        e_field_type
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TField_name
    ///  Check whether the Field_name data member has been assigned a value.
    bool IsSetField_name(void) const;
    /// Check whether it is safe or not to call GetField_name method.
    bool CanGetField_name(void) const;
    void ResetField_name(void);
    const TField_name& GetField_name(void) const;
    void SetField_name(const TField_name& value);
    void SetField_name(TField_name&& value);
    TField_name& SetField_name(void);

    /// mandatory
    /// typedef string TField_description
    ///  Check whether the Field_description data member has been assigned a value.
    bool IsSetField_description(void) const;
    /// Check whether it is safe or not to call GetField_description method.
    bool CanGetField_description(void) const;
    void ResetField_description(void);
    const TField_description& GetField_description(void) const;
    void SetField_description(const TField_description& value);
    void SetField_description(TField_description&& value);
    TField_description& SetField_description(void);

    /// mandatory
    /// typedef int TField_type
    ///  Check whether the Field_type data member has been assigned a value.
    bool IsSetField_type(void) const;
    /// Check whether it is safe or not to call GetField_type method.
    bool CanGetField_type(void) const;
    void ResetField_type(void);
    TField_type GetField_type(void) const;
    void SetField_type(TField_type value);
    TField_type& SetField_type(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEntrez2_docsum_field_info_Base(const CEntrez2_docsum_field_info_Base&);
    CEntrez2_docsum_field_info_Base& operator=(const CEntrez2_docsum_field_info_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Field_name;
    string m_Field_description;
    int m_Field_type;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEntrez2_docsum_field_info_Base::IsSetField_name(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CEntrez2_docsum_field_info_Base::CanGetField_name(void) const
{
    return IsSetField_name();
}

inline
const CEntrez2_docsum_field_info_Base::TField_name& CEntrez2_docsum_field_info_Base::GetField_name(void) const
{
    if (!CanGetField_name()) {
        ThrowUnassigned(0);
    }
    return m_Field_name;
}

inline
void CEntrez2_docsum_field_info_Base::SetField_name(const CEntrez2_docsum_field_info_Base::TField_name& value)
{
    m_Field_name = value;
    m_set_State[0] |= 0x3;
}

inline
void CEntrez2_docsum_field_info_Base::SetField_name(CEntrez2_docsum_field_info_Base::TField_name&& value)
{
    m_Field_name = std::forward<CEntrez2_docsum_field_info_Base::TField_name>(value);
    m_set_State[0] |= 0x3;
}

inline
CEntrez2_docsum_field_info_Base::TField_name& CEntrez2_docsum_field_info_Base::SetField_name(void)
{
#ifdef _DEBUG
    if (!IsSetField_name()) {
        m_Field_name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Field_name;
}

inline
bool CEntrez2_docsum_field_info_Base::IsSetField_description(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CEntrez2_docsum_field_info_Base::CanGetField_description(void) const
{
    return IsSetField_description();
}

inline
const CEntrez2_docsum_field_info_Base::TField_description& CEntrez2_docsum_field_info_Base::GetField_description(void) const
{
    if (!CanGetField_description()) {
        ThrowUnassigned(1);
    }
    return m_Field_description;
}

inline
void CEntrez2_docsum_field_info_Base::SetField_description(const CEntrez2_docsum_field_info_Base::TField_description& value)
{
    m_Field_description = value;
    m_set_State[0] |= 0xc;
}

inline
void CEntrez2_docsum_field_info_Base::SetField_description(CEntrez2_docsum_field_info_Base::TField_description&& value)
{
    m_Field_description = std::forward<CEntrez2_docsum_field_info_Base::TField_description>(value);
    m_set_State[0] |= 0xc;
}

inline
CEntrez2_docsum_field_info_Base::TField_description& CEntrez2_docsum_field_info_Base::SetField_description(void)
{
#ifdef _DEBUG
    if (!IsSetField_description()) {
        m_Field_description = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Field_description;
}

inline
bool CEntrez2_docsum_field_info_Base::IsSetField_type(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CEntrez2_docsum_field_info_Base::CanGetField_type(void) const
{
    return IsSetField_type();
}

inline
void CEntrez2_docsum_field_info_Base::ResetField_type(void)
{
    m_Field_type = (int)(0);
    m_set_State[0] &= ~0x30;
}

inline
CEntrez2_docsum_field_info_Base::TField_type CEntrez2_docsum_field_info_Base::GetField_type(void) const
{
    if (!CanGetField_type()) {
        ThrowUnassigned(2);
    }
    return m_Field_type;
}

inline
void CEntrez2_docsum_field_info_Base::SetField_type(CEntrez2_docsum_field_info_Base::TField_type value)
{
    m_Field_type = value;
    m_set_State[0] |= 0x30;
}

inline
CEntrez2_docsum_field_info_Base::TField_type& CEntrez2_docsum_field_info_Base::SetField_type(void)
{
#ifdef _DEBUG
    if (!IsSetField_type()) {
        memset(&m_Field_type,UnassignedByte(),sizeof(m_Field_type));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Field_type;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ENTREZ2_ENTREZ2_DOCSUM_FIELD_INFO_BASE_HPP
