/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Entrez2_dt_filter_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'entrez2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ENTREZ2_ENTREZ2_DT_FILTER_BASE_HPP
#define OBJECTS_ENTREZ2_ENTREZ2_DT_FILTER_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/entrez2/Entrez2_dt.hpp>
#include <objects/entrez2/Entrez2_field_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ENTREZ2_EXPORT CEntrez2_dt_filter_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CEntrez2_dt_filter_Base(void);
    // destructor
    virtual ~CEntrez2_dt_filter_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CEntrez2_dt TBegin_date;
    typedef CEntrez2_dt TEnd_date;
    typedef CEntrez2_field_id TType_date;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_begin_date,
        e_end_date,
        e_type_date
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CEntrez2_dt TBegin_date
    ///  Check whether the Begin_date data member has been assigned a value.
    bool IsSetBegin_date(void) const;
    /// Check whether it is safe or not to call GetBegin_date method.
    bool CanGetBegin_date(void) const;
    void ResetBegin_date(void);
    const TBegin_date& GetBegin_date(void) const;
    void SetBegin_date(const TBegin_date& value);
    TBegin_date& SetBegin_date(void);

    /// mandatory
    /// typedef CEntrez2_dt TEnd_date
    ///  Check whether the End_date data member has been assigned a value.
    bool IsSetEnd_date(void) const;
    /// Check whether it is safe or not to call GetEnd_date method.
    bool CanGetEnd_date(void) const;
    void ResetEnd_date(void);
    const TEnd_date& GetEnd_date(void) const;
    void SetEnd_date(const TEnd_date& value);
    TEnd_date& SetEnd_date(void);

    /// mandatory
    /// typedef CEntrez2_field_id TType_date
    ///  Check whether the Type_date data member has been assigned a value.
    bool IsSetType_date(void) const;
    /// Check whether it is safe or not to call GetType_date method.
    bool CanGetType_date(void) const;
    void ResetType_date(void);
    const TType_date& GetType_date(void) const;
    void SetType_date(const TType_date& value);
    TType_date& SetType_date(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEntrez2_dt_filter_Base(const CEntrez2_dt_filter_Base&);
    CEntrez2_dt_filter_Base& operator=(const CEntrez2_dt_filter_Base&);

    // data
    Uint4 m_set_State[1];
    CEntrez2_dt m_Begin_date;
    CEntrez2_dt m_End_date;
    CEntrez2_field_id m_Type_date;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEntrez2_dt_filter_Base::IsSetBegin_date(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CEntrez2_dt_filter_Base::CanGetBegin_date(void) const
{
    return IsSetBegin_date();
}

inline
void CEntrez2_dt_filter_Base::ResetBegin_date(void)
{
    m_Begin_date = CEntrez2_dt(0);
    m_set_State[0] &= ~0x3;
}

inline
const CEntrez2_dt_filter_Base::TBegin_date& CEntrez2_dt_filter_Base::GetBegin_date(void) const
{
    if (!CanGetBegin_date()) {
        ThrowUnassigned(0);
    }
    return m_Begin_date;
}

inline
void CEntrez2_dt_filter_Base::SetBegin_date(const CEntrez2_dt_filter_Base::TBegin_date& value)
{
    m_Begin_date = value;
    m_set_State[0] |= 0x3;
}

inline
CEntrez2_dt_filter_Base::TBegin_date& CEntrez2_dt_filter_Base::SetBegin_date(void)
{
    m_set_State[0] |= 0x1;
    return m_Begin_date;
}

inline
bool CEntrez2_dt_filter_Base::IsSetEnd_date(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CEntrez2_dt_filter_Base::CanGetEnd_date(void) const
{
    return IsSetEnd_date();
}

inline
void CEntrez2_dt_filter_Base::ResetEnd_date(void)
{
    m_End_date = CEntrez2_dt(0);
    m_set_State[0] &= ~0xc;
}

inline
const CEntrez2_dt_filter_Base::TEnd_date& CEntrez2_dt_filter_Base::GetEnd_date(void) const
{
    if (!CanGetEnd_date()) {
        ThrowUnassigned(1);
    }
    return m_End_date;
}

inline
void CEntrez2_dt_filter_Base::SetEnd_date(const CEntrez2_dt_filter_Base::TEnd_date& value)
{
    m_End_date = value;
    m_set_State[0] |= 0xc;
}

inline
CEntrez2_dt_filter_Base::TEnd_date& CEntrez2_dt_filter_Base::SetEnd_date(void)
{
    m_set_State[0] |= 0x4;
    return m_End_date;
}

inline
bool CEntrez2_dt_filter_Base::IsSetType_date(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CEntrez2_dt_filter_Base::CanGetType_date(void) const
{
    return IsSetType_date();
}

inline
const CEntrez2_dt_filter_Base::TType_date& CEntrez2_dt_filter_Base::GetType_date(void) const
{
    if (!CanGetType_date()) {
        ThrowUnassigned(2);
    }
    return m_Type_date;
}

inline
void CEntrez2_dt_filter_Base::SetType_date(const CEntrez2_dt_filter_Base::TType_date& value)
{
    m_Type_date = value;
    m_set_State[0] |= 0x30;
}

inline
CEntrez2_dt_filter_Base::TType_date& CEntrez2_dt_filter_Base::SetType_date(void)
{
    m_set_State[0] |= 0x10;
    return m_Type_date;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ENTREZ2_ENTREZ2_DT_FILTER_BASE_HPP
