/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Entrez2_id_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'entrez2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ENTREZ2_ENTREZ2_ID_BASE_HPP
#define OBJECTS_ENTREZ2_ENTREZ2_ID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/entrez2/Entrez2_db_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// a single UID
class NCBI_ENTREZ2_EXPORT CEntrez2_id_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CEntrez2_id_Base(void);
    // destructor
    virtual ~CEntrez2_id_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CEntrez2_db_id TDb;
    typedef NCBI_NS_NCBI::TEntrezId TUid;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_db,
        e_uid
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CEntrez2_db_id TDb
    ///  Check whether the Db data member has been assigned a value.
    bool IsSetDb(void) const;
    /// Check whether it is safe or not to call GetDb method.
    bool CanGetDb(void) const;
    void ResetDb(void);
    const TDb& GetDb(void) const;
    void SetDb(const TDb& value);
    TDb& SetDb(void);

    /// mandatory
    /// typedef NCBI_NS_NCBI::TEntrezId TUid
    ///  Check whether the Uid data member has been assigned a value.
    bool IsSetUid(void) const;
    /// Check whether it is safe or not to call GetUid method.
    bool CanGetUid(void) const;
    void ResetUid(void);
    TUid GetUid(void) const;
    void SetUid(TUid value);
    TUid& SetUid(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEntrez2_id_Base(const CEntrez2_id_Base&);
    CEntrez2_id_Base& operator=(const CEntrez2_id_Base&);

    // data
    Uint4 m_set_State[1];
    CEntrez2_db_id m_Db;
    ncbi::TIntId m_Uid;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEntrez2_id_Base::IsSetDb(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CEntrez2_id_Base::CanGetDb(void) const
{
    return IsSetDb();
}

inline
const CEntrez2_id_Base::TDb& CEntrez2_id_Base::GetDb(void) const
{
    if (!CanGetDb()) {
        ThrowUnassigned(0);
    }
    return m_Db;
}

inline
void CEntrez2_id_Base::SetDb(const CEntrez2_id_Base::TDb& value)
{
    m_Db = value;
    m_set_State[0] |= 0x3;
}

inline
CEntrez2_id_Base::TDb& CEntrez2_id_Base::SetDb(void)
{
    m_set_State[0] |= 0x1;
    return m_Db;
}

inline
bool CEntrez2_id_Base::IsSetUid(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CEntrez2_id_Base::CanGetUid(void) const
{
    return IsSetUid();
}

inline
void CEntrez2_id_Base::ResetUid(void)
{
    m_Uid = 0;
    m_set_State[0] &= ~0xc;
}

inline
CEntrez2_id_Base::TUid CEntrez2_id_Base::GetUid(void) const
{
    if (!CanGetUid()) {
        ThrowUnassigned(1);
    }
    return reinterpret_cast<const TUid&>(m_Uid);
}

inline
void CEntrez2_id_Base::SetUid(CEntrez2_id_Base::TUid value)
{
    reinterpret_cast<TUid&>(m_Uid) = value;
    m_set_State[0] |= 0xc;
}

inline
CEntrez2_id_Base::TUid& CEntrez2_id_Base::SetUid(void)
{
#ifdef _DEBUG
    if (!IsSetUid()) {
        memset(&m_Uid,UnassignedByte(),sizeof(m_Uid));
    }
#endif
    m_set_State[0] |= 0x4;
    return reinterpret_cast<TUid&>(m_Uid);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ENTREZ2_ENTREZ2_ID_BASE_HPP
