/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Gene_commentary_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'entrezgene.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ENTREZGENE_GENE_COMMENTARY_BASE_HPP
#define OBJECTS_ENTREZGENE_GENE_COMMENTARY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDate;
class CGene_commentary;
class COther_source;
class CPub;
class CRNA_ref;
class CSeq_loc;
class CXtra_Terms;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ENTREZGENE_EXPORT CGene_commentary_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGene_commentary_Base(void);
    // destructor
    virtual ~CGene_commentary_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// type of Gene Commentary
    enum EType {
        eType_genomic        =   1,
        eType_pre_RNA        =   2,
        eType_mRNA           =   3,
        eType_rRNA           =   4,
        eType_tRNA           =   5,
        eType_snRNA          =   6,
        eType_scRNA          =   7,
        eType_peptide        =   8,
        eType_other_genetic  =   9,
        eType_genomic_mRNA   =  10,
        eType_cRNA           =  11,
        eType_mature_peptide =  12,
        eType_pre_protein    =  13,
        eType_miscRNA        =  14,
        eType_snoRNA         =  15,
        eType_property       =  16,  ///< used to display tag/value pair  for this type label is used as property tag, text is used as property value,   other fields are not used.
        eType_reference      =  17,  ///< currently not used             
        eType_generif        =  18,  ///< to include generif in the main blob             
        eType_phenotype      =  19,  ///< to display phenotype information
        eType_complex        =  20,  ///< used (but not limited) to identify resulting   interaction complexes
        eType_compound       =  21,  ///< pubchem entities
        eType_ncRNA          =  22,
        eType_gene_group     =  23,  ///< for relationship sets (such as pseudogene / parent gene)
        eType_assembly       =  24,  ///< for full assembly accession
        eType_assembly_unit  =  25,  ///< for the assembly unit corresponding to the refseq
        eType_c_region       =  26,
        eType_d_segment      =  27,
        eType_j_segment      =  28,
        eType_v_segment      =  29,
        eType_comment        = 254,
        eType_other          = 255
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    // types
    typedef int TType;
    typedef string THeading;
    typedef string TLabel;
    typedef string TText;
    typedef string TAccession;
    typedef int TVersion;
    typedef list< CRef< CXtra_Terms > > TXtra_properties;
    typedef list< CRef< CPub > > TRefs;
    typedef list< CRef< COther_source > > TSource;
    typedef list< CRef< CSeq_loc > > TGenomic_coords;
    typedef list< CRef< CSeq_loc > > TSeqs;
    typedef list< CRef< CGene_commentary > > TProducts;
    typedef list< CRef< CGene_commentary > > TProperties;
    typedef list< CRef< CGene_commentary > > TComment;
    typedef CDate TCreate_date;
    typedef CDate TUpdate_date;
    typedef CRNA_ref TRna;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_heading,
        e_label,
        e_text,
        e_accession,
        e_version,
        e_xtra_properties,
        e_refs,
        e_source,
        e_genomic_coords,
        e_seqs,
        e_products,
        e_properties,
        e_comment,
        e_create_date,
        e_update_date,
        e_rna
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 18> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// appears above text 
    /// optional
    /// typedef string THeading
    ///  Check whether the Heading data member has been assigned a value.
    bool IsSetHeading(void) const;
    /// Check whether it is safe or not to call GetHeading method.
    bool CanGetHeading(void) const;
    void ResetHeading(void);
    const THeading& GetHeading(void) const;
    void SetHeading(const THeading& value);
    void SetHeading(THeading&& value);
    THeading& SetHeading(void);

    /// occurs to left of text
    /// for protein and RNA types it is a name
    /// for property type it is a property tag  
    /// optional
    /// typedef string TLabel
    ///  Check whether the Label data member has been assigned a value.
    bool IsSetLabel(void) const;
    /// Check whether it is safe or not to call GetLabel method.
    bool CanGetLabel(void) const;
    void ResetLabel(void);
    const TLabel& GetLabel(void) const;
    void SetLabel(const TLabel& value);
    void SetLabel(TLabel&& value);
    TLabel& SetLabel(void);

    /// block of text 
    /// for property type it is a property value  
    /// optional
    /// typedef string TText
    ///  Check whether the Text data member has been assigned a value.
    bool IsSetText(void) const;
    /// Check whether it is safe or not to call GetText method.
    bool CanGetText(void) const;
    void ResetText(void);
    const TText& GetText(void) const;
    void SetText(const TText& value);
    void SetText(TText&& value);
    TText& SetText(void);

    /// accession for the gi in the seqloc, see note 3
    /// optional
    /// typedef string TAccession
    ///  Check whether the Accession data member has been assigned a value.
    bool IsSetAccession(void) const;
    /// Check whether it is safe or not to call GetAccession method.
    bool CanGetAccession(void) const;
    void ResetAccession(void);
    const TAccession& GetAccession(void) const;
    void SetAccession(const TAccession& value);
    void SetAccession(TAccession&& value);
    TAccession& SetAccession(void);

    /// version for the accession above
    /// optional
    /// typedef int TVersion
    ///  Check whether the Version data member has been assigned a value.
    bool IsSetVersion(void) const;
    /// Check whether it is safe or not to call GetVersion method.
    bool CanGetVersion(void) const;
    void ResetVersion(void);
    TVersion GetVersion(void) const;
    void SetVersion(TVersion value);
    TVersion& SetVersion(void);

    /// see note 2
    /// optional
    /// typedef list< CRef< CXtra_Terms > > TXtra_properties
    ///  Check whether the Xtra_properties data member has been assigned a value.
    bool IsSetXtra_properties(void) const;
    /// Check whether it is safe or not to call GetXtra_properties method.
    bool CanGetXtra_properties(void) const;
    void ResetXtra_properties(void);
    const TXtra_properties& GetXtra_properties(void) const;
    TXtra_properties& SetXtra_properties(void);

    /// refs for this 
    /// optional
    /// typedef list< CRef< CPub > > TRefs
    ///  Check whether the Refs data member has been assigned a value.
    bool IsSetRefs(void) const;
    /// Check whether it is safe or not to call GetRefs method.
    bool CanGetRefs(void) const;
    void ResetRefs(void);
    const TRefs& GetRefs(void) const;
    TRefs& SetRefs(void);

    /// links and refs 
    /// optional
    /// typedef list< CRef< COther_source > > TSource
    ///  Check whether the Source data member has been assigned a value.
    bool IsSetSource(void) const;
    /// Check whether it is safe or not to call GetSource method.
    bool CanGetSource(void) const;
    void ResetSource(void);
    const TSource& GetSource(void) const;
    TSource& SetSource(void);

    /// referenced sequences in genomic coords
    /// optional
    /// typedef list< CRef< CSeq_loc > > TGenomic_coords
    ///  Check whether the Genomic_coords data member has been assigned a value.
    bool IsSetGenomic_coords(void) const;
    /// Check whether it is safe or not to call GetGenomic_coords method.
    bool CanGetGenomic_coords(void) const;
    void ResetGenomic_coords(void);
    const TGenomic_coords& GetGenomic_coords(void) const;
    TGenomic_coords& SetGenomic_coords(void);

    /// referenced sequences in non-genomic coords
    /// optional
    /// typedef list< CRef< CSeq_loc > > TSeqs
    ///  Check whether the Seqs data member has been assigned a value.
    bool IsSetSeqs(void) const;
    /// Check whether it is safe or not to call GetSeqs method.
    bool CanGetSeqs(void) const;
    void ResetSeqs(void);
    const TSeqs& GetSeqs(void) const;
    TSeqs& SetSeqs(void);

    /// optional
    /// typedef list< CRef< CGene_commentary > > TProducts
    ///  Check whether the Products data member has been assigned a value.
    bool IsSetProducts(void) const;
    /// Check whether it is safe or not to call GetProducts method.
    bool CanGetProducts(void) const;
    void ResetProducts(void);
    const TProducts& GetProducts(void) const;
    TProducts& SetProducts(void);

    /// optional
    /// typedef list< CRef< CGene_commentary > > TProperties
    ///  Check whether the Properties data member has been assigned a value.
    bool IsSetProperties(void) const;
    /// Check whether it is safe or not to call GetProperties method.
    bool CanGetProperties(void) const;
    void ResetProperties(void);
    const TProperties& GetProperties(void) const;
    TProperties& SetProperties(void);

    /// optional
    /// typedef list< CRef< CGene_commentary > > TComment
    ///  Check whether the Comment data member has been assigned a value.
    bool IsSetComment(void) const;
    /// Check whether it is safe or not to call GetComment method.
    bool CanGetComment(void) const;
    void ResetComment(void);
    const TComment& GetComment(void) const;
    TComment& SetComment(void);

    /// optional
    /// typedef CDate TCreate_date
    ///  Check whether the Create_date data member has been assigned a value.
    bool IsSetCreate_date(void) const;
    /// Check whether it is safe or not to call GetCreate_date method.
    bool CanGetCreate_date(void) const;
    void ResetCreate_date(void);
    const TCreate_date& GetCreate_date(void) const;
    void SetCreate_date(TCreate_date& value);
    TCreate_date& SetCreate_date(void);

    /// optional
    /// typedef CDate TUpdate_date
    ///  Check whether the Update_date data member has been assigned a value.
    bool IsSetUpdate_date(void) const;
    /// Check whether it is safe or not to call GetUpdate_date method.
    bool CanGetUpdate_date(void) const;
    void ResetUpdate_date(void);
    const TUpdate_date& GetUpdate_date(void) const;
    void SetUpdate_date(TUpdate_date& value);
    TUpdate_date& SetUpdate_date(void);

    /// optional
    /// typedef CRNA_ref TRna
    ///  Check whether the Rna data member has been assigned a value.
    bool IsSetRna(void) const;
    /// Check whether it is safe or not to call GetRna method.
    bool CanGetRna(void) const;
    void ResetRna(void);
    const TRna& GetRna(void) const;
    void SetRna(TRna& value);
    TRna& SetRna(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGene_commentary_Base(const CGene_commentary_Base&);
    CGene_commentary_Base& operator=(const CGene_commentary_Base&);

    // data
    Uint4 m_set_State[2];
    int m_Type;
    string m_Heading;
    string m_Label;
    string m_Text;
    string m_Accession;
    int m_Version;
    list< CRef< CXtra_Terms > > m_Xtra_properties;
    list< CRef< CPub > > m_Refs;
    list< CRef< COther_source > > m_Source;
    list< CRef< CSeq_loc > > m_Genomic_coords;
    list< CRef< CSeq_loc > > m_Seqs;
    list< CRef< CGene_commentary > > m_Products;
    list< CRef< CGene_commentary > > m_Properties;
    list< CRef< CGene_commentary > > m_Comment;
    CRef< TCreate_date > m_Create_date;
    CRef< TUpdate_date > m_Update_date;
    CRef< TRna > m_Rna;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGene_commentary_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGene_commentary_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CGene_commentary_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0x3;
}

inline
CGene_commentary_Base::TType CGene_commentary_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CGene_commentary_Base::SetType(CGene_commentary_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CGene_commentary_Base::TType& CGene_commentary_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CGene_commentary_Base::IsSetHeading(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGene_commentary_Base::CanGetHeading(void) const
{
    return IsSetHeading();
}

inline
const CGene_commentary_Base::THeading& CGene_commentary_Base::GetHeading(void) const
{
    if (!CanGetHeading()) {
        ThrowUnassigned(1);
    }
    return m_Heading;
}

inline
void CGene_commentary_Base::SetHeading(const CGene_commentary_Base::THeading& value)
{
    m_Heading = value;
    m_set_State[0] |= 0xc;
}

inline
void CGene_commentary_Base::SetHeading(CGene_commentary_Base::THeading&& value)
{
    m_Heading = std::forward<CGene_commentary_Base::THeading>(value);
    m_set_State[0] |= 0xc;
}

inline
CGene_commentary_Base::THeading& CGene_commentary_Base::SetHeading(void)
{
#ifdef _DEBUG
    if (!IsSetHeading()) {
        m_Heading = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Heading;
}

inline
bool CGene_commentary_Base::IsSetLabel(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CGene_commentary_Base::CanGetLabel(void) const
{
    return IsSetLabel();
}

inline
const CGene_commentary_Base::TLabel& CGene_commentary_Base::GetLabel(void) const
{
    if (!CanGetLabel()) {
        ThrowUnassigned(2);
    }
    return m_Label;
}

inline
void CGene_commentary_Base::SetLabel(const CGene_commentary_Base::TLabel& value)
{
    m_Label = value;
    m_set_State[0] |= 0x30;
}

inline
void CGene_commentary_Base::SetLabel(CGene_commentary_Base::TLabel&& value)
{
    m_Label = std::forward<CGene_commentary_Base::TLabel>(value);
    m_set_State[0] |= 0x30;
}

inline
CGene_commentary_Base::TLabel& CGene_commentary_Base::SetLabel(void)
{
#ifdef _DEBUG
    if (!IsSetLabel()) {
        m_Label = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Label;
}

inline
bool CGene_commentary_Base::IsSetText(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CGene_commentary_Base::CanGetText(void) const
{
    return IsSetText();
}

inline
const CGene_commentary_Base::TText& CGene_commentary_Base::GetText(void) const
{
    if (!CanGetText()) {
        ThrowUnassigned(3);
    }
    return m_Text;
}

inline
void CGene_commentary_Base::SetText(const CGene_commentary_Base::TText& value)
{
    m_Text = value;
    m_set_State[0] |= 0xc0;
}

inline
void CGene_commentary_Base::SetText(CGene_commentary_Base::TText&& value)
{
    m_Text = std::forward<CGene_commentary_Base::TText>(value);
    m_set_State[0] |= 0xc0;
}

inline
CGene_commentary_Base::TText& CGene_commentary_Base::SetText(void)
{
#ifdef _DEBUG
    if (!IsSetText()) {
        m_Text = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Text;
}

inline
bool CGene_commentary_Base::IsSetAccession(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CGene_commentary_Base::CanGetAccession(void) const
{
    return IsSetAccession();
}

inline
const CGene_commentary_Base::TAccession& CGene_commentary_Base::GetAccession(void) const
{
    if (!CanGetAccession()) {
        ThrowUnassigned(4);
    }
    return m_Accession;
}

inline
void CGene_commentary_Base::SetAccession(const CGene_commentary_Base::TAccession& value)
{
    m_Accession = value;
    m_set_State[0] |= 0x300;
}

inline
void CGene_commentary_Base::SetAccession(CGene_commentary_Base::TAccession&& value)
{
    m_Accession = std::forward<CGene_commentary_Base::TAccession>(value);
    m_set_State[0] |= 0x300;
}

inline
CGene_commentary_Base::TAccession& CGene_commentary_Base::SetAccession(void)
{
#ifdef _DEBUG
    if (!IsSetAccession()) {
        m_Accession = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Accession;
}

inline
bool CGene_commentary_Base::IsSetVersion(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CGene_commentary_Base::CanGetVersion(void) const
{
    return IsSetVersion();
}

inline
void CGene_commentary_Base::ResetVersion(void)
{
    m_Version = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CGene_commentary_Base::TVersion CGene_commentary_Base::GetVersion(void) const
{
    if (!CanGetVersion()) {
        ThrowUnassigned(5);
    }
    return m_Version;
}

inline
void CGene_commentary_Base::SetVersion(CGene_commentary_Base::TVersion value)
{
    m_Version = value;
    m_set_State[0] |= 0xc00;
}

inline
CGene_commentary_Base::TVersion& CGene_commentary_Base::SetVersion(void)
{
#ifdef _DEBUG
    if (!IsSetVersion()) {
        memset(&m_Version,UnassignedByte(),sizeof(m_Version));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Version;
}

inline
bool CGene_commentary_Base::IsSetXtra_properties(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CGene_commentary_Base::CanGetXtra_properties(void) const
{
    return true;
}

inline
const CGene_commentary_Base::TXtra_properties& CGene_commentary_Base::GetXtra_properties(void) const
{
    return m_Xtra_properties;
}

inline
CGene_commentary_Base::TXtra_properties& CGene_commentary_Base::SetXtra_properties(void)
{
    m_set_State[0] |= 0x1000;
    return m_Xtra_properties;
}

inline
bool CGene_commentary_Base::IsSetRefs(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CGene_commentary_Base::CanGetRefs(void) const
{
    return true;
}

inline
const CGene_commentary_Base::TRefs& CGene_commentary_Base::GetRefs(void) const
{
    return m_Refs;
}

inline
CGene_commentary_Base::TRefs& CGene_commentary_Base::SetRefs(void)
{
    m_set_State[0] |= 0x4000;
    return m_Refs;
}

inline
bool CGene_commentary_Base::IsSetSource(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CGene_commentary_Base::CanGetSource(void) const
{
    return true;
}

inline
const CGene_commentary_Base::TSource& CGene_commentary_Base::GetSource(void) const
{
    return m_Source;
}

inline
CGene_commentary_Base::TSource& CGene_commentary_Base::SetSource(void)
{
    m_set_State[0] |= 0x10000;
    return m_Source;
}

inline
bool CGene_commentary_Base::IsSetGenomic_coords(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CGene_commentary_Base::CanGetGenomic_coords(void) const
{
    return true;
}

inline
const CGene_commentary_Base::TGenomic_coords& CGene_commentary_Base::GetGenomic_coords(void) const
{
    return m_Genomic_coords;
}

inline
CGene_commentary_Base::TGenomic_coords& CGene_commentary_Base::SetGenomic_coords(void)
{
    m_set_State[0] |= 0x40000;
    return m_Genomic_coords;
}

inline
bool CGene_commentary_Base::IsSetSeqs(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CGene_commentary_Base::CanGetSeqs(void) const
{
    return true;
}

inline
const CGene_commentary_Base::TSeqs& CGene_commentary_Base::GetSeqs(void) const
{
    return m_Seqs;
}

inline
CGene_commentary_Base::TSeqs& CGene_commentary_Base::SetSeqs(void)
{
    m_set_State[0] |= 0x100000;
    return m_Seqs;
}

inline
bool CGene_commentary_Base::IsSetProducts(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CGene_commentary_Base::CanGetProducts(void) const
{
    return true;
}

inline
const CGene_commentary_Base::TProducts& CGene_commentary_Base::GetProducts(void) const
{
    return m_Products;
}

inline
CGene_commentary_Base::TProducts& CGene_commentary_Base::SetProducts(void)
{
    m_set_State[0] |= 0x400000;
    return m_Products;
}

inline
bool CGene_commentary_Base::IsSetProperties(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CGene_commentary_Base::CanGetProperties(void) const
{
    return true;
}

inline
const CGene_commentary_Base::TProperties& CGene_commentary_Base::GetProperties(void) const
{
    return m_Properties;
}

inline
CGene_commentary_Base::TProperties& CGene_commentary_Base::SetProperties(void)
{
    m_set_State[0] |= 0x1000000;
    return m_Properties;
}

inline
bool CGene_commentary_Base::IsSetComment(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CGene_commentary_Base::CanGetComment(void) const
{
    return true;
}

inline
const CGene_commentary_Base::TComment& CGene_commentary_Base::GetComment(void) const
{
    return m_Comment;
}

inline
CGene_commentary_Base::TComment& CGene_commentary_Base::SetComment(void)
{
    m_set_State[0] |= 0x4000000;
    return m_Comment;
}

inline
bool CGene_commentary_Base::IsSetCreate_date(void) const
{
    return m_Create_date.NotEmpty();
}

inline
bool CGene_commentary_Base::CanGetCreate_date(void) const
{
    return IsSetCreate_date();
}

inline
const CGene_commentary_Base::TCreate_date& CGene_commentary_Base::GetCreate_date(void) const
{
    if (!CanGetCreate_date()) {
        ThrowUnassigned(14);
    }
    return (*m_Create_date);
}

inline
bool CGene_commentary_Base::IsSetUpdate_date(void) const
{
    return m_Update_date.NotEmpty();
}

inline
bool CGene_commentary_Base::CanGetUpdate_date(void) const
{
    return IsSetUpdate_date();
}

inline
const CGene_commentary_Base::TUpdate_date& CGene_commentary_Base::GetUpdate_date(void) const
{
    if (!CanGetUpdate_date()) {
        ThrowUnassigned(15);
    }
    return (*m_Update_date);
}

inline
bool CGene_commentary_Base::IsSetRna(void) const
{
    return m_Rna.NotEmpty();
}

inline
bool CGene_commentary_Base::CanGetRna(void) const
{
    return IsSetRna();
}

inline
const CGene_commentary_Base::TRna& CGene_commentary_Base::GetRna(void) const
{
    if (!CanGetRna()) {
        ThrowUnassigned(16);
    }
    return (*m_Rna);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ENTREZGENE_GENE_COMMENTARY_BASE_HPP
