/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file FeatDef_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'featdef.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_FEATDEF_FEATDEF_BASE_HPP
#define OBJECTS_FEATDEF_FEATDEF_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/featdef/FeatMolType.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_FEATDEF_EXPORT CFeatDef_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CFeatDef_Base(void);
    // destructor
    virtual ~CFeatDef_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TTypelabel;
    typedef string TMenulabel;
    typedef int TFeatdef_key;
    typedef int TSeqfeat_key;
    typedef int TEntrygroup;
    typedef int TDisplaygroup;
    typedef EFeatMolType TMolgroup;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_typelabel,
        e_menulabel,
        e_featdef_key,
        e_seqfeat_key,
        e_entrygroup,
        e_displaygroup,
        e_molgroup
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// short label for type eg "CDS"
    /// mandatory
    /// typedef string TTypelabel
    ///  Check whether the Typelabel data member has been assigned a value.
    bool IsSetTypelabel(void) const;
    /// Check whether it is safe or not to call GetTypelabel method.
    bool CanGetTypelabel(void) const;
    void ResetTypelabel(void);
    const TTypelabel& GetTypelabel(void) const;
    void SetTypelabel(const TTypelabel& value);
    void SetTypelabel(TTypelabel&& value);
    TTypelabel& SetTypelabel(void);

    /// label for a menu eg "Coding Region"
    /// mandatory
    /// typedef string TMenulabel
    ///  Check whether the Menulabel data member has been assigned a value.
    bool IsSetMenulabel(void) const;
    /// Check whether it is safe or not to call GetMenulabel method.
    bool CanGetMenulabel(void) const;
    void ResetMenulabel(void);
    const TMenulabel& GetMenulabel(void) const;
    void SetMenulabel(const TMenulabel& value);
    void SetMenulabel(TMenulabel&& value);
    TMenulabel& SetMenulabel(void);

    /// unique for this feature definition
    /// mandatory
    /// typedef int TFeatdef_key
    ///  Check whether the Featdef_key data member has been assigned a value.
    bool IsSetFeatdef_key(void) const;
    /// Check whether it is safe or not to call GetFeatdef_key method.
    bool CanGetFeatdef_key(void) const;
    void ResetFeatdef_key(void);
    TFeatdef_key GetFeatdef_key(void) const;
    void SetFeatdef_key(TFeatdef_key value);
    TFeatdef_key& SetFeatdef_key(void);

    /// SeqFeat.data.choice from objfeat.h
    /// mandatory
    /// typedef int TSeqfeat_key
    ///  Check whether the Seqfeat_key data member has been assigned a value.
    bool IsSetSeqfeat_key(void) const;
    /// Check whether it is safe or not to call GetSeqfeat_key method.
    bool CanGetSeqfeat_key(void) const;
    void ResetSeqfeat_key(void);
    TSeqfeat_key GetSeqfeat_key(void) const;
    void SetSeqfeat_key(TSeqfeat_key value);
    TSeqfeat_key& SetSeqfeat_key(void);

    /// Group for data entry
    /// mandatory
    /// typedef int TEntrygroup
    ///  Check whether the Entrygroup data member has been assigned a value.
    bool IsSetEntrygroup(void) const;
    /// Check whether it is safe or not to call GetEntrygroup method.
    bool CanGetEntrygroup(void) const;
    void ResetEntrygroup(void);
    TEntrygroup GetEntrygroup(void) const;
    void SetEntrygroup(TEntrygroup value);
    TEntrygroup& SetEntrygroup(void);

    /// Group for data display
    /// mandatory
    /// typedef int TDisplaygroup
    ///  Check whether the Displaygroup data member has been assigned a value.
    bool IsSetDisplaygroup(void) const;
    /// Check whether it is safe or not to call GetDisplaygroup method.
    bool CanGetDisplaygroup(void) const;
    void ResetDisplaygroup(void);
    TDisplaygroup GetDisplaygroup(void) const;
    void SetDisplaygroup(TDisplaygroup value);
    TDisplaygroup& SetDisplaygroup(void);

    /// Type of Molecule used for
    /// mandatory
    /// typedef EFeatMolType TMolgroup
    ///  Check whether the Molgroup data member has been assigned a value.
    bool IsSetMolgroup(void) const;
    /// Check whether it is safe or not to call GetMolgroup method.
    bool CanGetMolgroup(void) const;
    void ResetMolgroup(void);
    TMolgroup GetMolgroup(void) const;
    void SetMolgroup(TMolgroup value);
    TMolgroup& SetMolgroup(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CFeatDef_Base(const CFeatDef_Base&);
    CFeatDef_Base& operator=(const CFeatDef_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Typelabel;
    string m_Menulabel;
    int m_Featdef_key;
    int m_Seqfeat_key;
    int m_Entrygroup;
    int m_Displaygroup;
    EFeatMolType m_Molgroup;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CFeatDef_Base::IsSetTypelabel(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CFeatDef_Base::CanGetTypelabel(void) const
{
    return IsSetTypelabel();
}

inline
const CFeatDef_Base::TTypelabel& CFeatDef_Base::GetTypelabel(void) const
{
    if (!CanGetTypelabel()) {
        ThrowUnassigned(0);
    }
    return m_Typelabel;
}

inline
void CFeatDef_Base::SetTypelabel(const CFeatDef_Base::TTypelabel& value)
{
    m_Typelabel = value;
    m_set_State[0] |= 0x3;
}

inline
void CFeatDef_Base::SetTypelabel(CFeatDef_Base::TTypelabel&& value)
{
    m_Typelabel = std::forward<CFeatDef_Base::TTypelabel>(value);
    m_set_State[0] |= 0x3;
}

inline
CFeatDef_Base::TTypelabel& CFeatDef_Base::SetTypelabel(void)
{
#ifdef _DEBUG
    if (!IsSetTypelabel()) {
        m_Typelabel = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Typelabel;
}

inline
bool CFeatDef_Base::IsSetMenulabel(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CFeatDef_Base::CanGetMenulabel(void) const
{
    return IsSetMenulabel();
}

inline
const CFeatDef_Base::TMenulabel& CFeatDef_Base::GetMenulabel(void) const
{
    if (!CanGetMenulabel()) {
        ThrowUnassigned(1);
    }
    return m_Menulabel;
}

inline
void CFeatDef_Base::SetMenulabel(const CFeatDef_Base::TMenulabel& value)
{
    m_Menulabel = value;
    m_set_State[0] |= 0xc;
}

inline
void CFeatDef_Base::SetMenulabel(CFeatDef_Base::TMenulabel&& value)
{
    m_Menulabel = std::forward<CFeatDef_Base::TMenulabel>(value);
    m_set_State[0] |= 0xc;
}

inline
CFeatDef_Base::TMenulabel& CFeatDef_Base::SetMenulabel(void)
{
#ifdef _DEBUG
    if (!IsSetMenulabel()) {
        m_Menulabel = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Menulabel;
}

inline
bool CFeatDef_Base::IsSetFeatdef_key(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CFeatDef_Base::CanGetFeatdef_key(void) const
{
    return IsSetFeatdef_key();
}

inline
void CFeatDef_Base::ResetFeatdef_key(void)
{
    m_Featdef_key = 0;
    m_set_State[0] &= ~0x30;
}

inline
CFeatDef_Base::TFeatdef_key CFeatDef_Base::GetFeatdef_key(void) const
{
    if (!CanGetFeatdef_key()) {
        ThrowUnassigned(2);
    }
    return m_Featdef_key;
}

inline
void CFeatDef_Base::SetFeatdef_key(CFeatDef_Base::TFeatdef_key value)
{
    m_Featdef_key = value;
    m_set_State[0] |= 0x30;
}

inline
CFeatDef_Base::TFeatdef_key& CFeatDef_Base::SetFeatdef_key(void)
{
#ifdef _DEBUG
    if (!IsSetFeatdef_key()) {
        memset(&m_Featdef_key,UnassignedByte(),sizeof(m_Featdef_key));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Featdef_key;
}

inline
bool CFeatDef_Base::IsSetSeqfeat_key(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CFeatDef_Base::CanGetSeqfeat_key(void) const
{
    return IsSetSeqfeat_key();
}

inline
void CFeatDef_Base::ResetSeqfeat_key(void)
{
    m_Seqfeat_key = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CFeatDef_Base::TSeqfeat_key CFeatDef_Base::GetSeqfeat_key(void) const
{
    if (!CanGetSeqfeat_key()) {
        ThrowUnassigned(3);
    }
    return m_Seqfeat_key;
}

inline
void CFeatDef_Base::SetSeqfeat_key(CFeatDef_Base::TSeqfeat_key value)
{
    m_Seqfeat_key = value;
    m_set_State[0] |= 0xc0;
}

inline
CFeatDef_Base::TSeqfeat_key& CFeatDef_Base::SetSeqfeat_key(void)
{
#ifdef _DEBUG
    if (!IsSetSeqfeat_key()) {
        memset(&m_Seqfeat_key,UnassignedByte(),sizeof(m_Seqfeat_key));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Seqfeat_key;
}

inline
bool CFeatDef_Base::IsSetEntrygroup(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CFeatDef_Base::CanGetEntrygroup(void) const
{
    return IsSetEntrygroup();
}

inline
void CFeatDef_Base::ResetEntrygroup(void)
{
    m_Entrygroup = 0;
    m_set_State[0] &= ~0x300;
}

inline
CFeatDef_Base::TEntrygroup CFeatDef_Base::GetEntrygroup(void) const
{
    if (!CanGetEntrygroup()) {
        ThrowUnassigned(4);
    }
    return m_Entrygroup;
}

inline
void CFeatDef_Base::SetEntrygroup(CFeatDef_Base::TEntrygroup value)
{
    m_Entrygroup = value;
    m_set_State[0] |= 0x300;
}

inline
CFeatDef_Base::TEntrygroup& CFeatDef_Base::SetEntrygroup(void)
{
#ifdef _DEBUG
    if (!IsSetEntrygroup()) {
        memset(&m_Entrygroup,UnassignedByte(),sizeof(m_Entrygroup));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Entrygroup;
}

inline
bool CFeatDef_Base::IsSetDisplaygroup(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CFeatDef_Base::CanGetDisplaygroup(void) const
{
    return IsSetDisplaygroup();
}

inline
void CFeatDef_Base::ResetDisplaygroup(void)
{
    m_Displaygroup = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CFeatDef_Base::TDisplaygroup CFeatDef_Base::GetDisplaygroup(void) const
{
    if (!CanGetDisplaygroup()) {
        ThrowUnassigned(5);
    }
    return m_Displaygroup;
}

inline
void CFeatDef_Base::SetDisplaygroup(CFeatDef_Base::TDisplaygroup value)
{
    m_Displaygroup = value;
    m_set_State[0] |= 0xc00;
}

inline
CFeatDef_Base::TDisplaygroup& CFeatDef_Base::SetDisplaygroup(void)
{
#ifdef _DEBUG
    if (!IsSetDisplaygroup()) {
        memset(&m_Displaygroup,UnassignedByte(),sizeof(m_Displaygroup));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Displaygroup;
}

inline
bool CFeatDef_Base::IsSetMolgroup(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CFeatDef_Base::CanGetMolgroup(void) const
{
    return IsSetMolgroup();
}

inline
void CFeatDef_Base::ResetMolgroup(void)
{
    m_Molgroup = (ncbi::objects::EFeatMolType)(0);
    m_set_State[0] &= ~0x3000;
}

inline
CFeatDef_Base::TMolgroup CFeatDef_Base::GetMolgroup(void) const
{
    if (!CanGetMolgroup()) {
        ThrowUnassigned(6);
    }
    return m_Molgroup;
}

inline
void CFeatDef_Base::SetMolgroup(CFeatDef_Base::TMolgroup value)
{
    m_Molgroup = value;
    m_set_State[0] |= 0x3000;
}

inline
CFeatDef_Base::TMolgroup& CFeatDef_Base::SetMolgroup(void)
{
#ifdef _DEBUG
    if (!IsSetMolgroup()) {
        memset(&m_Molgroup,UnassignedByte(),sizeof(m_Molgroup));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Molgroup;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_FEATDEF_FEATDEF_BASE_HPP
