/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file LoaderDescriptor_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'gbproj.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GBPROJ_LOADERDESCRIPTOR_BASE_HPP
#define OBJECTS_GBPROJ_LOADERDESCRIPTOR_BASE_HPP

// extra headers
#include <objects/gbproj/gbproj_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CUser_object;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_GBPROJ_EXPORT CLoaderDescriptor_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CLoaderDescriptor_Base(void);
    // destructor
    virtual ~CLoaderDescriptor_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TLabel;
    typedef string TLoader_type;
    typedef CUser_object TData;
    typedef bool TEnabled;
    typedef int TPriority;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_label,
        e_loader_type,
        e_data,
        e_enabled,
        e_priority
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// data loader label
    /// mandatory
    /// typedef string TLabel
    ///  Check whether the Label data member has been assigned a value.
    bool IsSetLabel(void) const;
    /// Check whether it is safe or not to call GetLabel method.
    bool CanGetLabel(void) const;
    void ResetLabel(void);
    const TLabel& GetLabel(void) const;
    void SetLabel(const TLabel& value);
    void SetLabel(TLabel&& value);
    TLabel& SetLabel(void);

    /// loader data source type
    /// mandatory
    /// typedef string TLoader_type
    ///  Check whether the Loader_type data member has been assigned a value.
    bool IsSetLoader_type(void) const;
    /// Check whether it is safe or not to call GetLoader_type method.
    bool CanGetLoader_type(void) const;
    void ResetLoader_type(void);
    const TLoader_type& GetLoader_type(void) const;
    void SetLoader_type(const TLoader_type& value);
    void SetLoader_type(TLoader_type&& value);
    TLoader_type& SetLoader_type(void);

    /// data, depends on loader type
    /// mandatory
    /// typedef CUser_object TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    void SetData(TData& value);
    TData& SetData(void);

    /// flag: is this data loader enabled?
    /// optional with default true
    /// typedef bool TEnabled
    ///  Check whether the Enabled data member has been assigned a value.
    bool IsSetEnabled(void) const;
    /// Check whether it is safe or not to call GetEnabled method.
    bool CanGetEnabled(void) const;
    void ResetEnabled(void);
    void SetDefaultEnabled(void);
    TEnabled GetEnabled(void) const;
    void SetEnabled(TEnabled value);
    TEnabled& SetEnabled(void);

    /// loader priority used in object manager
    /// optional
    /// typedef int TPriority
    ///  Check whether the Priority data member has been assigned a value.
    bool IsSetPriority(void) const;
    /// Check whether it is safe or not to call GetPriority method.
    bool CanGetPriority(void) const;
    void ResetPriority(void);
    TPriority GetPriority(void) const;
    void SetPriority(TPriority value);
    TPriority& SetPriority(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CLoaderDescriptor_Base(const CLoaderDescriptor_Base&);
    CLoaderDescriptor_Base& operator=(const CLoaderDescriptor_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Label;
    string m_Loader_type;
    CRef< TData > m_Data;
    bool m_Enabled;
    int m_Priority;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CLoaderDescriptor_Base::IsSetLabel(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CLoaderDescriptor_Base::CanGetLabel(void) const
{
    return IsSetLabel();
}

inline
const CLoaderDescriptor_Base::TLabel& CLoaderDescriptor_Base::GetLabel(void) const
{
    if (!CanGetLabel()) {
        ThrowUnassigned(0);
    }
    return m_Label;
}

inline
void CLoaderDescriptor_Base::SetLabel(const CLoaderDescriptor_Base::TLabel& value)
{
    m_Label = value;
    m_set_State[0] |= 0x3;
}

inline
void CLoaderDescriptor_Base::SetLabel(CLoaderDescriptor_Base::TLabel&& value)
{
    m_Label = std::forward<CLoaderDescriptor_Base::TLabel>(value);
    m_set_State[0] |= 0x3;
}

inline
CLoaderDescriptor_Base::TLabel& CLoaderDescriptor_Base::SetLabel(void)
{
#ifdef _DEBUG
    if (!IsSetLabel()) {
        m_Label = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Label;
}

inline
bool CLoaderDescriptor_Base::IsSetLoader_type(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CLoaderDescriptor_Base::CanGetLoader_type(void) const
{
    return IsSetLoader_type();
}

inline
const CLoaderDescriptor_Base::TLoader_type& CLoaderDescriptor_Base::GetLoader_type(void) const
{
    if (!CanGetLoader_type()) {
        ThrowUnassigned(1);
    }
    return m_Loader_type;
}

inline
void CLoaderDescriptor_Base::SetLoader_type(const CLoaderDescriptor_Base::TLoader_type& value)
{
    m_Loader_type = value;
    m_set_State[0] |= 0xc;
}

inline
void CLoaderDescriptor_Base::SetLoader_type(CLoaderDescriptor_Base::TLoader_type&& value)
{
    m_Loader_type = std::forward<CLoaderDescriptor_Base::TLoader_type>(value);
    m_set_State[0] |= 0xc;
}

inline
CLoaderDescriptor_Base::TLoader_type& CLoaderDescriptor_Base::SetLoader_type(void)
{
#ifdef _DEBUG
    if (!IsSetLoader_type()) {
        m_Loader_type = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Loader_type;
}

inline
bool CLoaderDescriptor_Base::IsSetData(void) const
{
    return m_Data.NotEmpty();
}

inline
bool CLoaderDescriptor_Base::CanGetData(void) const
{
    return true;
}

inline
const CLoaderDescriptor_Base::TData& CLoaderDescriptor_Base::GetData(void) const
{
    if ( !m_Data ) {
        const_cast<CLoaderDescriptor_Base*>(this)->ResetData();
    }
    return (*m_Data);
}

inline
CLoaderDescriptor_Base::TData& CLoaderDescriptor_Base::SetData(void)
{
    if ( !m_Data ) {
        ResetData();
    }
    return (*m_Data);
}

inline
bool CLoaderDescriptor_Base::IsSetEnabled(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CLoaderDescriptor_Base::CanGetEnabled(void) const
{
    return true;
}

inline
void CLoaderDescriptor_Base::ResetEnabled(void)
{
    m_Enabled = true;
    m_set_State[0] &= ~0xc0;
}

inline
void CLoaderDescriptor_Base::SetDefaultEnabled(void)
{
    ResetEnabled();
}

inline
CLoaderDescriptor_Base::TEnabled CLoaderDescriptor_Base::GetEnabled(void) const
{
    return m_Enabled;
}

inline
void CLoaderDescriptor_Base::SetEnabled(CLoaderDescriptor_Base::TEnabled value)
{
    m_Enabled = value;
    m_set_State[0] |= 0xc0;
}

inline
CLoaderDescriptor_Base::TEnabled& CLoaderDescriptor_Base::SetEnabled(void)
{
#ifdef _DEBUG
    if (!IsSetEnabled()) {
        memset(&m_Enabled,UnassignedByte(),sizeof(m_Enabled));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Enabled;
}

inline
bool CLoaderDescriptor_Base::IsSetPriority(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CLoaderDescriptor_Base::CanGetPriority(void) const
{
    return IsSetPriority();
}

inline
void CLoaderDescriptor_Base::ResetPriority(void)
{
    m_Priority = 0;
    m_set_State[0] &= ~0x300;
}

inline
CLoaderDescriptor_Base::TPriority CLoaderDescriptor_Base::GetPriority(void) const
{
    if (!CanGetPriority()) {
        ThrowUnassigned(4);
    }
    return m_Priority;
}

inline
void CLoaderDescriptor_Base::SetPriority(CLoaderDescriptor_Base::TPriority value)
{
    m_Priority = value;
    m_set_State[0] |= 0x300;
}

inline
CLoaderDescriptor_Base::TPriority& CLoaderDescriptor_Base::SetPriority(void)
{
#ifdef _DEBUG
    if (!IsSetPriority()) {
        memset(&m_Priority,UnassignedByte(),sizeof(m_Priority));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Priority;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GBPROJ_LOADERDESCRIPTOR_BASE_HPP
