/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Int_fuzz_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'general.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENERAL_INT_FUZZ_BASE_HPP
#define OBJECTS_GENERAL_INT_FUZZ_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
///**** Int-fuzz **********************************************
///*
///*   uncertainties in integer values
class NCBI_GENERAL_EXPORT CInt_fuzz_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CInt_fuzz_Base(void);
    // destructor
    virtual ~CInt_fuzz_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    /// max to min
    class NCBI_GENERAL_EXPORT C_Range : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Range(void);
        // destructor
        ~C_Range(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef TSeqPos TMax;
        typedef TSeqPos TMin;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_max,
            e_min
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef TSeqPos TMax
        ///  Check whether the Max data member has been assigned a value.
        bool IsSetMax(void) const;
        /// Check whether it is safe or not to call GetMax method.
        bool CanGetMax(void) const;
        void ResetMax(void);
        TMax GetMax(void) const;
        void SetMax(TMax value);
        TMax& SetMax(void);
    
        /// mandatory
        /// typedef TSeqPos TMin
        ///  Check whether the Min data member has been assigned a value.
        bool IsSetMin(void) const;
        /// Check whether it is safe or not to call GetMin method.
        bool CanGetMin(void) const;
        void ResetMin(void);
        TMin GetMin(void) const;
        void SetMin(TMin value);
        TMin& SetMin(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Range(const C_Range&);
        C_Range& operator=(const C_Range&);
    
        // data
        Uint4 m_set_State[1];
        TSeqPos m_Max;
        TSeqPos m_Min;
    };
    /// some limit value
    enum ELim {
        eLim_unk    =   0,  ///< unknown
        eLim_gt     =   1,  ///< greater than
        eLim_lt     =   2,  ///< less than
        eLim_tr     =   3,  ///< space to right of position
        eLim_tl     =   4,  ///< space to left of position
        eLim_circle =   5,  ///< artificial break at origin of circle
        eLim_other  = 255  ///< something else
    };
    
    /// Access to ELim's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ELim)(void);
    

    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_P_m,          ///< plus or minus fixed amount
        e_Range,
        e_Pct,          ///< % plus or minus (x10) 0-1000
        e_Lim,
        e_Alt           ///< set of alternatives for the integer
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 6 ///< == e_Alt+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef TSeqPos TP_m;
    typedef C_Range TRange;
    typedef int TPct;
    typedef ELim TLim;
    typedef list< TSeqPos > TAlt;

    // getters
    // setters

    // typedef TSeqPos TP_m
    bool IsP_m(void) const;
    TP_m GetP_m(void) const;
    TP_m& SetP_m(void);
    void SetP_m(TP_m value);

    // typedef C_Range TRange
    bool IsRange(void) const;
    const TRange& GetRange(void) const;
    TRange& SetRange(void);
    void SetRange(TRange& value);

    // typedef int TPct
    bool IsPct(void) const;
    TPct GetPct(void) const;
    TPct& SetPct(void);
    void SetPct(TPct value);

    // typedef ELim TLim
    bool IsLim(void) const;
    TLim GetLim(void) const;
    TLim& SetLim(void);
    void SetLim(TLim value);

    // typedef list< TSeqPos > TAlt
    bool IsAlt(void) const;
    const TAlt& GetAlt(void) const;
    TAlt& SetAlt(void);


private:
    // copy constructor and assignment operator
    CInt_fuzz_Base(const CInt_fuzz_Base& );
    CInt_fuzz_Base& operator=(const CInt_fuzz_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TP_m m_P_m;
        TPct m_Pct;
        TLim m_Lim;
        NCBI_NS_NCBI::CUnionBuffer<TAlt> m_Alt;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CInt_fuzz_Base::C_Range::IsSetMax(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CInt_fuzz_Base::C_Range::CanGetMax(void) const
{
    return IsSetMax();
}

inline
void CInt_fuzz_Base::C_Range::ResetMax(void)
{
    m_Max = 0;
    m_set_State[0] &= ~0x3;
}

inline
CInt_fuzz_Base::C_Range::TMax CInt_fuzz_Base::C_Range::GetMax(void) const
{
    if (!CanGetMax()) {
        ThrowUnassigned(0);
    }
    return m_Max;
}

inline
void CInt_fuzz_Base::C_Range::SetMax(CInt_fuzz_Base::C_Range::TMax value)
{
    m_Max = value;
    m_set_State[0] |= 0x3;
}

inline
CInt_fuzz_Base::C_Range::TMax& CInt_fuzz_Base::C_Range::SetMax(void)
{
#ifdef _DEBUG
    if (!IsSetMax()) {
        memset(&m_Max,UnassignedByte(),sizeof(m_Max));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Max;
}

inline
bool CInt_fuzz_Base::C_Range::IsSetMin(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CInt_fuzz_Base::C_Range::CanGetMin(void) const
{
    return IsSetMin();
}

inline
void CInt_fuzz_Base::C_Range::ResetMin(void)
{
    m_Min = 0;
    m_set_State[0] &= ~0xc;
}

inline
CInt_fuzz_Base::C_Range::TMin CInt_fuzz_Base::C_Range::GetMin(void) const
{
    if (!CanGetMin()) {
        ThrowUnassigned(1);
    }
    return m_Min;
}

inline
void CInt_fuzz_Base::C_Range::SetMin(CInt_fuzz_Base::C_Range::TMin value)
{
    m_Min = value;
    m_set_State[0] |= 0xc;
}

inline
CInt_fuzz_Base::C_Range::TMin& CInt_fuzz_Base::C_Range::SetMin(void)
{
#ifdef _DEBUG
    if (!IsSetMin()) {
        memset(&m_Min,UnassignedByte(),sizeof(m_Min));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Min;
}

inline
CInt_fuzz_Base::E_Choice CInt_fuzz_Base::Which(void) const
{
    return m_choice;
}

inline
void CInt_fuzz_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CInt_fuzz_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CInt_fuzz_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CInt_fuzz_Base::IsP_m(void) const
{
    return m_choice == e_P_m;
}

inline
CInt_fuzz_Base::TP_m CInt_fuzz_Base::GetP_m(void) const
{
    CheckSelected(e_P_m);
    return m_P_m;
}

inline
CInt_fuzz_Base::TP_m& CInt_fuzz_Base::SetP_m(void)
{
    Select(e_P_m, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_P_m;
}

inline
void CInt_fuzz_Base::SetP_m(CInt_fuzz_Base::TP_m value)
{
    Select(e_P_m, NCBI_NS_NCBI::eDoNotResetVariant);
    m_P_m = value;
}

inline
bool CInt_fuzz_Base::IsRange(void) const
{
    return m_choice == e_Range;
}

inline
bool CInt_fuzz_Base::IsPct(void) const
{
    return m_choice == e_Pct;
}

inline
CInt_fuzz_Base::TPct CInt_fuzz_Base::GetPct(void) const
{
    CheckSelected(e_Pct);
    return m_Pct;
}

inline
CInt_fuzz_Base::TPct& CInt_fuzz_Base::SetPct(void)
{
    Select(e_Pct, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Pct;
}

inline
void CInt_fuzz_Base::SetPct(CInt_fuzz_Base::TPct value)
{
    Select(e_Pct, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Pct = value;
}

inline
bool CInt_fuzz_Base::IsLim(void) const
{
    return m_choice == e_Lim;
}

inline
CInt_fuzz_Base::TLim CInt_fuzz_Base::GetLim(void) const
{
    CheckSelected(e_Lim);
    return m_Lim;
}

inline
CInt_fuzz_Base::TLim& CInt_fuzz_Base::SetLim(void)
{
    Select(e_Lim, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Lim;
}

inline
void CInt_fuzz_Base::SetLim(CInt_fuzz_Base::TLim value)
{
    Select(e_Lim, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Lim = value;
}

inline
bool CInt_fuzz_Base::IsAlt(void) const
{
    return m_choice == e_Alt;
}

inline
const CInt_fuzz_Base::TAlt& CInt_fuzz_Base::GetAlt(void) const
{
    CheckSelected(e_Alt);
    return *m_Alt;
}

inline
CInt_fuzz_Base::TAlt& CInt_fuzz_Base::SetAlt(void)
{
    Select(e_Alt, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Alt;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENERAL_INT_FUZZ_BASE_HPP
