/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GC_Genome_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'genome_collection.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENOMECOLL_GC_GENOME_BASE_HPP
#define OBJECTS_GENOMECOLL_GC_GENOME_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDbtag;
class CGC_GenomicPart;
class CGC_Project;
class CSeq_descr;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_GENOME_COLLECTION_EXPORT CGC_Genome_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGC_Genome_Base(void);
    // destructor
    virtual ~CGC_Genome_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< CRef< CDbtag > > TId;
    typedef list< CRef< CGC_Project > > TProjects;
    typedef CSeq_descr TDescr;
    typedef list< string > TChr_names;
    typedef list< CRef< CGC_GenomicPart > > TParts;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_projects,
        e_descr,
        e_chr_names,
        e_parts
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// Gencoll identifier for this genome
    /// mandatory
    /// typedef list< CRef< CDbtag > > TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    TId& SetId(void);

    /// project ID for this genome
    /// this is the ID for this asssembly and may reflect the submitter/source
    /// optional
    /// typedef list< CRef< CGC_Project > > TProjects
    ///  Check whether the Projects data member has been assigned a value.
    bool IsSetProjects(void) const;
    /// Check whether it is safe or not to call GetProjects method.
    bool CanGetProjects(void) const;
    void ResetProjects(void);
    const TProjects& GetProjects(void) const;
    TProjects& SetProjects(void);

    /// Various attributes assigned at this level:
    /// biosrc, comments, publications...
    /// optional
    /// typedef CSeq_descr TDescr
    ///  Check whether the Descr data member has been assigned a value.
    bool IsSetDescr(void) const;
    /// Check whether it is safe or not to call GetDescr method.
    bool CanGetDescr(void) const;
    void ResetDescr(void);
    const TDescr& GetDescr(void) const;
    void SetDescr(TDescr& value);
    TDescr& SetDescr(void);

    /// official list of chromosome names
    /// this should be the complete expected set of chromosomes
    /// regardless of whether they are represented in *any*
    /// genomic part
    /// optional
    /// typedef list< string > TChr_names
    ///  Check whether the Chr_names data member has been assigned a value.
    bool IsSetChr_names(void) const;
    /// Check whether it is safe or not to call GetChr_names method.
    bool CanGetChr_names(void) const;
    void ResetChr_names(void);
    const TChr_names& GetChr_names(void) const;
    TChr_names& SetChr_names(void);

    /// the bits that make up this genome
    /// this preserves the expected display order
    /// mandatory
    /// typedef list< CRef< CGC_GenomicPart > > TParts
    ///  Check whether the Parts data member has been assigned a value.
    bool IsSetParts(void) const;
    /// Check whether it is safe or not to call GetParts method.
    bool CanGetParts(void) const;
    void ResetParts(void);
    const TParts& GetParts(void) const;
    TParts& SetParts(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGC_Genome_Base(const CGC_Genome_Base&);
    CGC_Genome_Base& operator=(const CGC_Genome_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CDbtag > > m_Id;
    list< CRef< CGC_Project > > m_Projects;
    CRef< TDescr > m_Descr;
    list< string > m_Chr_names;
    list< CRef< CGC_GenomicPart > > m_Parts;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGC_Genome_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGC_Genome_Base::CanGetId(void) const
{
    return true;
}

inline
const CGC_Genome_Base::TId& CGC_Genome_Base::GetId(void) const
{
    return m_Id;
}

inline
CGC_Genome_Base::TId& CGC_Genome_Base::SetId(void)
{
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CGC_Genome_Base::IsSetProjects(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGC_Genome_Base::CanGetProjects(void) const
{
    return true;
}

inline
const CGC_Genome_Base::TProjects& CGC_Genome_Base::GetProjects(void) const
{
    return m_Projects;
}

inline
CGC_Genome_Base::TProjects& CGC_Genome_Base::SetProjects(void)
{
    m_set_State[0] |= 0x4;
    return m_Projects;
}

inline
bool CGC_Genome_Base::IsSetDescr(void) const
{
    return m_Descr.NotEmpty();
}

inline
bool CGC_Genome_Base::CanGetDescr(void) const
{
    return IsSetDescr();
}

inline
const CGC_Genome_Base::TDescr& CGC_Genome_Base::GetDescr(void) const
{
    if (!CanGetDescr()) {
        ThrowUnassigned(2);
    }
    return (*m_Descr);
}

inline
bool CGC_Genome_Base::IsSetChr_names(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CGC_Genome_Base::CanGetChr_names(void) const
{
    return true;
}

inline
const CGC_Genome_Base::TChr_names& CGC_Genome_Base::GetChr_names(void) const
{
    return m_Chr_names;
}

inline
CGC_Genome_Base::TChr_names& CGC_Genome_Base::SetChr_names(void)
{
    m_set_State[0] |= 0x40;
    return m_Chr_names;
}

inline
bool CGC_Genome_Base::IsSetParts(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CGC_Genome_Base::CanGetParts(void) const
{
    return true;
}

inline
const CGC_Genome_Base::TParts& CGC_Genome_Base::GetParts(void) const
{
    return m_Parts;
}

inline
CGC_Genome_Base::TParts& CGC_Genome_Base::SetParts(void)
{
    m_set_State[0] |= 0x100;
    return m_Parts;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENOMECOLL_GC_GENOME_BASE_HPP
