/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GC_Project_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'genome_collection.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENOMECOLL_GC_PROJECT_BASE_HPP
#define OBJECTS_GENOMECOLL_GC_PROJECT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_GENOME_COLLECTION_EXPORT CGC_Project_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGC_Project_Base(void);
    // destructor
    virtual ~CGC_Project_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TProject_role;
    typedef int TProject_id;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_project_role,
        e_project_id
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// Genbank / Refseq
    /// mandatory
    /// typedef string TProject_role
    ///  Check whether the Project_role data member has been assigned a value.
    bool IsSetProject_role(void) const;
    /// Check whether it is safe or not to call GetProject_role method.
    bool CanGetProject_role(void) const;
    void ResetProject_role(void);
    const TProject_role& GetProject_role(void) const;
    void SetProject_role(const TProject_role& value);
    void SetProject_role(TProject_role&& value);
    TProject_role& SetProject_role(void);

    /// mandatory
    /// typedef int TProject_id
    ///  Check whether the Project_id data member has been assigned a value.
    bool IsSetProject_id(void) const;
    /// Check whether it is safe or not to call GetProject_id method.
    bool CanGetProject_id(void) const;
    void ResetProject_id(void);
    TProject_id GetProject_id(void) const;
    void SetProject_id(TProject_id value);
    TProject_id& SetProject_id(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGC_Project_Base(const CGC_Project_Base&);
    CGC_Project_Base& operator=(const CGC_Project_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Project_role;
    int m_Project_id;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGC_Project_Base::IsSetProject_role(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGC_Project_Base::CanGetProject_role(void) const
{
    return IsSetProject_role();
}

inline
const CGC_Project_Base::TProject_role& CGC_Project_Base::GetProject_role(void) const
{
    if (!CanGetProject_role()) {
        ThrowUnassigned(0);
    }
    return m_Project_role;
}

inline
void CGC_Project_Base::SetProject_role(const CGC_Project_Base::TProject_role& value)
{
    m_Project_role = value;
    m_set_State[0] |= 0x3;
}

inline
void CGC_Project_Base::SetProject_role(CGC_Project_Base::TProject_role&& value)
{
    m_Project_role = std::forward<CGC_Project_Base::TProject_role>(value);
    m_set_State[0] |= 0x3;
}

inline
CGC_Project_Base::TProject_role& CGC_Project_Base::SetProject_role(void)
{
#ifdef _DEBUG
    if (!IsSetProject_role()) {
        m_Project_role = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Project_role;
}

inline
bool CGC_Project_Base::IsSetProject_id(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGC_Project_Base::CanGetProject_id(void) const
{
    return IsSetProject_id();
}

inline
void CGC_Project_Base::ResetProject_id(void)
{
    m_Project_id = 0;
    m_set_State[0] &= ~0xc;
}

inline
CGC_Project_Base::TProject_id CGC_Project_Base::GetProject_id(void) const
{
    if (!CanGetProject_id()) {
        ThrowUnassigned(1);
    }
    return m_Project_id;
}

inline
void CGC_Project_Base::SetProject_id(CGC_Project_Base::TProject_id value)
{
    m_Project_id = value;
    m_set_State[0] |= 0xc;
}

inline
CGC_Project_Base::TProject_id& CGC_Project_Base::SetProject_id(void)
{
#ifdef _DEBUG
    if (!IsSetProject_id()) {
        memset(&m_Project_id,UnassignedByte(),sizeof(m_Project_id));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Project_id;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENOMECOLL_GC_PROJECT_BASE_HPP
