/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GC_Query_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'genome_collection.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENOMECOLL_GC_QUERY_BASE_HPP
#define OBJECTS_GENOMECOLL_GC_QUERY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
///
/// A GC-Assemblies is a mere set of assemblies.
/// used for returning list of assemblies from a search
///
class NCBI_GENOME_COLLECTION_EXPORT CGC_Query_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGC_Query_Base(void);
    // destructor
    virtual ~CGC_Query_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TParam;
    typedef string TValue;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_param,
        e_value
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TParam
    ///  Check whether the Param data member has been assigned a value.
    bool IsSetParam(void) const;
    /// Check whether it is safe or not to call GetParam method.
    bool CanGetParam(void) const;
    void ResetParam(void);
    const TParam& GetParam(void) const;
    void SetParam(const TParam& value);
    void SetParam(TParam&& value);
    TParam& SetParam(void);

    /// mandatory
    /// typedef string TValue
    ///  Check whether the Value data member has been assigned a value.
    bool IsSetValue(void) const;
    /// Check whether it is safe or not to call GetValue method.
    bool CanGetValue(void) const;
    void ResetValue(void);
    const TValue& GetValue(void) const;
    void SetValue(const TValue& value);
    void SetValue(TValue&& value);
    TValue& SetValue(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGC_Query_Base(const CGC_Query_Base&);
    CGC_Query_Base& operator=(const CGC_Query_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Param;
    string m_Value;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGC_Query_Base::IsSetParam(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGC_Query_Base::CanGetParam(void) const
{
    return IsSetParam();
}

inline
const CGC_Query_Base::TParam& CGC_Query_Base::GetParam(void) const
{
    if (!CanGetParam()) {
        ThrowUnassigned(0);
    }
    return m_Param;
}

inline
void CGC_Query_Base::SetParam(const CGC_Query_Base::TParam& value)
{
    m_Param = value;
    m_set_State[0] |= 0x3;
}

inline
void CGC_Query_Base::SetParam(CGC_Query_Base::TParam&& value)
{
    m_Param = std::forward<CGC_Query_Base::TParam>(value);
    m_set_State[0] |= 0x3;
}

inline
CGC_Query_Base::TParam& CGC_Query_Base::SetParam(void)
{
#ifdef _DEBUG
    if (!IsSetParam()) {
        m_Param = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Param;
}

inline
bool CGC_Query_Base::IsSetValue(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGC_Query_Base::CanGetValue(void) const
{
    return IsSetValue();
}

inline
const CGC_Query_Base::TValue& CGC_Query_Base::GetValue(void) const
{
    if (!CanGetValue()) {
        ThrowUnassigned(1);
    }
    return m_Value;
}

inline
void CGC_Query_Base::SetValue(const CGC_Query_Base::TValue& value)
{
    m_Value = value;
    m_set_State[0] |= 0xc;
}

inline
void CGC_Query_Base::SetValue(CGC_Query_Base::TValue&& value)
{
    m_Value = std::forward<CGC_Query_Base::TValue>(value);
    m_set_State[0] |= 0xc;
}

inline
CGC_Query_Base::TValue& CGC_Query_Base::SetValue(void)
{
#ifdef _DEBUG
    if (!IsSetValue()) {
        m_Value = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Value;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENOMECOLL_GC_QUERY_BASE_HPP
