/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file HG_Domain_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'homologene.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_HOMOLOGENE_HG_DOMAIN_BASE_HPP
#define OBJECTS_HOMOLOGENE_HG_DOMAIN_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CHG_Domain_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CHG_Domain_Base(void);
    // destructor
    virtual ~CHG_Domain_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TBegin;
    typedef int TEnd;
    typedef int TPssm_id;
    typedef string TCdd_id;
    typedef string TCdd_name;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_begin,
        e_end,
        e_pssm_id,
        e_cdd_id,
        e_cdd_name
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TBegin
    ///  Check whether the Begin data member has been assigned a value.
    bool IsSetBegin(void) const;
    /// Check whether it is safe or not to call GetBegin method.
    bool CanGetBegin(void) const;
    void ResetBegin(void);
    TBegin GetBegin(void) const;
    void SetBegin(TBegin value);
    TBegin& SetBegin(void);

    /// mandatory
    /// typedef int TEnd
    ///  Check whether the End data member has been assigned a value.
    bool IsSetEnd(void) const;
    /// Check whether it is safe or not to call GetEnd method.
    bool CanGetEnd(void) const;
    void ResetEnd(void);
    TEnd GetEnd(void) const;
    void SetEnd(TEnd value);
    TEnd& SetEnd(void);

    /// entrez uid
    /// optional
    /// typedef int TPssm_id
    ///  Check whether the Pssm_id data member has been assigned a value.
    bool IsSetPssm_id(void) const;
    /// Check whether it is safe or not to call GetPssm_id method.
    bool CanGetPssm_id(void) const;
    void ResetPssm_id(void);
    TPssm_id GetPssm_id(void) const;
    void SetPssm_id(TPssm_id value);
    TPssm_id& SetPssm_id(void);

    /// optional
    /// typedef string TCdd_id
    ///  Check whether the Cdd_id data member has been assigned a value.
    bool IsSetCdd_id(void) const;
    /// Check whether it is safe or not to call GetCdd_id method.
    bool CanGetCdd_id(void) const;
    void ResetCdd_id(void);
    const TCdd_id& GetCdd_id(void) const;
    void SetCdd_id(const TCdd_id& value);
    void SetCdd_id(TCdd_id&& value);
    TCdd_id& SetCdd_id(void);

    /// optional
    /// typedef string TCdd_name
    ///  Check whether the Cdd_name data member has been assigned a value.
    bool IsSetCdd_name(void) const;
    /// Check whether it is safe or not to call GetCdd_name method.
    bool CanGetCdd_name(void) const;
    void ResetCdd_name(void);
    const TCdd_name& GetCdd_name(void) const;
    void SetCdd_name(const TCdd_name& value);
    void SetCdd_name(TCdd_name&& value);
    TCdd_name& SetCdd_name(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CHG_Domain_Base(const CHG_Domain_Base&);
    CHG_Domain_Base& operator=(const CHG_Domain_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Begin;
    int m_End;
    int m_Pssm_id;
    string m_Cdd_id;
    string m_Cdd_name;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CHG_Domain_Base::IsSetBegin(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CHG_Domain_Base::CanGetBegin(void) const
{
    return IsSetBegin();
}

inline
void CHG_Domain_Base::ResetBegin(void)
{
    m_Begin = 0;
    m_set_State[0] &= ~0x3;
}

inline
CHG_Domain_Base::TBegin CHG_Domain_Base::GetBegin(void) const
{
    if (!CanGetBegin()) {
        ThrowUnassigned(0);
    }
    return m_Begin;
}

inline
void CHG_Domain_Base::SetBegin(CHG_Domain_Base::TBegin value)
{
    m_Begin = value;
    m_set_State[0] |= 0x3;
}

inline
CHG_Domain_Base::TBegin& CHG_Domain_Base::SetBegin(void)
{
#ifdef _DEBUG
    if (!IsSetBegin()) {
        memset(&m_Begin,UnassignedByte(),sizeof(m_Begin));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Begin;
}

inline
bool CHG_Domain_Base::IsSetEnd(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CHG_Domain_Base::CanGetEnd(void) const
{
    return IsSetEnd();
}

inline
void CHG_Domain_Base::ResetEnd(void)
{
    m_End = 0;
    m_set_State[0] &= ~0xc;
}

inline
CHG_Domain_Base::TEnd CHG_Domain_Base::GetEnd(void) const
{
    if (!CanGetEnd()) {
        ThrowUnassigned(1);
    }
    return m_End;
}

inline
void CHG_Domain_Base::SetEnd(CHG_Domain_Base::TEnd value)
{
    m_End = value;
    m_set_State[0] |= 0xc;
}

inline
CHG_Domain_Base::TEnd& CHG_Domain_Base::SetEnd(void)
{
#ifdef _DEBUG
    if (!IsSetEnd()) {
        memset(&m_End,UnassignedByte(),sizeof(m_End));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_End;
}

inline
bool CHG_Domain_Base::IsSetPssm_id(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CHG_Domain_Base::CanGetPssm_id(void) const
{
    return IsSetPssm_id();
}

inline
void CHG_Domain_Base::ResetPssm_id(void)
{
    m_Pssm_id = 0;
    m_set_State[0] &= ~0x30;
}

inline
CHG_Domain_Base::TPssm_id CHG_Domain_Base::GetPssm_id(void) const
{
    if (!CanGetPssm_id()) {
        ThrowUnassigned(2);
    }
    return m_Pssm_id;
}

inline
void CHG_Domain_Base::SetPssm_id(CHG_Domain_Base::TPssm_id value)
{
    m_Pssm_id = value;
    m_set_State[0] |= 0x30;
}

inline
CHG_Domain_Base::TPssm_id& CHG_Domain_Base::SetPssm_id(void)
{
#ifdef _DEBUG
    if (!IsSetPssm_id()) {
        memset(&m_Pssm_id,UnassignedByte(),sizeof(m_Pssm_id));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Pssm_id;
}

inline
bool CHG_Domain_Base::IsSetCdd_id(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CHG_Domain_Base::CanGetCdd_id(void) const
{
    return IsSetCdd_id();
}

inline
const CHG_Domain_Base::TCdd_id& CHG_Domain_Base::GetCdd_id(void) const
{
    if (!CanGetCdd_id()) {
        ThrowUnassigned(3);
    }
    return m_Cdd_id;
}

inline
void CHG_Domain_Base::SetCdd_id(const CHG_Domain_Base::TCdd_id& value)
{
    m_Cdd_id = value;
    m_set_State[0] |= 0xc0;
}

inline
void CHG_Domain_Base::SetCdd_id(CHG_Domain_Base::TCdd_id&& value)
{
    m_Cdd_id = std::forward<CHG_Domain_Base::TCdd_id>(value);
    m_set_State[0] |= 0xc0;
}

inline
CHG_Domain_Base::TCdd_id& CHG_Domain_Base::SetCdd_id(void)
{
#ifdef _DEBUG
    if (!IsSetCdd_id()) {
        m_Cdd_id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Cdd_id;
}

inline
bool CHG_Domain_Base::IsSetCdd_name(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CHG_Domain_Base::CanGetCdd_name(void) const
{
    return IsSetCdd_name();
}

inline
const CHG_Domain_Base::TCdd_name& CHG_Domain_Base::GetCdd_name(void) const
{
    if (!CanGetCdd_name()) {
        ThrowUnassigned(4);
    }
    return m_Cdd_name;
}

inline
void CHG_Domain_Base::SetCdd_name(const CHG_Domain_Base::TCdd_name& value)
{
    m_Cdd_name = value;
    m_set_State[0] |= 0x300;
}

inline
void CHG_Domain_Base::SetCdd_name(CHG_Domain_Base::TCdd_name&& value)
{
    m_Cdd_name = std::forward<CHG_Domain_Base::TCdd_name>(value);
    m_set_State[0] |= 0x300;
}

inline
CHG_Domain_Base::TCdd_name& CHG_Domain_Base::SetCdd_name(void)
{
#ifdef _DEBUG
    if (!IsSetCdd_name()) {
        m_Cdd_name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Cdd_name;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_HOMOLOGENE_HG_DOMAIN_BASE_HPP
