/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file HG_Node_id_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'homologene.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_HOMOLOGENE_HG_NODE_ID_BASE_HPP
#define OBJECTS_HOMOLOGENE_HG_NODE_ID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CHG_Node_id_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CHG_Node_id_Base(void);
    // destructor
    virtual ~CHG_Node_id_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EId_type {
        eId_type_none   = 0,
        eId_type_geneid = 1,
        eId_type_hid    = 2
    };
    
    /// Access to EId_type's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EId_type)(void);
    
    // types
    typedef int TId;
    typedef EId_type TId_type;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_id_type
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef int TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    TId GetId(void) const;
    void SetId(TId value);
    TId& SetId(void);

    /// mandatory
    /// typedef EId_type TId_type
    ///  Check whether the Id_type data member has been assigned a value.
    bool IsSetId_type(void) const;
    /// Check whether it is safe or not to call GetId_type method.
    bool CanGetId_type(void) const;
    void ResetId_type(void);
    TId_type GetId_type(void) const;
    void SetId_type(TId_type value);
    TId_type& SetId_type(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CHG_Node_id_Base(const CHG_Node_id_Base&);
    CHG_Node_id_Base& operator=(const CHG_Node_id_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Id;
    EId_type m_Id_type;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CHG_Node_id_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CHG_Node_id_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
void CHG_Node_id_Base::ResetId(void)
{
    m_Id = 0;
    m_set_State[0] &= ~0x3;
}

inline
CHG_Node_id_Base::TId CHG_Node_id_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CHG_Node_id_Base::SetId(CHG_Node_id_Base::TId value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
CHG_Node_id_Base::TId& CHG_Node_id_Base::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        memset(&m_Id,UnassignedByte(),sizeof(m_Id));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CHG_Node_id_Base::IsSetId_type(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CHG_Node_id_Base::CanGetId_type(void) const
{
    return IsSetId_type();
}

inline
void CHG_Node_id_Base::ResetId_type(void)
{
    m_Id_type = (EId_type)(0);
    m_set_State[0] &= ~0xc;
}

inline
CHG_Node_id_Base::TId_type CHG_Node_id_Base::GetId_type(void) const
{
    if (!CanGetId_type()) {
        ThrowUnassigned(1);
    }
    return m_Id_type;
}

inline
void CHG_Node_id_Base::SetId_type(CHG_Node_id_Base::TId_type value)
{
    m_Id_type = value;
    m_set_State[0] |= 0xc;
}

inline
CHG_Node_id_Base::TId_type& CHG_Node_id_Base::SetId_type(void)
{
#ifdef _DEBUG
    if (!IsSetId_type()) {
        memset(&m_Id_type,UnassignedByte(),sizeof(m_Id_type));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Id_type;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_HOMOLOGENE_HG_NODE_ID_BASE_HPP
