/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file HG_Stats_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'homologene.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_HOMOLOGENE_HG_STATS_BASE_HPP
#define OBJECTS_HOMOLOGENE_HG_STATS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CHG_Stats_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CHG_Stats_Base(void);
    // destructor
    virtual ~CHG_Stats_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TGi1;
    typedef int TGi2;
    typedef double TNuc_change;
    typedef double TNuc_change_jc;
    typedef double TProt_change;
    typedef double TKa;
    typedef double TKs;
    typedef double TKnr;
    typedef double TKnc;
    typedef bool TRecip_best;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_gi1,
        e_gi2,
        e_nuc_change,
        e_nuc_change_jc,
        e_prot_change,
        e_ka,
        e_ks,
        e_knr,
        e_knc,
        e_recip_best
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 11> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TGi1
    ///  Check whether the Gi1 data member has been assigned a value.
    bool IsSetGi1(void) const;
    /// Check whether it is safe or not to call GetGi1 method.
    bool CanGetGi1(void) const;
    void ResetGi1(void);
    TGi1 GetGi1(void) const;
    void SetGi1(TGi1 value);
    TGi1& SetGi1(void);

    /// mandatory
    /// typedef int TGi2
    ///  Check whether the Gi2 data member has been assigned a value.
    bool IsSetGi2(void) const;
    /// Check whether it is safe or not to call GetGi2 method.
    bool CanGetGi2(void) const;
    void ResetGi2(void);
    TGi2 GetGi2(void) const;
    void SetGi2(TGi2 value);
    TGi2& SetGi2(void);

    /// mandatory
    /// typedef double TNuc_change
    ///  Check whether the Nuc_change data member has been assigned a value.
    bool IsSetNuc_change(void) const;
    /// Check whether it is safe or not to call GetNuc_change method.
    bool CanGetNuc_change(void) const;
    void ResetNuc_change(void);
    TNuc_change GetNuc_change(void) const;
    void SetNuc_change(TNuc_change value);
    TNuc_change& SetNuc_change(void);

    /// mandatory
    /// typedef double TNuc_change_jc
    ///  Check whether the Nuc_change_jc data member has been assigned a value.
    bool IsSetNuc_change_jc(void) const;
    /// Check whether it is safe or not to call GetNuc_change_jc method.
    bool CanGetNuc_change_jc(void) const;
    void ResetNuc_change_jc(void);
    TNuc_change_jc GetNuc_change_jc(void) const;
    void SetNuc_change_jc(TNuc_change_jc value);
    TNuc_change_jc& SetNuc_change_jc(void);

    /// mandatory
    /// typedef double TProt_change
    ///  Check whether the Prot_change data member has been assigned a value.
    bool IsSetProt_change(void) const;
    /// Check whether it is safe or not to call GetProt_change method.
    bool CanGetProt_change(void) const;
    void ResetProt_change(void);
    TProt_change GetProt_change(void) const;
    void SetProt_change(TProt_change value);
    TProt_change& SetProt_change(void);

    /// mandatory
    /// typedef double TKa
    ///  Check whether the Ka data member has been assigned a value.
    bool IsSetKa(void) const;
    /// Check whether it is safe or not to call GetKa method.
    bool CanGetKa(void) const;
    void ResetKa(void);
    TKa GetKa(void) const;
    void SetKa(TKa value);
    TKa& SetKa(void);

    /// mandatory
    /// typedef double TKs
    ///  Check whether the Ks data member has been assigned a value.
    bool IsSetKs(void) const;
    /// Check whether it is safe or not to call GetKs method.
    bool CanGetKs(void) const;
    void ResetKs(void);
    TKs GetKs(void) const;
    void SetKs(TKs value);
    TKs& SetKs(void);

    /// mandatory
    /// typedef double TKnr
    ///  Check whether the Knr data member has been assigned a value.
    bool IsSetKnr(void) const;
    /// Check whether it is safe or not to call GetKnr method.
    bool CanGetKnr(void) const;
    void ResetKnr(void);
    TKnr GetKnr(void) const;
    void SetKnr(TKnr value);
    TKnr& SetKnr(void);

    /// mandatory
    /// typedef double TKnc
    ///  Check whether the Knc data member has been assigned a value.
    bool IsSetKnc(void) const;
    /// Check whether it is safe or not to call GetKnc method.
    bool CanGetKnc(void) const;
    void ResetKnc(void);
    TKnc GetKnc(void) const;
    void SetKnc(TKnc value);
    TKnc& SetKnc(void);

    /// optional
    /// typedef bool TRecip_best
    ///  Check whether the Recip_best data member has been assigned a value.
    bool IsSetRecip_best(void) const;
    /// Check whether it is safe or not to call GetRecip_best method.
    bool CanGetRecip_best(void) const;
    void ResetRecip_best(void);
    TRecip_best GetRecip_best(void) const;
    void SetRecip_best(TRecip_best value);
    TRecip_best& SetRecip_best(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CHG_Stats_Base(const CHG_Stats_Base&);
    CHG_Stats_Base& operator=(const CHG_Stats_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Gi1;
    int m_Gi2;
    double m_Nuc_change;
    double m_Nuc_change_jc;
    double m_Prot_change;
    double m_Ka;
    double m_Ks;
    double m_Knr;
    double m_Knc;
    bool m_Recip_best;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CHG_Stats_Base::IsSetGi1(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CHG_Stats_Base::CanGetGi1(void) const
{
    return IsSetGi1();
}

inline
void CHG_Stats_Base::ResetGi1(void)
{
    m_Gi1 = 0;
    m_set_State[0] &= ~0x3;
}

inline
CHG_Stats_Base::TGi1 CHG_Stats_Base::GetGi1(void) const
{
    if (!CanGetGi1()) {
        ThrowUnassigned(0);
    }
    return m_Gi1;
}

inline
void CHG_Stats_Base::SetGi1(CHG_Stats_Base::TGi1 value)
{
    m_Gi1 = value;
    m_set_State[0] |= 0x3;
}

inline
CHG_Stats_Base::TGi1& CHG_Stats_Base::SetGi1(void)
{
#ifdef _DEBUG
    if (!IsSetGi1()) {
        memset(&m_Gi1,UnassignedByte(),sizeof(m_Gi1));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Gi1;
}

inline
bool CHG_Stats_Base::IsSetGi2(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CHG_Stats_Base::CanGetGi2(void) const
{
    return IsSetGi2();
}

inline
void CHG_Stats_Base::ResetGi2(void)
{
    m_Gi2 = 0;
    m_set_State[0] &= ~0xc;
}

inline
CHG_Stats_Base::TGi2 CHG_Stats_Base::GetGi2(void) const
{
    if (!CanGetGi2()) {
        ThrowUnassigned(1);
    }
    return m_Gi2;
}

inline
void CHG_Stats_Base::SetGi2(CHG_Stats_Base::TGi2 value)
{
    m_Gi2 = value;
    m_set_State[0] |= 0xc;
}

inline
CHG_Stats_Base::TGi2& CHG_Stats_Base::SetGi2(void)
{
#ifdef _DEBUG
    if (!IsSetGi2()) {
        memset(&m_Gi2,UnassignedByte(),sizeof(m_Gi2));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Gi2;
}

inline
bool CHG_Stats_Base::IsSetNuc_change(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CHG_Stats_Base::CanGetNuc_change(void) const
{
    return IsSetNuc_change();
}

inline
void CHG_Stats_Base::ResetNuc_change(void)
{
    m_Nuc_change = 0;
    m_set_State[0] &= ~0x30;
}

inline
CHG_Stats_Base::TNuc_change CHG_Stats_Base::GetNuc_change(void) const
{
    if (!CanGetNuc_change()) {
        ThrowUnassigned(2);
    }
    return m_Nuc_change;
}

inline
void CHG_Stats_Base::SetNuc_change(CHG_Stats_Base::TNuc_change value)
{
    m_Nuc_change = value;
    m_set_State[0] |= 0x30;
}

inline
CHG_Stats_Base::TNuc_change& CHG_Stats_Base::SetNuc_change(void)
{
#ifdef _DEBUG
    if (!IsSetNuc_change()) {
        memset(&m_Nuc_change,UnassignedByte(),sizeof(m_Nuc_change));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Nuc_change;
}

inline
bool CHG_Stats_Base::IsSetNuc_change_jc(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CHG_Stats_Base::CanGetNuc_change_jc(void) const
{
    return IsSetNuc_change_jc();
}

inline
void CHG_Stats_Base::ResetNuc_change_jc(void)
{
    m_Nuc_change_jc = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CHG_Stats_Base::TNuc_change_jc CHG_Stats_Base::GetNuc_change_jc(void) const
{
    if (!CanGetNuc_change_jc()) {
        ThrowUnassigned(3);
    }
    return m_Nuc_change_jc;
}

inline
void CHG_Stats_Base::SetNuc_change_jc(CHG_Stats_Base::TNuc_change_jc value)
{
    m_Nuc_change_jc = value;
    m_set_State[0] |= 0xc0;
}

inline
CHG_Stats_Base::TNuc_change_jc& CHG_Stats_Base::SetNuc_change_jc(void)
{
#ifdef _DEBUG
    if (!IsSetNuc_change_jc()) {
        memset(&m_Nuc_change_jc,UnassignedByte(),sizeof(m_Nuc_change_jc));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Nuc_change_jc;
}

inline
bool CHG_Stats_Base::IsSetProt_change(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CHG_Stats_Base::CanGetProt_change(void) const
{
    return IsSetProt_change();
}

inline
void CHG_Stats_Base::ResetProt_change(void)
{
    m_Prot_change = 0;
    m_set_State[0] &= ~0x300;
}

inline
CHG_Stats_Base::TProt_change CHG_Stats_Base::GetProt_change(void) const
{
    if (!CanGetProt_change()) {
        ThrowUnassigned(4);
    }
    return m_Prot_change;
}

inline
void CHG_Stats_Base::SetProt_change(CHG_Stats_Base::TProt_change value)
{
    m_Prot_change = value;
    m_set_State[0] |= 0x300;
}

inline
CHG_Stats_Base::TProt_change& CHG_Stats_Base::SetProt_change(void)
{
#ifdef _DEBUG
    if (!IsSetProt_change()) {
        memset(&m_Prot_change,UnassignedByte(),sizeof(m_Prot_change));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Prot_change;
}

inline
bool CHG_Stats_Base::IsSetKa(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CHG_Stats_Base::CanGetKa(void) const
{
    return IsSetKa();
}

inline
void CHG_Stats_Base::ResetKa(void)
{
    m_Ka = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CHG_Stats_Base::TKa CHG_Stats_Base::GetKa(void) const
{
    if (!CanGetKa()) {
        ThrowUnassigned(5);
    }
    return m_Ka;
}

inline
void CHG_Stats_Base::SetKa(CHG_Stats_Base::TKa value)
{
    m_Ka = value;
    m_set_State[0] |= 0xc00;
}

inline
CHG_Stats_Base::TKa& CHG_Stats_Base::SetKa(void)
{
#ifdef _DEBUG
    if (!IsSetKa()) {
        memset(&m_Ka,UnassignedByte(),sizeof(m_Ka));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Ka;
}

inline
bool CHG_Stats_Base::IsSetKs(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CHG_Stats_Base::CanGetKs(void) const
{
    return IsSetKs();
}

inline
void CHG_Stats_Base::ResetKs(void)
{
    m_Ks = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CHG_Stats_Base::TKs CHG_Stats_Base::GetKs(void) const
{
    if (!CanGetKs()) {
        ThrowUnassigned(6);
    }
    return m_Ks;
}

inline
void CHG_Stats_Base::SetKs(CHG_Stats_Base::TKs value)
{
    m_Ks = value;
    m_set_State[0] |= 0x3000;
}

inline
CHG_Stats_Base::TKs& CHG_Stats_Base::SetKs(void)
{
#ifdef _DEBUG
    if (!IsSetKs()) {
        memset(&m_Ks,UnassignedByte(),sizeof(m_Ks));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Ks;
}

inline
bool CHG_Stats_Base::IsSetKnr(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CHG_Stats_Base::CanGetKnr(void) const
{
    return IsSetKnr();
}

inline
void CHG_Stats_Base::ResetKnr(void)
{
    m_Knr = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CHG_Stats_Base::TKnr CHG_Stats_Base::GetKnr(void) const
{
    if (!CanGetKnr()) {
        ThrowUnassigned(7);
    }
    return m_Knr;
}

inline
void CHG_Stats_Base::SetKnr(CHG_Stats_Base::TKnr value)
{
    m_Knr = value;
    m_set_State[0] |= 0xc000;
}

inline
CHG_Stats_Base::TKnr& CHG_Stats_Base::SetKnr(void)
{
#ifdef _DEBUG
    if (!IsSetKnr()) {
        memset(&m_Knr,UnassignedByte(),sizeof(m_Knr));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Knr;
}

inline
bool CHG_Stats_Base::IsSetKnc(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CHG_Stats_Base::CanGetKnc(void) const
{
    return IsSetKnc();
}

inline
void CHG_Stats_Base::ResetKnc(void)
{
    m_Knc = 0;
    m_set_State[0] &= ~0x30000;
}

inline
CHG_Stats_Base::TKnc CHG_Stats_Base::GetKnc(void) const
{
    if (!CanGetKnc()) {
        ThrowUnassigned(8);
    }
    return m_Knc;
}

inline
void CHG_Stats_Base::SetKnc(CHG_Stats_Base::TKnc value)
{
    m_Knc = value;
    m_set_State[0] |= 0x30000;
}

inline
CHG_Stats_Base::TKnc& CHG_Stats_Base::SetKnc(void)
{
#ifdef _DEBUG
    if (!IsSetKnc()) {
        memset(&m_Knc,UnassignedByte(),sizeof(m_Knc));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Knc;
}

inline
bool CHG_Stats_Base::IsSetRecip_best(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CHG_Stats_Base::CanGetRecip_best(void) const
{
    return IsSetRecip_best();
}

inline
void CHG_Stats_Base::ResetRecip_best(void)
{
    m_Recip_best = 0;
    m_set_State[0] &= ~0xc0000;
}

inline
CHG_Stats_Base::TRecip_best CHG_Stats_Base::GetRecip_best(void) const
{
    if (!CanGetRecip_best()) {
        ThrowUnassigned(9);
    }
    return m_Recip_best;
}

inline
void CHG_Stats_Base::SetRecip_best(CHG_Stats_Base::TRecip_best value)
{
    m_Recip_best = value;
    m_set_State[0] |= 0xc0000;
}

inline
CHG_Stats_Base::TRecip_best& CHG_Stats_Base::SetRecip_best(void)
{
#ifdef _DEBUG
    if (!IsSetRecip_best()) {
        memset(&m_Recip_best,UnassignedByte(),sizeof(m_Recip_best));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Recip_best;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_HOMOLOGENE_HG_STATS_BASE_HPP
