/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID1server_request_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'id1.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ID1_ID1SERVER_REQUEST_BASE_HPP
#define OBJECTS_ID1_ID1SERVER_REQUEST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CID1server_maxcomplex;
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///**********************************
/// requests
///
class NCBI_ID1_EXPORT CID1server_request_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID1server_request_Base(void);
    // destructor
    virtual ~CID1server_request_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,      ///< No variant selected
        e_Init,             ///< DlInit
        e_Getgi,            ///< get a gi given a Seq-id
        e_Getsefromgi,      ///< given a gi, get the Seq-entry
        e_Fini,             ///< DlFini
        e_Getseqidsfromgi,  ///<get all Seq-ids of given gi
        e_Getgihist,        ///<get an historical list of gis 
        e_Getgirev,         ///<get a revision history of gi
        e_Getgistate,       ///<get a state of gi
        e_Getsewithinfo,
        e_Getblobinfo
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 11 ///< == e_Getblobinfo+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CSeq_id TGetgi;
    typedef CID1server_maxcomplex TGetsefromgi;
    typedef NCBI_NS_NCBI::TGi TGetseqidsfromgi;
    typedef NCBI_NS_NCBI::TGi TGetgihist;
    typedef NCBI_NS_NCBI::TGi TGetgirev;
    typedef NCBI_NS_NCBI::TGi TGetgistate;
    typedef CID1server_maxcomplex TGetsewithinfo;
    typedef CID1server_maxcomplex TGetblobinfo;

    // getters
    // setters


    bool IsInit(void) const;
    void SetInit(void);

    // typedef CSeq_id TGetgi
    bool IsGetgi(void) const;
    const TGetgi& GetGetgi(void) const;
    TGetgi& SetGetgi(void);
    void SetGetgi(TGetgi& value);

    // typedef CID1server_maxcomplex TGetsefromgi
    bool IsGetsefromgi(void) const;
    const TGetsefromgi& GetGetsefromgi(void) const;
    TGetsefromgi& SetGetsefromgi(void);
    void SetGetsefromgi(TGetsefromgi& value);


    bool IsFini(void) const;
    void SetFini(void);

    // typedef NCBI_NS_NCBI::TGi TGetseqidsfromgi
    bool IsGetseqidsfromgi(void) const;
    TGetseqidsfromgi GetGetseqidsfromgi(void) const;
    TGetseqidsfromgi& SetGetseqidsfromgi(void);
    void SetGetseqidsfromgi(TGetseqidsfromgi value);

    // typedef NCBI_NS_NCBI::TGi TGetgihist
    bool IsGetgihist(void) const;
    TGetgihist GetGetgihist(void) const;
    TGetgihist& SetGetgihist(void);
    void SetGetgihist(TGetgihist value);

    // typedef NCBI_NS_NCBI::TGi TGetgirev
    bool IsGetgirev(void) const;
    TGetgirev GetGetgirev(void) const;
    TGetgirev& SetGetgirev(void);
    void SetGetgirev(TGetgirev value);

    // typedef NCBI_NS_NCBI::TGi TGetgistate
    bool IsGetgistate(void) const;
    TGetgistate GetGetgistate(void) const;
    TGetgistate& SetGetgistate(void);
    void SetGetgistate(TGetgistate value);

    // typedef CID1server_maxcomplex TGetsewithinfo
    bool IsGetsewithinfo(void) const;
    const TGetsewithinfo& GetGetsewithinfo(void) const;
    TGetsewithinfo& SetGetsewithinfo(void);
    void SetGetsewithinfo(TGetsewithinfo& value);

    // typedef CID1server_maxcomplex TGetblobinfo
    bool IsGetblobinfo(void) const;
    const TGetblobinfo& GetGetblobinfo(void) const;
    TGetblobinfo& SetGetblobinfo(void);
    void SetGetblobinfo(TGetblobinfo& value);


private:
    // copy constructor and assignment operator
    CID1server_request_Base(const CID1server_request_Base& );
    CID1server_request_Base& operator=(const CID1server_request_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        ncbi::TIntId m_Getseqidsfromgi;
        ncbi::TIntId m_Getgihist;
        ncbi::TIntId m_Getgirev;
        ncbi::TIntId m_Getgistate;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CID1server_request_Base::E_Choice CID1server_request_Base::Which(void) const
{
    return m_choice;
}

inline
void CID1server_request_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CID1server_request_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CID1server_request_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CID1server_request_Base::IsInit(void) const
{
    return m_choice == e_Init;
}

inline
void CID1server_request_Base::SetInit(void)
{
    Select(e_Init, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CID1server_request_Base::IsGetgi(void) const
{
    return m_choice == e_Getgi;
}

inline
bool CID1server_request_Base::IsGetsefromgi(void) const
{
    return m_choice == e_Getsefromgi;
}

inline
bool CID1server_request_Base::IsFini(void) const
{
    return m_choice == e_Fini;
}

inline
void CID1server_request_Base::SetFini(void)
{
    Select(e_Fini, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CID1server_request_Base::IsGetseqidsfromgi(void) const
{
    return m_choice == e_Getseqidsfromgi;
}

inline
CID1server_request_Base::TGetseqidsfromgi CID1server_request_Base::GetGetseqidsfromgi(void) const
{
    CheckSelected(e_Getseqidsfromgi);
    return reinterpret_cast<const TGetseqidsfromgi&>(m_Getseqidsfromgi);
}

inline
CID1server_request_Base::TGetseqidsfromgi& CID1server_request_Base::SetGetseqidsfromgi(void)
{
    Select(e_Getseqidsfromgi, NCBI_NS_NCBI::eDoNotResetVariant);
    return reinterpret_cast<TGetseqidsfromgi&>(m_Getseqidsfromgi);
}

inline
void CID1server_request_Base::SetGetseqidsfromgi(CID1server_request_Base::TGetseqidsfromgi value)
{
    Select(e_Getseqidsfromgi, NCBI_NS_NCBI::eDoNotResetVariant);
    reinterpret_cast<TGetseqidsfromgi&>(m_Getseqidsfromgi) = value;
}

inline
bool CID1server_request_Base::IsGetgihist(void) const
{
    return m_choice == e_Getgihist;
}

inline
CID1server_request_Base::TGetgihist CID1server_request_Base::GetGetgihist(void) const
{
    CheckSelected(e_Getgihist);
    return reinterpret_cast<const TGetgihist&>(m_Getgihist);
}

inline
CID1server_request_Base::TGetgihist& CID1server_request_Base::SetGetgihist(void)
{
    Select(e_Getgihist, NCBI_NS_NCBI::eDoNotResetVariant);
    return reinterpret_cast<TGetgihist&>(m_Getgihist);
}

inline
void CID1server_request_Base::SetGetgihist(CID1server_request_Base::TGetgihist value)
{
    Select(e_Getgihist, NCBI_NS_NCBI::eDoNotResetVariant);
    reinterpret_cast<TGetgihist&>(m_Getgihist) = value;
}

inline
bool CID1server_request_Base::IsGetgirev(void) const
{
    return m_choice == e_Getgirev;
}

inline
CID1server_request_Base::TGetgirev CID1server_request_Base::GetGetgirev(void) const
{
    CheckSelected(e_Getgirev);
    return reinterpret_cast<const TGetgirev&>(m_Getgirev);
}

inline
CID1server_request_Base::TGetgirev& CID1server_request_Base::SetGetgirev(void)
{
    Select(e_Getgirev, NCBI_NS_NCBI::eDoNotResetVariant);
    return reinterpret_cast<TGetgirev&>(m_Getgirev);
}

inline
void CID1server_request_Base::SetGetgirev(CID1server_request_Base::TGetgirev value)
{
    Select(e_Getgirev, NCBI_NS_NCBI::eDoNotResetVariant);
    reinterpret_cast<TGetgirev&>(m_Getgirev) = value;
}

inline
bool CID1server_request_Base::IsGetgistate(void) const
{
    return m_choice == e_Getgistate;
}

inline
CID1server_request_Base::TGetgistate CID1server_request_Base::GetGetgistate(void) const
{
    CheckSelected(e_Getgistate);
    return reinterpret_cast<const TGetgistate&>(m_Getgistate);
}

inline
CID1server_request_Base::TGetgistate& CID1server_request_Base::SetGetgistate(void)
{
    Select(e_Getgistate, NCBI_NS_NCBI::eDoNotResetVariant);
    return reinterpret_cast<TGetgistate&>(m_Getgistate);
}

inline
void CID1server_request_Base::SetGetgistate(CID1server_request_Base::TGetgistate value)
{
    Select(e_Getgistate, NCBI_NS_NCBI::eDoNotResetVariant);
    reinterpret_cast<TGetgistate&>(m_Getgistate) = value;
}

inline
bool CID1server_request_Base::IsGetsewithinfo(void) const
{
    return m_choice == e_Getsewithinfo;
}

inline
bool CID1server_request_Base::IsGetblobinfo(void) const
{
    return m_choice == e_Getblobinfo;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ID1_ID1SERVER_REQUEST_BASE_HPP
