/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID2S_Reply_Get_Chunk_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'id2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ID2_ID2S_REPLY_GET_CHUNK_BASE_HPP
#define OBJECTS_ID2_ID2S_REPLY_GET_CHUNK_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/seqsplit/ID2S_Chunk_Id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CID2_Blob_Id;
class CID2_Reply_Data;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Reply to ID2S-Request-Get-Chunks.
class NCBI_ID2_EXPORT CID2S_Reply_Get_Chunk_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID2S_Reply_Get_Chunk_Base(void);
    // destructor
    virtual ~CID2S_Reply_Get_Chunk_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CID2_Blob_Id TBlob_id;
    typedef CID2S_Chunk_Id TChunk_id;
    typedef CID2_Reply_Data TData;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_blob_id,
        e_chunk_id,
        e_data
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CID2_Blob_Id TBlob_id
    ///  Check whether the Blob_id data member has been assigned a value.
    bool IsSetBlob_id(void) const;
    /// Check whether it is safe or not to call GetBlob_id method.
    bool CanGetBlob_id(void) const;
    void ResetBlob_id(void);
    const TBlob_id& GetBlob_id(void) const;
    void SetBlob_id(TBlob_id& value);
    TBlob_id& SetBlob_id(void);

    /// id of chunk to send
    /// mandatory
    /// typedef CID2S_Chunk_Id TChunk_id
    ///  Check whether the Chunk_id data member has been assigned a value.
    bool IsSetChunk_id(void) const;
    /// Check whether it is safe or not to call GetChunk_id method.
    bool CanGetChunk_id(void) const;
    void ResetChunk_id(void);
    const TChunk_id& GetChunk_id(void) const;
    void SetChunk_id(const TChunk_id& value);
    TChunk_id& SetChunk_id(void);

    /// chunk data
    /// not set if error occurred
    /// optional
    /// typedef CID2_Reply_Data TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    void SetData(TData& value);
    TData& SetData(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CID2S_Reply_Get_Chunk_Base(const CID2S_Reply_Get_Chunk_Base&);
    CID2S_Reply_Get_Chunk_Base& operator=(const CID2S_Reply_Get_Chunk_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TBlob_id > m_Blob_id;
    CID2S_Chunk_Id m_Chunk_id;
    CRef< TData > m_Data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CID2S_Reply_Get_Chunk_Base::IsSetBlob_id(void) const
{
    return m_Blob_id.NotEmpty();
}

inline
bool CID2S_Reply_Get_Chunk_Base::CanGetBlob_id(void) const
{
    return true;
}

inline
const CID2S_Reply_Get_Chunk_Base::TBlob_id& CID2S_Reply_Get_Chunk_Base::GetBlob_id(void) const
{
    if ( !m_Blob_id ) {
        const_cast<CID2S_Reply_Get_Chunk_Base*>(this)->ResetBlob_id();
    }
    return (*m_Blob_id);
}

inline
CID2S_Reply_Get_Chunk_Base::TBlob_id& CID2S_Reply_Get_Chunk_Base::SetBlob_id(void)
{
    if ( !m_Blob_id ) {
        ResetBlob_id();
    }
    return (*m_Blob_id);
}

inline
bool CID2S_Reply_Get_Chunk_Base::IsSetChunk_id(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CID2S_Reply_Get_Chunk_Base::CanGetChunk_id(void) const
{
    return IsSetChunk_id();
}

inline
void CID2S_Reply_Get_Chunk_Base::ResetChunk_id(void)
{
    m_Chunk_id = CID2S_Chunk_Id(0);
    m_set_State[0] &= ~0xc;
}

inline
const CID2S_Reply_Get_Chunk_Base::TChunk_id& CID2S_Reply_Get_Chunk_Base::GetChunk_id(void) const
{
    if (!CanGetChunk_id()) {
        ThrowUnassigned(1);
    }
    return m_Chunk_id;
}

inline
void CID2S_Reply_Get_Chunk_Base::SetChunk_id(const CID2S_Reply_Get_Chunk_Base::TChunk_id& value)
{
    m_Chunk_id = value;
    m_set_State[0] |= 0xc;
}

inline
CID2S_Reply_Get_Chunk_Base::TChunk_id& CID2S_Reply_Get_Chunk_Base::SetChunk_id(void)
{
    m_set_State[0] |= 0x4;
    return m_Chunk_id;
}

inline
bool CID2S_Reply_Get_Chunk_Base::IsSetData(void) const
{
    return m_Data.NotEmpty();
}

inline
bool CID2S_Reply_Get_Chunk_Base::CanGetData(void) const
{
    return IsSetData();
}

inline
const CID2S_Reply_Get_Chunk_Base::TData& CID2S_Reply_Get_Chunk_Base::GetData(void) const
{
    if (!CanGetData()) {
        ThrowUnassigned(2);
    }
    return (*m_Data);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ID2_ID2S_REPLY_GET_CHUNK_BASE_HPP
