/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID2_Request_Get_Blob_Info_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'id2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ID2_ID2_REQUEST_GET_BLOB_INFO_BASE_HPP
#define OBJECTS_ID2_ID2_REQUEST_GET_BLOB_INFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CID2_Blob_Id;
class CID2_Get_Blob_Details;
class CID2_Request_Get_Blob_Id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Return some information related to the blob.
/// This request with be replied with one or more of:
///   ID2-Reply-Get-Blob-Seq-ids - if requested by get-seq-ids field
///   ID2-Reply-Get-Blob         - if requested by get-data field
///   ID2S-Reply-Get-Split-Info
///   ID2S-Reply-Get-Chunk
/// Last two can be sent in addition to ID2-Reply-Get-Blob
/// if the blob is split on the server.
/// The replies are made separate to allow server to create replies easier
/// from precalculated data. Each of these replies have ID2-Reply-Data field.
class NCBI_ID2_EXPORT CID2_Request_Get_Blob_Info_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID2_Request_Get_Blob_Info_Base(void);
    // destructor
    virtual ~CID2_Request_Get_Blob_Info_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    /// id can be supplied by inner request
    class NCBI_ID2_EXPORT C_Blob_id : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Blob_id(void);
        // destructor
        ~C_Blob_id(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        /// generate blob-ids from request
        class NCBI_ID2_EXPORT C_Resolve : public CSerialObject
        {
            typedef CSerialObject Tparent;
        public:
            // constructor
            C_Resolve(void);
            // destructor
            ~C_Resolve(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef CID2_Request_Get_Blob_Id TRequest;
            typedef list< CRef< CID2_Blob_Id > > TExclude_blobs;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_request,
                e_exclude_blobs
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
        
            // getters
            // setters
        
            /// mandatory
            /// typedef CID2_Request_Get_Blob_Id TRequest
            ///  Check whether the Request data member has been assigned a value.
            bool IsSetRequest(void) const;
            /// Check whether it is safe or not to call GetRequest method.
            bool CanGetRequest(void) const;
            void ResetRequest(void);
            const TRequest& GetRequest(void) const;
            void SetRequest(TRequest& value);
            TRequest& SetRequest(void);
        
            /// server will not send blobs listed here
            /// optional
            /// typedef list< CRef< CID2_Blob_Id > > TExclude_blobs
            ///  Check whether the Exclude_blobs data member has been assigned a value.
            bool IsSetExclude_blobs(void) const;
            /// Check whether it is safe or not to call GetExclude_blobs method.
            bool CanGetExclude_blobs(void) const;
            void ResetExclude_blobs(void);
            const TExclude_blobs& GetExclude_blobs(void) const;
            TExclude_blobs& SetExclude_blobs(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_Resolve(const C_Resolve&);
            C_Resolve& operator=(const C_Resolve&);
        
            // data
            Uint4 m_set_State[1];
            CRef< TRequest > m_Request;
            list< CRef< CID2_Blob_Id > > m_Exclude_blobs;
        };
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Blob_id,      ///< id can be supplied by inner request
            e_Resolve
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_Resolve+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef CID2_Blob_Id TBlob_id;
        typedef C_Resolve TResolve;
    
        // getters
        // setters
    
        // typedef CID2_Blob_Id TBlob_id
        bool IsBlob_id(void) const;
        const TBlob_id& GetBlob_id(void) const;
        TBlob_id& SetBlob_id(void);
        void SetBlob_id(TBlob_id& value);
    
        // typedef C_Resolve TResolve
        bool IsResolve(void) const;
        const TResolve& GetResolve(void) const;
        TResolve& SetResolve(void);
        void SetResolve(TResolve& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Blob_id(const C_Blob_id& );
        C_Blob_id& operator=(const C_Blob_id& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
    // types
    typedef C_Blob_id TBlob_id;
    typedef CID2_Get_Blob_Details TGet_data;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_blob_id,
        e_get_seq_ids,
        e_get_data
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Blob_id TBlob_id
    ///  Check whether the Blob_id data member has been assigned a value.
    bool IsSetBlob_id(void) const;
    /// Check whether it is safe or not to call GetBlob_id method.
    bool CanGetBlob_id(void) const;
    void ResetBlob_id(void);
    const TBlob_id& GetBlob_id(void) const;
    void SetBlob_id(TBlob_id& value);
    TBlob_id& SetBlob_id(void);

    /// return in addition list of Seq-ids also resolving to this blob
    /// optional
    ///  Check whether the Get_seq_ids data member has been assigned a value.
    bool IsSetGet_seq_ids(void) const;
    /// Check whether it is safe or not to call GetGet_seq_ids method.
    bool CanGetGet_seq_ids(void) const;
    void ResetGet_seq_ids(void);
    void SetGet_seq_ids(void);

    /// level of details requested immediately
    /// server will send relevant chunks if blob is splitted
    /// optional
    /// typedef CID2_Get_Blob_Details TGet_data
    ///  Check whether the Get_data data member has been assigned a value.
    bool IsSetGet_data(void) const;
    /// Check whether it is safe or not to call GetGet_data method.
    bool CanGetGet_data(void) const;
    void ResetGet_data(void);
    const TGet_data& GetGet_data(void) const;
    void SetGet_data(TGet_data& value);
    TGet_data& SetGet_data(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CID2_Request_Get_Blob_Info_Base(const CID2_Request_Get_Blob_Info_Base&);
    CID2_Request_Get_Blob_Info_Base& operator=(const CID2_Request_Get_Blob_Info_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TBlob_id > m_Blob_id;
    CRef< TGet_data > m_Get_data;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CID2_Request_Get_Blob_Info_Base::C_Blob_id::C_Resolve::IsSetRequest(void) const
{
    return m_Request.NotEmpty();
}

inline
bool CID2_Request_Get_Blob_Info_Base::C_Blob_id::C_Resolve::CanGetRequest(void) const
{
    return true;
}

inline
const CID2_Request_Get_Blob_Info_Base::C_Blob_id::C_Resolve::TRequest& CID2_Request_Get_Blob_Info_Base::C_Blob_id::C_Resolve::GetRequest(void) const
{
    if ( !m_Request ) {
        const_cast<C_Resolve*>(this)->ResetRequest();
    }
    return (*m_Request);
}

inline
CID2_Request_Get_Blob_Info_Base::C_Blob_id::C_Resolve::TRequest& CID2_Request_Get_Blob_Info_Base::C_Blob_id::C_Resolve::SetRequest(void)
{
    if ( !m_Request ) {
        ResetRequest();
    }
    return (*m_Request);
}

inline
bool CID2_Request_Get_Blob_Info_Base::C_Blob_id::C_Resolve::IsSetExclude_blobs(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CID2_Request_Get_Blob_Info_Base::C_Blob_id::C_Resolve::CanGetExclude_blobs(void) const
{
    return true;
}

inline
const CID2_Request_Get_Blob_Info_Base::C_Blob_id::C_Resolve::TExclude_blobs& CID2_Request_Get_Blob_Info_Base::C_Blob_id::C_Resolve::GetExclude_blobs(void) const
{
    return m_Exclude_blobs;
}

inline
CID2_Request_Get_Blob_Info_Base::C_Blob_id::C_Resolve::TExclude_blobs& CID2_Request_Get_Blob_Info_Base::C_Blob_id::C_Resolve::SetExclude_blobs(void)
{
    m_set_State[0] |= 0x4;
    return m_Exclude_blobs;
}

inline
CID2_Request_Get_Blob_Info_Base::C_Blob_id::E_Choice CID2_Request_Get_Blob_Info_Base::C_Blob_id::Which(void) const
{
    return m_choice;
}

inline
void CID2_Request_Get_Blob_Info_Base::C_Blob_id::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CID2_Request_Get_Blob_Info_Base::C_Blob_id::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CID2_Request_Get_Blob_Info_Base::C_Blob_id::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CID2_Request_Get_Blob_Info_Base::C_Blob_id::IsBlob_id(void) const
{
    return m_choice == e_Blob_id;
}

inline
bool CID2_Request_Get_Blob_Info_Base::C_Blob_id::IsResolve(void) const
{
    return m_choice == e_Resolve;
}

inline
bool CID2_Request_Get_Blob_Info_Base::IsSetBlob_id(void) const
{
    return m_Blob_id.NotEmpty();
}

inline
bool CID2_Request_Get_Blob_Info_Base::CanGetBlob_id(void) const
{
    return true;
}

inline
const CID2_Request_Get_Blob_Info_Base::TBlob_id& CID2_Request_Get_Blob_Info_Base::GetBlob_id(void) const
{
    if ( !m_Blob_id ) {
        const_cast<CID2_Request_Get_Blob_Info_Base*>(this)->ResetBlob_id();
    }
    return (*m_Blob_id);
}

inline
CID2_Request_Get_Blob_Info_Base::TBlob_id& CID2_Request_Get_Blob_Info_Base::SetBlob_id(void)
{
    if ( !m_Blob_id ) {
        ResetBlob_id();
    }
    return (*m_Blob_id);
}

inline
bool CID2_Request_Get_Blob_Info_Base::IsSetGet_seq_ids(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CID2_Request_Get_Blob_Info_Base::CanGetGet_seq_ids(void) const
{
    return false;
}

inline
void CID2_Request_Get_Blob_Info_Base::ResetGet_seq_ids(void)
{
    m_set_State[0] &= ~0xc;
}

inline
void CID2_Request_Get_Blob_Info_Base::SetGet_seq_ids(void)
{
    m_set_State[0] |= 0xc;
}

inline
bool CID2_Request_Get_Blob_Info_Base::IsSetGet_data(void) const
{
    return m_Get_data.NotEmpty();
}

inline
bool CID2_Request_Get_Blob_Info_Base::CanGetGet_data(void) const
{
    return IsSetGet_data();
}

inline
const CID2_Request_Get_Blob_Info_Base::TGet_data& CID2_Request_Get_Blob_Info_Base::GetGet_data(void) const
{
    if (!CanGetGet_data()) {
        ThrowUnassigned(2);
    }
    return (*m_Get_data);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ID2_ID2_REQUEST_GET_BLOB_INFO_BASE_HPP
