/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file INSDAltSeqItem_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'insdseq.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_INSDSEQ_INSDALTSEQITEM_BASE_HPP
#define OBJECTS_INSDSEQ_INSDALTSEQITEM_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CINSDInterval;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_INSDSEQ_EXPORT CINSDAltSeqItem_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CINSDAltSeqItem_Base(void);
    // destructor
    virtual ~CINSDAltSeqItem_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CINSDInterval TInterval;
    typedef bool TIsgap;
    typedef int TGap_length;
    typedef string TGap_type;
    typedef string TGap_linkage;
    typedef string TGap_comment;
    typedef string TFirst_accn;
    typedef string TLast_accn;
    typedef string TValue;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_interval,
        e_isgap,
        e_gap_length,
        e_gap_type,
        e_gap_linkage,
        e_gap_comment,
        e_first_accn,
        e_last_accn,
        e_value
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef CINSDInterval TInterval
    ///  Check whether the Interval data member has been assigned a value.
    bool IsSetInterval(void) const;
    /// Check whether it is safe or not to call GetInterval method.
    bool CanGetInterval(void) const;
    void ResetInterval(void);
    const TInterval& GetInterval(void) const;
    void SetInterval(TInterval& value);
    TInterval& SetInterval(void);

    /// optional
    /// typedef bool TIsgap
    ///  Check whether the Isgap data member has been assigned a value.
    bool IsSetIsgap(void) const;
    /// Check whether it is safe or not to call GetIsgap method.
    bool CanGetIsgap(void) const;
    void ResetIsgap(void);
    TIsgap GetIsgap(void) const;
    void SetIsgap(TIsgap value);
    TIsgap& SetIsgap(void);

    /// optional
    /// typedef int TGap_length
    ///  Check whether the Gap_length data member has been assigned a value.
    bool IsSetGap_length(void) const;
    /// Check whether it is safe or not to call GetGap_length method.
    bool CanGetGap_length(void) const;
    void ResetGap_length(void);
    TGap_length GetGap_length(void) const;
    void SetGap_length(TGap_length value);
    TGap_length& SetGap_length(void);

    /// optional
    /// typedef string TGap_type
    ///  Check whether the Gap_type data member has been assigned a value.
    bool IsSetGap_type(void) const;
    /// Check whether it is safe or not to call GetGap_type method.
    bool CanGetGap_type(void) const;
    void ResetGap_type(void);
    const TGap_type& GetGap_type(void) const;
    void SetGap_type(const TGap_type& value);
    void SetGap_type(TGap_type&& value);
    TGap_type& SetGap_type(void);

    /// optional
    /// typedef string TGap_linkage
    ///  Check whether the Gap_linkage data member has been assigned a value.
    bool IsSetGap_linkage(void) const;
    /// Check whether it is safe or not to call GetGap_linkage method.
    bool CanGetGap_linkage(void) const;
    void ResetGap_linkage(void);
    const TGap_linkage& GetGap_linkage(void) const;
    void SetGap_linkage(const TGap_linkage& value);
    void SetGap_linkage(TGap_linkage&& value);
    TGap_linkage& SetGap_linkage(void);

    /// optional
    /// typedef string TGap_comment
    ///  Check whether the Gap_comment data member has been assigned a value.
    bool IsSetGap_comment(void) const;
    /// Check whether it is safe or not to call GetGap_comment method.
    bool CanGetGap_comment(void) const;
    void ResetGap_comment(void);
    const TGap_comment& GetGap_comment(void) const;
    void SetGap_comment(const TGap_comment& value);
    void SetGap_comment(TGap_comment&& value);
    TGap_comment& SetGap_comment(void);

    /// optional
    /// typedef string TFirst_accn
    ///  Check whether the First_accn data member has been assigned a value.
    bool IsSetFirst_accn(void) const;
    /// Check whether it is safe or not to call GetFirst_accn method.
    bool CanGetFirst_accn(void) const;
    void ResetFirst_accn(void);
    const TFirst_accn& GetFirst_accn(void) const;
    void SetFirst_accn(const TFirst_accn& value);
    void SetFirst_accn(TFirst_accn&& value);
    TFirst_accn& SetFirst_accn(void);

    /// optional
    /// typedef string TLast_accn
    ///  Check whether the Last_accn data member has been assigned a value.
    bool IsSetLast_accn(void) const;
    /// Check whether it is safe or not to call GetLast_accn method.
    bool CanGetLast_accn(void) const;
    void ResetLast_accn(void);
    const TLast_accn& GetLast_accn(void) const;
    void SetLast_accn(const TLast_accn& value);
    void SetLast_accn(TLast_accn&& value);
    TLast_accn& SetLast_accn(void);

    /// optional
    /// typedef string TValue
    ///  Check whether the Value data member has been assigned a value.
    bool IsSetValue(void) const;
    /// Check whether it is safe or not to call GetValue method.
    bool CanGetValue(void) const;
    void ResetValue(void);
    const TValue& GetValue(void) const;
    void SetValue(const TValue& value);
    void SetValue(TValue&& value);
    TValue& SetValue(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CINSDAltSeqItem_Base(const CINSDAltSeqItem_Base&);
    CINSDAltSeqItem_Base& operator=(const CINSDAltSeqItem_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TInterval > m_Interval;
    bool m_Isgap;
    int m_Gap_length;
    string m_Gap_type;
    string m_Gap_linkage;
    string m_Gap_comment;
    string m_First_accn;
    string m_Last_accn;
    string m_Value;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CINSDAltSeqItem_Base::IsSetInterval(void) const
{
    return m_Interval.NotEmpty();
}

inline
bool CINSDAltSeqItem_Base::CanGetInterval(void) const
{
    return IsSetInterval();
}

inline
const CINSDAltSeqItem_Base::TInterval& CINSDAltSeqItem_Base::GetInterval(void) const
{
    if (!CanGetInterval()) {
        ThrowUnassigned(0);
    }
    return (*m_Interval);
}

inline
bool CINSDAltSeqItem_Base::IsSetIsgap(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CINSDAltSeqItem_Base::CanGetIsgap(void) const
{
    return IsSetIsgap();
}

inline
void CINSDAltSeqItem_Base::ResetIsgap(void)
{
    m_Isgap = 0;
    m_set_State[0] &= ~0xc;
}

inline
CINSDAltSeqItem_Base::TIsgap CINSDAltSeqItem_Base::GetIsgap(void) const
{
    if (!CanGetIsgap()) {
        ThrowUnassigned(1);
    }
    return m_Isgap;
}

inline
void CINSDAltSeqItem_Base::SetIsgap(CINSDAltSeqItem_Base::TIsgap value)
{
    m_Isgap = value;
    m_set_State[0] |= 0xc;
}

inline
CINSDAltSeqItem_Base::TIsgap& CINSDAltSeqItem_Base::SetIsgap(void)
{
#ifdef _DEBUG
    if (!IsSetIsgap()) {
        memset(&m_Isgap,UnassignedByte(),sizeof(m_Isgap));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Isgap;
}

inline
bool CINSDAltSeqItem_Base::IsSetGap_length(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CINSDAltSeqItem_Base::CanGetGap_length(void) const
{
    return IsSetGap_length();
}

inline
void CINSDAltSeqItem_Base::ResetGap_length(void)
{
    m_Gap_length = 0;
    m_set_State[0] &= ~0x30;
}

inline
CINSDAltSeqItem_Base::TGap_length CINSDAltSeqItem_Base::GetGap_length(void) const
{
    if (!CanGetGap_length()) {
        ThrowUnassigned(2);
    }
    return m_Gap_length;
}

inline
void CINSDAltSeqItem_Base::SetGap_length(CINSDAltSeqItem_Base::TGap_length value)
{
    m_Gap_length = value;
    m_set_State[0] |= 0x30;
}

inline
CINSDAltSeqItem_Base::TGap_length& CINSDAltSeqItem_Base::SetGap_length(void)
{
#ifdef _DEBUG
    if (!IsSetGap_length()) {
        memset(&m_Gap_length,UnassignedByte(),sizeof(m_Gap_length));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Gap_length;
}

inline
bool CINSDAltSeqItem_Base::IsSetGap_type(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CINSDAltSeqItem_Base::CanGetGap_type(void) const
{
    return IsSetGap_type();
}

inline
const CINSDAltSeqItem_Base::TGap_type& CINSDAltSeqItem_Base::GetGap_type(void) const
{
    if (!CanGetGap_type()) {
        ThrowUnassigned(3);
    }
    return m_Gap_type;
}

inline
void CINSDAltSeqItem_Base::SetGap_type(const CINSDAltSeqItem_Base::TGap_type& value)
{
    m_Gap_type = value;
    m_set_State[0] |= 0xc0;
}

inline
void CINSDAltSeqItem_Base::SetGap_type(CINSDAltSeqItem_Base::TGap_type&& value)
{
    m_Gap_type = std::forward<CINSDAltSeqItem_Base::TGap_type>(value);
    m_set_State[0] |= 0xc0;
}

inline
CINSDAltSeqItem_Base::TGap_type& CINSDAltSeqItem_Base::SetGap_type(void)
{
#ifdef _DEBUG
    if (!IsSetGap_type()) {
        m_Gap_type = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Gap_type;
}

inline
bool CINSDAltSeqItem_Base::IsSetGap_linkage(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CINSDAltSeqItem_Base::CanGetGap_linkage(void) const
{
    return IsSetGap_linkage();
}

inline
const CINSDAltSeqItem_Base::TGap_linkage& CINSDAltSeqItem_Base::GetGap_linkage(void) const
{
    if (!CanGetGap_linkage()) {
        ThrowUnassigned(4);
    }
    return m_Gap_linkage;
}

inline
void CINSDAltSeqItem_Base::SetGap_linkage(const CINSDAltSeqItem_Base::TGap_linkage& value)
{
    m_Gap_linkage = value;
    m_set_State[0] |= 0x300;
}

inline
void CINSDAltSeqItem_Base::SetGap_linkage(CINSDAltSeqItem_Base::TGap_linkage&& value)
{
    m_Gap_linkage = std::forward<CINSDAltSeqItem_Base::TGap_linkage>(value);
    m_set_State[0] |= 0x300;
}

inline
CINSDAltSeqItem_Base::TGap_linkage& CINSDAltSeqItem_Base::SetGap_linkage(void)
{
#ifdef _DEBUG
    if (!IsSetGap_linkage()) {
        m_Gap_linkage = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Gap_linkage;
}

inline
bool CINSDAltSeqItem_Base::IsSetGap_comment(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CINSDAltSeqItem_Base::CanGetGap_comment(void) const
{
    return IsSetGap_comment();
}

inline
const CINSDAltSeqItem_Base::TGap_comment& CINSDAltSeqItem_Base::GetGap_comment(void) const
{
    if (!CanGetGap_comment()) {
        ThrowUnassigned(5);
    }
    return m_Gap_comment;
}

inline
void CINSDAltSeqItem_Base::SetGap_comment(const CINSDAltSeqItem_Base::TGap_comment& value)
{
    m_Gap_comment = value;
    m_set_State[0] |= 0xc00;
}

inline
void CINSDAltSeqItem_Base::SetGap_comment(CINSDAltSeqItem_Base::TGap_comment&& value)
{
    m_Gap_comment = std::forward<CINSDAltSeqItem_Base::TGap_comment>(value);
    m_set_State[0] |= 0xc00;
}

inline
CINSDAltSeqItem_Base::TGap_comment& CINSDAltSeqItem_Base::SetGap_comment(void)
{
#ifdef _DEBUG
    if (!IsSetGap_comment()) {
        m_Gap_comment = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Gap_comment;
}

inline
bool CINSDAltSeqItem_Base::IsSetFirst_accn(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CINSDAltSeqItem_Base::CanGetFirst_accn(void) const
{
    return IsSetFirst_accn();
}

inline
const CINSDAltSeqItem_Base::TFirst_accn& CINSDAltSeqItem_Base::GetFirst_accn(void) const
{
    if (!CanGetFirst_accn()) {
        ThrowUnassigned(6);
    }
    return m_First_accn;
}

inline
void CINSDAltSeqItem_Base::SetFirst_accn(const CINSDAltSeqItem_Base::TFirst_accn& value)
{
    m_First_accn = value;
    m_set_State[0] |= 0x3000;
}

inline
void CINSDAltSeqItem_Base::SetFirst_accn(CINSDAltSeqItem_Base::TFirst_accn&& value)
{
    m_First_accn = std::forward<CINSDAltSeqItem_Base::TFirst_accn>(value);
    m_set_State[0] |= 0x3000;
}

inline
CINSDAltSeqItem_Base::TFirst_accn& CINSDAltSeqItem_Base::SetFirst_accn(void)
{
#ifdef _DEBUG
    if (!IsSetFirst_accn()) {
        m_First_accn = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_First_accn;
}

inline
bool CINSDAltSeqItem_Base::IsSetLast_accn(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CINSDAltSeqItem_Base::CanGetLast_accn(void) const
{
    return IsSetLast_accn();
}

inline
const CINSDAltSeqItem_Base::TLast_accn& CINSDAltSeqItem_Base::GetLast_accn(void) const
{
    if (!CanGetLast_accn()) {
        ThrowUnassigned(7);
    }
    return m_Last_accn;
}

inline
void CINSDAltSeqItem_Base::SetLast_accn(const CINSDAltSeqItem_Base::TLast_accn& value)
{
    m_Last_accn = value;
    m_set_State[0] |= 0xc000;
}

inline
void CINSDAltSeqItem_Base::SetLast_accn(CINSDAltSeqItem_Base::TLast_accn&& value)
{
    m_Last_accn = std::forward<CINSDAltSeqItem_Base::TLast_accn>(value);
    m_set_State[0] |= 0xc000;
}

inline
CINSDAltSeqItem_Base::TLast_accn& CINSDAltSeqItem_Base::SetLast_accn(void)
{
#ifdef _DEBUG
    if (!IsSetLast_accn()) {
        m_Last_accn = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Last_accn;
}

inline
bool CINSDAltSeqItem_Base::IsSetValue(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CINSDAltSeqItem_Base::CanGetValue(void) const
{
    return IsSetValue();
}

inline
const CINSDAltSeqItem_Base::TValue& CINSDAltSeqItem_Base::GetValue(void) const
{
    if (!CanGetValue()) {
        ThrowUnassigned(8);
    }
    return m_Value;
}

inline
void CINSDAltSeqItem_Base::SetValue(const CINSDAltSeqItem_Base::TValue& value)
{
    m_Value = value;
    m_set_State[0] |= 0x30000;
}

inline
void CINSDAltSeqItem_Base::SetValue(CINSDAltSeqItem_Base::TValue&& value)
{
    m_Value = std::forward<CINSDAltSeqItem_Base::TValue>(value);
    m_set_State[0] |= 0x30000;
}

inline
CINSDAltSeqItem_Base::TValue& CINSDAltSeqItem_Base::SetValue(void)
{
#ifdef _DEBUG
    if (!IsSetValue()) {
        m_Value = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Value;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_INSDSEQ_INSDALTSEQITEM_BASE_HPP
