/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Adjus_featu_for_gaps_actio_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_ADJUS_FEATU_FOR_GAPS_ACTIO_BASE_HPP
#define OBJECTS_MACRO_ADJUS_FEATU_FOR_GAPS_ACTIO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/macro/Macro_feature_type.hpp>
#include <objects/macro/Truncate_ends_partial_type.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CAdjust_features_for_gaps_action_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAdjust_features_for_gaps_action_Base(void);
    // destructor
    virtual ~CAdjust_features_for_gaps_action_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef EMacro_feature_type TType;
    typedef bool TAdjust_for_unknown_length_gaps;
    typedef bool TAdjust_for_known_length_gaps;
    typedef ETruncated_ends_partial_type TMake_truncated_ends_partial;
    typedef bool TTrim_ends_in_gaps;
    typedef bool TSplit_for_internal_gaps;
    typedef bool TEven_when_gaps_are_in_introns;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_adjust_for_unknown_length_gaps,
        e_adjust_for_known_length_gaps,
        e_make_truncated_ends_partial,
        e_trim_ends_in_gaps,
        e_split_for_internal_gaps,
        e_even_when_gaps_are_in_introns
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef EMacro_feature_type TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// mandatory
    /// typedef bool TAdjust_for_unknown_length_gaps
    ///  Check whether the Adjust_for_unknown_length_gaps data member has been assigned a value.
    bool IsSetAdjust_for_unknown_length_gaps(void) const;
    /// Check whether it is safe or not to call GetAdjust_for_unknown_length_gaps method.
    bool CanGetAdjust_for_unknown_length_gaps(void) const;
    void ResetAdjust_for_unknown_length_gaps(void);
    TAdjust_for_unknown_length_gaps GetAdjust_for_unknown_length_gaps(void) const;
    void SetAdjust_for_unknown_length_gaps(TAdjust_for_unknown_length_gaps value);
    TAdjust_for_unknown_length_gaps& SetAdjust_for_unknown_length_gaps(void);

    /// mandatory
    /// typedef bool TAdjust_for_known_length_gaps
    ///  Check whether the Adjust_for_known_length_gaps data member has been assigned a value.
    bool IsSetAdjust_for_known_length_gaps(void) const;
    /// Check whether it is safe or not to call GetAdjust_for_known_length_gaps method.
    bool CanGetAdjust_for_known_length_gaps(void) const;
    void ResetAdjust_for_known_length_gaps(void);
    TAdjust_for_known_length_gaps GetAdjust_for_known_length_gaps(void) const;
    void SetAdjust_for_known_length_gaps(TAdjust_for_known_length_gaps value);
    TAdjust_for_known_length_gaps& SetAdjust_for_known_length_gaps(void);

    /// mandatory
    /// typedef ETruncated_ends_partial_type TMake_truncated_ends_partial
    ///  Check whether the Make_truncated_ends_partial data member has been assigned a value.
    bool IsSetMake_truncated_ends_partial(void) const;
    /// Check whether it is safe or not to call GetMake_truncated_ends_partial method.
    bool CanGetMake_truncated_ends_partial(void) const;
    void ResetMake_truncated_ends_partial(void);
    TMake_truncated_ends_partial GetMake_truncated_ends_partial(void) const;
    void SetMake_truncated_ends_partial(TMake_truncated_ends_partial value);
    TMake_truncated_ends_partial& SetMake_truncated_ends_partial(void);

    /// mandatory
    /// typedef bool TTrim_ends_in_gaps
    ///  Check whether the Trim_ends_in_gaps data member has been assigned a value.
    bool IsSetTrim_ends_in_gaps(void) const;
    /// Check whether it is safe or not to call GetTrim_ends_in_gaps method.
    bool CanGetTrim_ends_in_gaps(void) const;
    void ResetTrim_ends_in_gaps(void);
    TTrim_ends_in_gaps GetTrim_ends_in_gaps(void) const;
    void SetTrim_ends_in_gaps(TTrim_ends_in_gaps value);
    TTrim_ends_in_gaps& SetTrim_ends_in_gaps(void);

    /// mandatory
    /// typedef bool TSplit_for_internal_gaps
    ///  Check whether the Split_for_internal_gaps data member has been assigned a value.
    bool IsSetSplit_for_internal_gaps(void) const;
    /// Check whether it is safe or not to call GetSplit_for_internal_gaps method.
    bool CanGetSplit_for_internal_gaps(void) const;
    void ResetSplit_for_internal_gaps(void);
    TSplit_for_internal_gaps GetSplit_for_internal_gaps(void) const;
    void SetSplit_for_internal_gaps(TSplit_for_internal_gaps value);
    TSplit_for_internal_gaps& SetSplit_for_internal_gaps(void);

    /// mandatory
    /// typedef bool TEven_when_gaps_are_in_introns
    ///  Check whether the Even_when_gaps_are_in_introns data member has been assigned a value.
    bool IsSetEven_when_gaps_are_in_introns(void) const;
    /// Check whether it is safe or not to call GetEven_when_gaps_are_in_introns method.
    bool CanGetEven_when_gaps_are_in_introns(void) const;
    void ResetEven_when_gaps_are_in_introns(void);
    TEven_when_gaps_are_in_introns GetEven_when_gaps_are_in_introns(void) const;
    void SetEven_when_gaps_are_in_introns(TEven_when_gaps_are_in_introns value);
    TEven_when_gaps_are_in_introns& SetEven_when_gaps_are_in_introns(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAdjust_features_for_gaps_action_Base(const CAdjust_features_for_gaps_action_Base&);
    CAdjust_features_for_gaps_action_Base& operator=(const CAdjust_features_for_gaps_action_Base&);

    // data
    Uint4 m_set_State[1];
    EMacro_feature_type m_Type;
    bool m_Adjust_for_unknown_length_gaps;
    bool m_Adjust_for_known_length_gaps;
    ETruncated_ends_partial_type m_Make_truncated_ends_partial;
    bool m_Trim_ends_in_gaps;
    bool m_Split_for_internal_gaps;
    bool m_Even_when_gaps_are_in_introns;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAdjust_features_for_gaps_action_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAdjust_features_for_gaps_action_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CAdjust_features_for_gaps_action_Base::ResetType(void)
{
    m_Type = (ncbi::objects::EMacro_feature_type)(0);
    m_set_State[0] &= ~0x3;
}

inline
CAdjust_features_for_gaps_action_Base::TType CAdjust_features_for_gaps_action_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CAdjust_features_for_gaps_action_Base::SetType(CAdjust_features_for_gaps_action_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CAdjust_features_for_gaps_action_Base::TType& CAdjust_features_for_gaps_action_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CAdjust_features_for_gaps_action_Base::IsSetAdjust_for_unknown_length_gaps(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAdjust_features_for_gaps_action_Base::CanGetAdjust_for_unknown_length_gaps(void) const
{
    return IsSetAdjust_for_unknown_length_gaps();
}

inline
void CAdjust_features_for_gaps_action_Base::ResetAdjust_for_unknown_length_gaps(void)
{
    m_Adjust_for_unknown_length_gaps = 0;
    m_set_State[0] &= ~0xc;
}

inline
CAdjust_features_for_gaps_action_Base::TAdjust_for_unknown_length_gaps CAdjust_features_for_gaps_action_Base::GetAdjust_for_unknown_length_gaps(void) const
{
    if (!CanGetAdjust_for_unknown_length_gaps()) {
        ThrowUnassigned(1);
    }
    return m_Adjust_for_unknown_length_gaps;
}

inline
void CAdjust_features_for_gaps_action_Base::SetAdjust_for_unknown_length_gaps(CAdjust_features_for_gaps_action_Base::TAdjust_for_unknown_length_gaps value)
{
    m_Adjust_for_unknown_length_gaps = value;
    m_set_State[0] |= 0xc;
}

inline
CAdjust_features_for_gaps_action_Base::TAdjust_for_unknown_length_gaps& CAdjust_features_for_gaps_action_Base::SetAdjust_for_unknown_length_gaps(void)
{
#ifdef _DEBUG
    if (!IsSetAdjust_for_unknown_length_gaps()) {
        memset(&m_Adjust_for_unknown_length_gaps,UnassignedByte(),sizeof(m_Adjust_for_unknown_length_gaps));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Adjust_for_unknown_length_gaps;
}

inline
bool CAdjust_features_for_gaps_action_Base::IsSetAdjust_for_known_length_gaps(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CAdjust_features_for_gaps_action_Base::CanGetAdjust_for_known_length_gaps(void) const
{
    return IsSetAdjust_for_known_length_gaps();
}

inline
void CAdjust_features_for_gaps_action_Base::ResetAdjust_for_known_length_gaps(void)
{
    m_Adjust_for_known_length_gaps = 0;
    m_set_State[0] &= ~0x30;
}

inline
CAdjust_features_for_gaps_action_Base::TAdjust_for_known_length_gaps CAdjust_features_for_gaps_action_Base::GetAdjust_for_known_length_gaps(void) const
{
    if (!CanGetAdjust_for_known_length_gaps()) {
        ThrowUnassigned(2);
    }
    return m_Adjust_for_known_length_gaps;
}

inline
void CAdjust_features_for_gaps_action_Base::SetAdjust_for_known_length_gaps(CAdjust_features_for_gaps_action_Base::TAdjust_for_known_length_gaps value)
{
    m_Adjust_for_known_length_gaps = value;
    m_set_State[0] |= 0x30;
}

inline
CAdjust_features_for_gaps_action_Base::TAdjust_for_known_length_gaps& CAdjust_features_for_gaps_action_Base::SetAdjust_for_known_length_gaps(void)
{
#ifdef _DEBUG
    if (!IsSetAdjust_for_known_length_gaps()) {
        memset(&m_Adjust_for_known_length_gaps,UnassignedByte(),sizeof(m_Adjust_for_known_length_gaps));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Adjust_for_known_length_gaps;
}

inline
bool CAdjust_features_for_gaps_action_Base::IsSetMake_truncated_ends_partial(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CAdjust_features_for_gaps_action_Base::CanGetMake_truncated_ends_partial(void) const
{
    return IsSetMake_truncated_ends_partial();
}

inline
void CAdjust_features_for_gaps_action_Base::ResetMake_truncated_ends_partial(void)
{
    m_Make_truncated_ends_partial = (ncbi::objects::ETruncated_ends_partial_type)(0);
    m_set_State[0] &= ~0xc0;
}

inline
CAdjust_features_for_gaps_action_Base::TMake_truncated_ends_partial CAdjust_features_for_gaps_action_Base::GetMake_truncated_ends_partial(void) const
{
    if (!CanGetMake_truncated_ends_partial()) {
        ThrowUnassigned(3);
    }
    return m_Make_truncated_ends_partial;
}

inline
void CAdjust_features_for_gaps_action_Base::SetMake_truncated_ends_partial(CAdjust_features_for_gaps_action_Base::TMake_truncated_ends_partial value)
{
    m_Make_truncated_ends_partial = value;
    m_set_State[0] |= 0xc0;
}

inline
CAdjust_features_for_gaps_action_Base::TMake_truncated_ends_partial& CAdjust_features_for_gaps_action_Base::SetMake_truncated_ends_partial(void)
{
#ifdef _DEBUG
    if (!IsSetMake_truncated_ends_partial()) {
        memset(&m_Make_truncated_ends_partial,UnassignedByte(),sizeof(m_Make_truncated_ends_partial));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Make_truncated_ends_partial;
}

inline
bool CAdjust_features_for_gaps_action_Base::IsSetTrim_ends_in_gaps(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CAdjust_features_for_gaps_action_Base::CanGetTrim_ends_in_gaps(void) const
{
    return IsSetTrim_ends_in_gaps();
}

inline
void CAdjust_features_for_gaps_action_Base::ResetTrim_ends_in_gaps(void)
{
    m_Trim_ends_in_gaps = 0;
    m_set_State[0] &= ~0x300;
}

inline
CAdjust_features_for_gaps_action_Base::TTrim_ends_in_gaps CAdjust_features_for_gaps_action_Base::GetTrim_ends_in_gaps(void) const
{
    if (!CanGetTrim_ends_in_gaps()) {
        ThrowUnassigned(4);
    }
    return m_Trim_ends_in_gaps;
}

inline
void CAdjust_features_for_gaps_action_Base::SetTrim_ends_in_gaps(CAdjust_features_for_gaps_action_Base::TTrim_ends_in_gaps value)
{
    m_Trim_ends_in_gaps = value;
    m_set_State[0] |= 0x300;
}

inline
CAdjust_features_for_gaps_action_Base::TTrim_ends_in_gaps& CAdjust_features_for_gaps_action_Base::SetTrim_ends_in_gaps(void)
{
#ifdef _DEBUG
    if (!IsSetTrim_ends_in_gaps()) {
        memset(&m_Trim_ends_in_gaps,UnassignedByte(),sizeof(m_Trim_ends_in_gaps));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Trim_ends_in_gaps;
}

inline
bool CAdjust_features_for_gaps_action_Base::IsSetSplit_for_internal_gaps(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CAdjust_features_for_gaps_action_Base::CanGetSplit_for_internal_gaps(void) const
{
    return IsSetSplit_for_internal_gaps();
}

inline
void CAdjust_features_for_gaps_action_Base::ResetSplit_for_internal_gaps(void)
{
    m_Split_for_internal_gaps = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CAdjust_features_for_gaps_action_Base::TSplit_for_internal_gaps CAdjust_features_for_gaps_action_Base::GetSplit_for_internal_gaps(void) const
{
    if (!CanGetSplit_for_internal_gaps()) {
        ThrowUnassigned(5);
    }
    return m_Split_for_internal_gaps;
}

inline
void CAdjust_features_for_gaps_action_Base::SetSplit_for_internal_gaps(CAdjust_features_for_gaps_action_Base::TSplit_for_internal_gaps value)
{
    m_Split_for_internal_gaps = value;
    m_set_State[0] |= 0xc00;
}

inline
CAdjust_features_for_gaps_action_Base::TSplit_for_internal_gaps& CAdjust_features_for_gaps_action_Base::SetSplit_for_internal_gaps(void)
{
#ifdef _DEBUG
    if (!IsSetSplit_for_internal_gaps()) {
        memset(&m_Split_for_internal_gaps,UnassignedByte(),sizeof(m_Split_for_internal_gaps));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Split_for_internal_gaps;
}

inline
bool CAdjust_features_for_gaps_action_Base::IsSetEven_when_gaps_are_in_introns(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CAdjust_features_for_gaps_action_Base::CanGetEven_when_gaps_are_in_introns(void) const
{
    return IsSetEven_when_gaps_are_in_introns();
}

inline
void CAdjust_features_for_gaps_action_Base::ResetEven_when_gaps_are_in_introns(void)
{
    m_Even_when_gaps_are_in_introns = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CAdjust_features_for_gaps_action_Base::TEven_when_gaps_are_in_introns CAdjust_features_for_gaps_action_Base::GetEven_when_gaps_are_in_introns(void) const
{
    if (!CanGetEven_when_gaps_are_in_introns()) {
        ThrowUnassigned(6);
    }
    return m_Even_when_gaps_are_in_introns;
}

inline
void CAdjust_features_for_gaps_action_Base::SetEven_when_gaps_are_in_introns(CAdjust_features_for_gaps_action_Base::TEven_when_gaps_are_in_introns value)
{
    m_Even_when_gaps_are_in_introns = value;
    m_set_State[0] |= 0x3000;
}

inline
CAdjust_features_for_gaps_action_Base::TEven_when_gaps_are_in_introns& CAdjust_features_for_gaps_action_Base::SetEven_when_gaps_are_in_introns(void)
{
#ifdef _DEBUG
    if (!IsSetEven_when_gaps_are_in_introns()) {
        memset(&m_Even_when_gaps_are_in_introns,UnassignedByte(),sizeof(m_Even_when_gaps_are_in_introns));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Even_when_gaps_are_in_introns;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_ADJUS_FEATU_FOR_GAPS_ACTIO_BASE_HPP
