/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Create_TSA_ids_action_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_CREATE_TSA_IDS_ACTION_BASE_HPP
#define OBJECTS_MACRO_CREATE_TSA_IDS_ACTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CCreate_TSA_ids_src;
class CText_portion;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CCreate_TSA_ids_action_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCreate_TSA_ids_action_Base(void);
    // destructor
    virtual ~CCreate_TSA_ids_action_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CCreate_TSA_ids_src TSrc;
    typedef string TSuffix;
    typedef CText_portion TId_text_portion;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_src,
        e_suffix,
        e_id_text_portion
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CCreate_TSA_ids_src TSrc
    ///  Check whether the Src data member has been assigned a value.
    bool IsSetSrc(void) const;
    /// Check whether it is safe or not to call GetSrc method.
    bool CanGetSrc(void) const;
    void ResetSrc(void);
    const TSrc& GetSrc(void) const;
    void SetSrc(TSrc& value);
    TSrc& SetSrc(void);

    /// optional
    /// typedef string TSuffix
    ///  Check whether the Suffix data member has been assigned a value.
    bool IsSetSuffix(void) const;
    /// Check whether it is safe or not to call GetSuffix method.
    bool CanGetSuffix(void) const;
    void ResetSuffix(void);
    const TSuffix& GetSuffix(void) const;
    void SetSuffix(const TSuffix& value);
    void SetSuffix(TSuffix&& value);
    TSuffix& SetSuffix(void);

    /// optional
    /// typedef CText_portion TId_text_portion
    ///  Check whether the Id_text_portion data member has been assigned a value.
    bool IsSetId_text_portion(void) const;
    /// Check whether it is safe or not to call GetId_text_portion method.
    bool CanGetId_text_portion(void) const;
    void ResetId_text_portion(void);
    const TId_text_portion& GetId_text_portion(void) const;
    void SetId_text_portion(TId_text_portion& value);
    TId_text_portion& SetId_text_portion(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCreate_TSA_ids_action_Base(const CCreate_TSA_ids_action_Base&);
    CCreate_TSA_ids_action_Base& operator=(const CCreate_TSA_ids_action_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TSrc > m_Src;
    string m_Suffix;
    CRef< TId_text_portion > m_Id_text_portion;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCreate_TSA_ids_action_Base::IsSetSrc(void) const
{
    return m_Src.NotEmpty();
}

inline
bool CCreate_TSA_ids_action_Base::CanGetSrc(void) const
{
    return true;
}

inline
const CCreate_TSA_ids_action_Base::TSrc& CCreate_TSA_ids_action_Base::GetSrc(void) const
{
    if ( !m_Src ) {
        const_cast<CCreate_TSA_ids_action_Base*>(this)->ResetSrc();
    }
    return (*m_Src);
}

inline
CCreate_TSA_ids_action_Base::TSrc& CCreate_TSA_ids_action_Base::SetSrc(void)
{
    if ( !m_Src ) {
        ResetSrc();
    }
    return (*m_Src);
}

inline
bool CCreate_TSA_ids_action_Base::IsSetSuffix(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCreate_TSA_ids_action_Base::CanGetSuffix(void) const
{
    return IsSetSuffix();
}

inline
const CCreate_TSA_ids_action_Base::TSuffix& CCreate_TSA_ids_action_Base::GetSuffix(void) const
{
    if (!CanGetSuffix()) {
        ThrowUnassigned(1);
    }
    return m_Suffix;
}

inline
void CCreate_TSA_ids_action_Base::SetSuffix(const CCreate_TSA_ids_action_Base::TSuffix& value)
{
    m_Suffix = value;
    m_set_State[0] |= 0xc;
}

inline
void CCreate_TSA_ids_action_Base::SetSuffix(CCreate_TSA_ids_action_Base::TSuffix&& value)
{
    m_Suffix = std::forward<CCreate_TSA_ids_action_Base::TSuffix>(value);
    m_set_State[0] |= 0xc;
}

inline
CCreate_TSA_ids_action_Base::TSuffix& CCreate_TSA_ids_action_Base::SetSuffix(void)
{
#ifdef _DEBUG
    if (!IsSetSuffix()) {
        m_Suffix = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Suffix;
}

inline
bool CCreate_TSA_ids_action_Base::IsSetId_text_portion(void) const
{
    return m_Id_text_portion.NotEmpty();
}

inline
bool CCreate_TSA_ids_action_Base::CanGetId_text_portion(void) const
{
    return IsSetId_text_portion();
}

inline
const CCreate_TSA_ids_action_Base::TId_text_portion& CCreate_TSA_ids_action_Base::GetId_text_portion(void) const
{
    if (!CanGetId_text_portion()) {
        ThrowUnassigned(2);
    }
    return (*m_Id_text_portion);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_CREATE_TSA_IDS_ACTION_BASE_HPP
