/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Location_choice_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_LOCATION_CHOICE_BASE_HPP
#define OBJECTS_MACRO_LOCATION_CHOICE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CLocation_interval;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CLocation_choice_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CLocation_choice_Base(void);
    // destructor
    virtual ~CLocation_choice_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,     ///< No variant selected
        e_Interval,
        e_Whole_sequence,
        e_Point
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 4 ///< == e_Point+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CLocation_interval TInterval;
    typedef int TPoint;

    // getters
    // setters

    // typedef CLocation_interval TInterval
    bool IsInterval(void) const;
    const TInterval& GetInterval(void) const;
    TInterval& SetInterval(void);
    void SetInterval(TInterval& value);


    bool IsWhole_sequence(void) const;
    void SetWhole_sequence(void);

    // typedef int TPoint
    bool IsPoint(void) const;
    TPoint GetPoint(void) const;
    TPoint& SetPoint(void);
    void SetPoint(TPoint value);


private:
    // copy constructor and assignment operator
    CLocation_choice_Base(const CLocation_choice_Base& );
    CLocation_choice_Base& operator=(const CLocation_choice_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TPoint m_Point;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CLocation_choice_Base::E_Choice CLocation_choice_Base::Which(void) const
{
    return m_choice;
}

inline
void CLocation_choice_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CLocation_choice_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CLocation_choice_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CLocation_choice_Base::IsInterval(void) const
{
    return m_choice == e_Interval;
}

inline
bool CLocation_choice_Base::IsWhole_sequence(void) const
{
    return m_choice == e_Whole_sequence;
}

inline
void CLocation_choice_Base::SetWhole_sequence(void)
{
    Select(e_Whole_sequence, NCBI_NS_NCBI::eDoNotResetVariant);
}

inline
bool CLocation_choice_Base::IsPoint(void) const
{
    return m_choice == e_Point;
}

inline
CLocation_choice_Base::TPoint CLocation_choice_Base::GetPoint(void) const
{
    CheckSelected(e_Point);
    return m_Point;
}

inline
CLocation_choice_Base::TPoint& CLocation_choice_Base::SetPoint(void)
{
    Select(e_Point, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Point;
}

inline
void CLocation_choice_Base::SetPoint(CLocation_choice_Base::TPoint value)
{
    Select(e_Point, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Point = value;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_LOCATION_CHOICE_BASE_HPP
