/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Molinfo_block_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_MOLINFO_BLOCK_BASE_HPP
#define OBJECTS_MACRO_MOLINFO_BLOCK_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CConstraint_choice_set;
class CMolinfo_field_list;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CMolinfo_block_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMolinfo_block_Base(void);
    // destructor
    virtual ~CMolinfo_block_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CMolinfo_field_list TTo_list;
    typedef CMolinfo_field_list TFrom_list;
    typedef CConstraint_choice_set TConstraint;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_to_list,
        e_from_list,
        e_constraint
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CMolinfo_field_list TTo_list
    ///  Check whether the To_list data member has been assigned a value.
    bool IsSetTo_list(void) const;
    /// Check whether it is safe or not to call GetTo_list method.
    bool CanGetTo_list(void) const;
    void ResetTo_list(void);
    const TTo_list& GetTo_list(void) const;
    void SetTo_list(TTo_list& value);
    TTo_list& SetTo_list(void);

    /// optional
    /// typedef CMolinfo_field_list TFrom_list
    ///  Check whether the From_list data member has been assigned a value.
    bool IsSetFrom_list(void) const;
    /// Check whether it is safe or not to call GetFrom_list method.
    bool CanGetFrom_list(void) const;
    void ResetFrom_list(void);
    const TFrom_list& GetFrom_list(void) const;
    void SetFrom_list(TFrom_list& value);
    TFrom_list& SetFrom_list(void);

    /// optional
    /// typedef CConstraint_choice_set TConstraint
    ///  Check whether the Constraint data member has been assigned a value.
    bool IsSetConstraint(void) const;
    /// Check whether it is safe or not to call GetConstraint method.
    bool CanGetConstraint(void) const;
    void ResetConstraint(void);
    const TConstraint& GetConstraint(void) const;
    void SetConstraint(TConstraint& value);
    TConstraint& SetConstraint(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMolinfo_block_Base(const CMolinfo_block_Base&);
    CMolinfo_block_Base& operator=(const CMolinfo_block_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TTo_list > m_To_list;
    CRef< TFrom_list > m_From_list;
    CRef< TConstraint > m_Constraint;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMolinfo_block_Base::IsSetTo_list(void) const
{
    return m_To_list.NotEmpty();
}

inline
bool CMolinfo_block_Base::CanGetTo_list(void) const
{
    return true;
}

inline
const CMolinfo_block_Base::TTo_list& CMolinfo_block_Base::GetTo_list(void) const
{
    if ( !m_To_list ) {
        const_cast<CMolinfo_block_Base*>(this)->ResetTo_list();
    }
    return (*m_To_list);
}

inline
CMolinfo_block_Base::TTo_list& CMolinfo_block_Base::SetTo_list(void)
{
    if ( !m_To_list ) {
        ResetTo_list();
    }
    return (*m_To_list);
}

inline
bool CMolinfo_block_Base::IsSetFrom_list(void) const
{
    return m_From_list.NotEmpty();
}

inline
bool CMolinfo_block_Base::CanGetFrom_list(void) const
{
    return IsSetFrom_list();
}

inline
const CMolinfo_block_Base::TFrom_list& CMolinfo_block_Base::GetFrom_list(void) const
{
    if (!CanGetFrom_list()) {
        ThrowUnassigned(1);
    }
    return (*m_From_list);
}

inline
bool CMolinfo_block_Base::IsSetConstraint(void) const
{
    return m_Constraint.NotEmpty();
}

inline
bool CMolinfo_block_Base::CanGetConstraint(void) const
{
    return IsSetConstraint();
}

inline
const CMolinfo_block_Base::TConstraint& CMolinfo_block_Base::GetConstraint(void) const
{
    if (!CanGetConstraint()) {
        ThrowUnassigned(2);
    }
    return (*m_Constraint);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_MOLINFO_BLOCK_BASE_HPP
