/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Source_qual_text_val_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_SOURCE_QUAL_TEXT_VAL_BASE_HPP
#define OBJECTS_MACRO_SOURCE_QUAL_TEXT_VAL_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/macro/Source_qual.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CSource_qual_text_val_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSource_qual_text_val_Base(void);
    // destructor
    virtual ~CSource_qual_text_val_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef ESource_qual TSrcqual;
    typedef string TVal;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_srcqual,
        e_val
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef ESource_qual TSrcqual
    ///  Check whether the Srcqual data member has been assigned a value.
    bool IsSetSrcqual(void) const;
    /// Check whether it is safe or not to call GetSrcqual method.
    bool CanGetSrcqual(void) const;
    void ResetSrcqual(void);
    TSrcqual GetSrcqual(void) const;
    void SetSrcqual(TSrcqual value);
    TSrcqual& SetSrcqual(void);

    /// mandatory
    /// typedef string TVal
    ///  Check whether the Val data member has been assigned a value.
    bool IsSetVal(void) const;
    /// Check whether it is safe or not to call GetVal method.
    bool CanGetVal(void) const;
    void ResetVal(void);
    const TVal& GetVal(void) const;
    void SetVal(const TVal& value);
    void SetVal(TVal&& value);
    TVal& SetVal(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSource_qual_text_val_Base(const CSource_qual_text_val_Base&);
    CSource_qual_text_val_Base& operator=(const CSource_qual_text_val_Base&);

    // data
    Uint4 m_set_State[1];
    ESource_qual m_Srcqual;
    string m_Val;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CSource_qual_text_val_Base::IsSetSrcqual(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CSource_qual_text_val_Base::CanGetSrcqual(void) const
{
    return IsSetSrcqual();
}

inline
void CSource_qual_text_val_Base::ResetSrcqual(void)
{
    m_Srcqual = (ncbi::objects::ESource_qual)(0);
    m_set_State[0] &= ~0x3;
}

inline
CSource_qual_text_val_Base::TSrcqual CSource_qual_text_val_Base::GetSrcqual(void) const
{
    if (!CanGetSrcqual()) {
        ThrowUnassigned(0);
    }
    return m_Srcqual;
}

inline
void CSource_qual_text_val_Base::SetSrcqual(CSource_qual_text_val_Base::TSrcqual value)
{
    m_Srcqual = value;
    m_set_State[0] |= 0x3;
}

inline
CSource_qual_text_val_Base::TSrcqual& CSource_qual_text_val_Base::SetSrcqual(void)
{
#ifdef _DEBUG
    if (!IsSetSrcqual()) {
        memset(&m_Srcqual,UnassignedByte(),sizeof(m_Srcqual));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Srcqual;
}

inline
bool CSource_qual_text_val_Base::IsSetVal(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CSource_qual_text_val_Base::CanGetVal(void) const
{
    return IsSetVal();
}

inline
const CSource_qual_text_val_Base::TVal& CSource_qual_text_val_Base::GetVal(void) const
{
    if (!CanGetVal()) {
        ThrowUnassigned(1);
    }
    return m_Val;
}

inline
void CSource_qual_text_val_Base::SetVal(const CSource_qual_text_val_Base::TVal& value)
{
    m_Val = value;
    m_set_State[0] |= 0xc;
}

inline
void CSource_qual_text_val_Base::SetVal(CSource_qual_text_val_Base::TVal&& value)
{
    m_Val = std::forward<CSource_qual_text_val_Base::TVal>(value);
    m_set_State[0] |= 0xc;
}

inline
CSource_qual_text_val_Base::TVal& CSource_qual_text_val_Base::SetVal(void)
{
#ifdef _DEBUG
    if (!IsSetVal()) {
        m_Val = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Val;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_SOURCE_QUAL_TEXT_VAL_BASE_HPP
