/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file String_constraint_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_STRING_CONSTRAINT_BASE_HPP
#define OBJECTS_MACRO_STRING_CONSTRAINT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/macro/String_location.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CWord_substitution_set;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CString_constraint_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CString_constraint_Base(void);
    // destructor
    virtual ~CString_constraint_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TMatch_text;
    typedef EString_location TMatch_location;
    typedef bool TCase_sensitive;
    typedef bool TIgnore_space;
    typedef bool TIgnore_punct;
    typedef CWord_substitution_set TIgnore_words;
    typedef bool TWhole_word;
    typedef bool TNot_present;
    typedef bool TIs_all_caps;
    typedef bool TIs_all_lower;
    typedef bool TIs_all_punct;
    typedef bool TIgnore_weasel;
    typedef bool TIs_first_cap;
    typedef bool TIs_first_each_cap;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_match_text,
        e_match_location,
        e_case_sensitive,
        e_ignore_space,
        e_ignore_punct,
        e_ignore_words,
        e_whole_word,
        e_not_present,
        e_is_all_caps,
        e_is_all_lower,
        e_is_all_punct,
        e_ignore_weasel,
        e_is_first_cap,
        e_is_first_each_cap
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 15> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef string TMatch_text
    ///  Check whether the Match_text data member has been assigned a value.
    bool IsSetMatch_text(void) const;
    /// Check whether it is safe or not to call GetMatch_text method.
    bool CanGetMatch_text(void) const;
    void ResetMatch_text(void);
    const TMatch_text& GetMatch_text(void) const;
    void SetMatch_text(const TMatch_text& value);
    void SetMatch_text(TMatch_text&& value);
    TMatch_text& SetMatch_text(void);

    /// optional with default eString_location_contains
    /// typedef EString_location TMatch_location
    ///  Check whether the Match_location data member has been assigned a value.
    bool IsSetMatch_location(void) const;
    /// Check whether it is safe or not to call GetMatch_location method.
    bool CanGetMatch_location(void) const;
    void ResetMatch_location(void);
    void SetDefaultMatch_location(void);
    TMatch_location GetMatch_location(void) const;
    void SetMatch_location(TMatch_location value);
    TMatch_location& SetMatch_location(void);

    /// optional with default false
    /// typedef bool TCase_sensitive
    ///  Check whether the Case_sensitive data member has been assigned a value.
    bool IsSetCase_sensitive(void) const;
    /// Check whether it is safe or not to call GetCase_sensitive method.
    bool CanGetCase_sensitive(void) const;
    void ResetCase_sensitive(void);
    void SetDefaultCase_sensitive(void);
    TCase_sensitive GetCase_sensitive(void) const;
    void SetCase_sensitive(TCase_sensitive value);
    TCase_sensitive& SetCase_sensitive(void);

    /// optional with default false
    /// typedef bool TIgnore_space
    ///  Check whether the Ignore_space data member has been assigned a value.
    bool IsSetIgnore_space(void) const;
    /// Check whether it is safe or not to call GetIgnore_space method.
    bool CanGetIgnore_space(void) const;
    void ResetIgnore_space(void);
    void SetDefaultIgnore_space(void);
    TIgnore_space GetIgnore_space(void) const;
    void SetIgnore_space(TIgnore_space value);
    TIgnore_space& SetIgnore_space(void);

    /// optional with default false
    /// typedef bool TIgnore_punct
    ///  Check whether the Ignore_punct data member has been assigned a value.
    bool IsSetIgnore_punct(void) const;
    /// Check whether it is safe or not to call GetIgnore_punct method.
    bool CanGetIgnore_punct(void) const;
    void ResetIgnore_punct(void);
    void SetDefaultIgnore_punct(void);
    TIgnore_punct GetIgnore_punct(void) const;
    void SetIgnore_punct(TIgnore_punct value);
    TIgnore_punct& SetIgnore_punct(void);

    /// optional
    /// typedef CWord_substitution_set TIgnore_words
    ///  Check whether the Ignore_words data member has been assigned a value.
    bool IsSetIgnore_words(void) const;
    /// Check whether it is safe or not to call GetIgnore_words method.
    bool CanGetIgnore_words(void) const;
    void ResetIgnore_words(void);
    const TIgnore_words& GetIgnore_words(void) const;
    void SetIgnore_words(TIgnore_words& value);
    TIgnore_words& SetIgnore_words(void);

    /// optional with default false
    /// typedef bool TWhole_word
    ///  Check whether the Whole_word data member has been assigned a value.
    bool IsSetWhole_word(void) const;
    /// Check whether it is safe or not to call GetWhole_word method.
    bool CanGetWhole_word(void) const;
    void ResetWhole_word(void);
    void SetDefaultWhole_word(void);
    TWhole_word GetWhole_word(void) const;
    void SetWhole_word(TWhole_word value);
    TWhole_word& SetWhole_word(void);

    /// optional with default false
    /// typedef bool TNot_present
    ///  Check whether the Not_present data member has been assigned a value.
    bool IsSetNot_present(void) const;
    /// Check whether it is safe or not to call GetNot_present method.
    bool CanGetNot_present(void) const;
    void ResetNot_present(void);
    void SetDefaultNot_present(void);
    TNot_present GetNot_present(void) const;
    void SetNot_present(TNot_present value);
    TNot_present& SetNot_present(void);

    /// optional with default false
    /// typedef bool TIs_all_caps
    ///  Check whether the Is_all_caps data member has been assigned a value.
    bool IsSetIs_all_caps(void) const;
    /// Check whether it is safe or not to call GetIs_all_caps method.
    bool CanGetIs_all_caps(void) const;
    void ResetIs_all_caps(void);
    void SetDefaultIs_all_caps(void);
    TIs_all_caps GetIs_all_caps(void) const;
    void SetIs_all_caps(TIs_all_caps value);
    TIs_all_caps& SetIs_all_caps(void);

    /// optional with default false
    /// typedef bool TIs_all_lower
    ///  Check whether the Is_all_lower data member has been assigned a value.
    bool IsSetIs_all_lower(void) const;
    /// Check whether it is safe or not to call GetIs_all_lower method.
    bool CanGetIs_all_lower(void) const;
    void ResetIs_all_lower(void);
    void SetDefaultIs_all_lower(void);
    TIs_all_lower GetIs_all_lower(void) const;
    void SetIs_all_lower(TIs_all_lower value);
    TIs_all_lower& SetIs_all_lower(void);

    /// optional with default false
    /// typedef bool TIs_all_punct
    ///  Check whether the Is_all_punct data member has been assigned a value.
    bool IsSetIs_all_punct(void) const;
    /// Check whether it is safe or not to call GetIs_all_punct method.
    bool CanGetIs_all_punct(void) const;
    void ResetIs_all_punct(void);
    void SetDefaultIs_all_punct(void);
    TIs_all_punct GetIs_all_punct(void) const;
    void SetIs_all_punct(TIs_all_punct value);
    TIs_all_punct& SetIs_all_punct(void);

    /// optional with default false
    /// typedef bool TIgnore_weasel
    ///  Check whether the Ignore_weasel data member has been assigned a value.
    bool IsSetIgnore_weasel(void) const;
    /// Check whether it is safe or not to call GetIgnore_weasel method.
    bool CanGetIgnore_weasel(void) const;
    void ResetIgnore_weasel(void);
    void SetDefaultIgnore_weasel(void);
    TIgnore_weasel GetIgnore_weasel(void) const;
    void SetIgnore_weasel(TIgnore_weasel value);
    TIgnore_weasel& SetIgnore_weasel(void);

    /// optional with default false
    /// typedef bool TIs_first_cap
    ///  Check whether the Is_first_cap data member has been assigned a value.
    bool IsSetIs_first_cap(void) const;
    /// Check whether it is safe or not to call GetIs_first_cap method.
    bool CanGetIs_first_cap(void) const;
    void ResetIs_first_cap(void);
    void SetDefaultIs_first_cap(void);
    TIs_first_cap GetIs_first_cap(void) const;
    void SetIs_first_cap(TIs_first_cap value);
    TIs_first_cap& SetIs_first_cap(void);

    /// optional with default false
    /// typedef bool TIs_first_each_cap
    ///  Check whether the Is_first_each_cap data member has been assigned a value.
    bool IsSetIs_first_each_cap(void) const;
    /// Check whether it is safe or not to call GetIs_first_each_cap method.
    bool CanGetIs_first_each_cap(void) const;
    void ResetIs_first_each_cap(void);
    void SetDefaultIs_first_each_cap(void);
    TIs_first_each_cap GetIs_first_each_cap(void) const;
    void SetIs_first_each_cap(TIs_first_each_cap value);
    TIs_first_each_cap& SetIs_first_each_cap(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CString_constraint_Base(const CString_constraint_Base&);
    CString_constraint_Base& operator=(const CString_constraint_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Match_text;
    EString_location m_Match_location;
    bool m_Case_sensitive;
    bool m_Ignore_space;
    bool m_Ignore_punct;
    CRef< TIgnore_words > m_Ignore_words;
    bool m_Whole_word;
    bool m_Not_present;
    bool m_Is_all_caps;
    bool m_Is_all_lower;
    bool m_Is_all_punct;
    bool m_Ignore_weasel;
    bool m_Is_first_cap;
    bool m_Is_first_each_cap;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CString_constraint_Base::IsSetMatch_text(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CString_constraint_Base::CanGetMatch_text(void) const
{
    return IsSetMatch_text();
}

inline
const CString_constraint_Base::TMatch_text& CString_constraint_Base::GetMatch_text(void) const
{
    if (!CanGetMatch_text()) {
        ThrowUnassigned(0);
    }
    return m_Match_text;
}

inline
void CString_constraint_Base::SetMatch_text(const CString_constraint_Base::TMatch_text& value)
{
    m_Match_text = value;
    m_set_State[0] |= 0x3;
}

inline
void CString_constraint_Base::SetMatch_text(CString_constraint_Base::TMatch_text&& value)
{
    m_Match_text = std::forward<CString_constraint_Base::TMatch_text>(value);
    m_set_State[0] |= 0x3;
}

inline
CString_constraint_Base::TMatch_text& CString_constraint_Base::SetMatch_text(void)
{
#ifdef _DEBUG
    if (!IsSetMatch_text()) {
        m_Match_text = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Match_text;
}

inline
bool CString_constraint_Base::IsSetMatch_location(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CString_constraint_Base::CanGetMatch_location(void) const
{
    return true;
}

inline
void CString_constraint_Base::ResetMatch_location(void)
{
    m_Match_location = eString_location_contains;
    m_set_State[0] &= ~0xc;
}

inline
void CString_constraint_Base::SetDefaultMatch_location(void)
{
    ResetMatch_location();
}

inline
CString_constraint_Base::TMatch_location CString_constraint_Base::GetMatch_location(void) const
{
    return m_Match_location;
}

inline
void CString_constraint_Base::SetMatch_location(CString_constraint_Base::TMatch_location value)
{
    m_Match_location = value;
    m_set_State[0] |= 0xc;
}

inline
CString_constraint_Base::TMatch_location& CString_constraint_Base::SetMatch_location(void)
{
#ifdef _DEBUG
    if (!IsSetMatch_location()) {
        memset(&m_Match_location,UnassignedByte(),sizeof(m_Match_location));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Match_location;
}

inline
bool CString_constraint_Base::IsSetCase_sensitive(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CString_constraint_Base::CanGetCase_sensitive(void) const
{
    return true;
}

inline
void CString_constraint_Base::ResetCase_sensitive(void)
{
    m_Case_sensitive = false;
    m_set_State[0] &= ~0x30;
}

inline
void CString_constraint_Base::SetDefaultCase_sensitive(void)
{
    ResetCase_sensitive();
}

inline
CString_constraint_Base::TCase_sensitive CString_constraint_Base::GetCase_sensitive(void) const
{
    return m_Case_sensitive;
}

inline
void CString_constraint_Base::SetCase_sensitive(CString_constraint_Base::TCase_sensitive value)
{
    m_Case_sensitive = value;
    m_set_State[0] |= 0x30;
}

inline
CString_constraint_Base::TCase_sensitive& CString_constraint_Base::SetCase_sensitive(void)
{
#ifdef _DEBUG
    if (!IsSetCase_sensitive()) {
        memset(&m_Case_sensitive,UnassignedByte(),sizeof(m_Case_sensitive));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Case_sensitive;
}

inline
bool CString_constraint_Base::IsSetIgnore_space(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CString_constraint_Base::CanGetIgnore_space(void) const
{
    return true;
}

inline
void CString_constraint_Base::ResetIgnore_space(void)
{
    m_Ignore_space = false;
    m_set_State[0] &= ~0xc0;
}

inline
void CString_constraint_Base::SetDefaultIgnore_space(void)
{
    ResetIgnore_space();
}

inline
CString_constraint_Base::TIgnore_space CString_constraint_Base::GetIgnore_space(void) const
{
    return m_Ignore_space;
}

inline
void CString_constraint_Base::SetIgnore_space(CString_constraint_Base::TIgnore_space value)
{
    m_Ignore_space = value;
    m_set_State[0] |= 0xc0;
}

inline
CString_constraint_Base::TIgnore_space& CString_constraint_Base::SetIgnore_space(void)
{
#ifdef _DEBUG
    if (!IsSetIgnore_space()) {
        memset(&m_Ignore_space,UnassignedByte(),sizeof(m_Ignore_space));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Ignore_space;
}

inline
bool CString_constraint_Base::IsSetIgnore_punct(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CString_constraint_Base::CanGetIgnore_punct(void) const
{
    return true;
}

inline
void CString_constraint_Base::ResetIgnore_punct(void)
{
    m_Ignore_punct = false;
    m_set_State[0] &= ~0x300;
}

inline
void CString_constraint_Base::SetDefaultIgnore_punct(void)
{
    ResetIgnore_punct();
}

inline
CString_constraint_Base::TIgnore_punct CString_constraint_Base::GetIgnore_punct(void) const
{
    return m_Ignore_punct;
}

inline
void CString_constraint_Base::SetIgnore_punct(CString_constraint_Base::TIgnore_punct value)
{
    m_Ignore_punct = value;
    m_set_State[0] |= 0x300;
}

inline
CString_constraint_Base::TIgnore_punct& CString_constraint_Base::SetIgnore_punct(void)
{
#ifdef _DEBUG
    if (!IsSetIgnore_punct()) {
        memset(&m_Ignore_punct,UnassignedByte(),sizeof(m_Ignore_punct));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Ignore_punct;
}

inline
bool CString_constraint_Base::IsSetIgnore_words(void) const
{
    return m_Ignore_words.NotEmpty();
}

inline
bool CString_constraint_Base::CanGetIgnore_words(void) const
{
    return IsSetIgnore_words();
}

inline
const CString_constraint_Base::TIgnore_words& CString_constraint_Base::GetIgnore_words(void) const
{
    if (!CanGetIgnore_words()) {
        ThrowUnassigned(5);
    }
    return (*m_Ignore_words);
}

inline
bool CString_constraint_Base::IsSetWhole_word(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CString_constraint_Base::CanGetWhole_word(void) const
{
    return true;
}

inline
void CString_constraint_Base::ResetWhole_word(void)
{
    m_Whole_word = false;
    m_set_State[0] &= ~0x3000;
}

inline
void CString_constraint_Base::SetDefaultWhole_word(void)
{
    ResetWhole_word();
}

inline
CString_constraint_Base::TWhole_word CString_constraint_Base::GetWhole_word(void) const
{
    return m_Whole_word;
}

inline
void CString_constraint_Base::SetWhole_word(CString_constraint_Base::TWhole_word value)
{
    m_Whole_word = value;
    m_set_State[0] |= 0x3000;
}

inline
CString_constraint_Base::TWhole_word& CString_constraint_Base::SetWhole_word(void)
{
#ifdef _DEBUG
    if (!IsSetWhole_word()) {
        memset(&m_Whole_word,UnassignedByte(),sizeof(m_Whole_word));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Whole_word;
}

inline
bool CString_constraint_Base::IsSetNot_present(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CString_constraint_Base::CanGetNot_present(void) const
{
    return true;
}

inline
void CString_constraint_Base::ResetNot_present(void)
{
    m_Not_present = false;
    m_set_State[0] &= ~0xc000;
}

inline
void CString_constraint_Base::SetDefaultNot_present(void)
{
    ResetNot_present();
}

inline
CString_constraint_Base::TNot_present CString_constraint_Base::GetNot_present(void) const
{
    return m_Not_present;
}

inline
void CString_constraint_Base::SetNot_present(CString_constraint_Base::TNot_present value)
{
    m_Not_present = value;
    m_set_State[0] |= 0xc000;
}

inline
CString_constraint_Base::TNot_present& CString_constraint_Base::SetNot_present(void)
{
#ifdef _DEBUG
    if (!IsSetNot_present()) {
        memset(&m_Not_present,UnassignedByte(),sizeof(m_Not_present));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Not_present;
}

inline
bool CString_constraint_Base::IsSetIs_all_caps(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CString_constraint_Base::CanGetIs_all_caps(void) const
{
    return true;
}

inline
void CString_constraint_Base::ResetIs_all_caps(void)
{
    m_Is_all_caps = false;
    m_set_State[0] &= ~0x30000;
}

inline
void CString_constraint_Base::SetDefaultIs_all_caps(void)
{
    ResetIs_all_caps();
}

inline
CString_constraint_Base::TIs_all_caps CString_constraint_Base::GetIs_all_caps(void) const
{
    return m_Is_all_caps;
}

inline
void CString_constraint_Base::SetIs_all_caps(CString_constraint_Base::TIs_all_caps value)
{
    m_Is_all_caps = value;
    m_set_State[0] |= 0x30000;
}

inline
CString_constraint_Base::TIs_all_caps& CString_constraint_Base::SetIs_all_caps(void)
{
#ifdef _DEBUG
    if (!IsSetIs_all_caps()) {
        memset(&m_Is_all_caps,UnassignedByte(),sizeof(m_Is_all_caps));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Is_all_caps;
}

inline
bool CString_constraint_Base::IsSetIs_all_lower(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CString_constraint_Base::CanGetIs_all_lower(void) const
{
    return true;
}

inline
void CString_constraint_Base::ResetIs_all_lower(void)
{
    m_Is_all_lower = false;
    m_set_State[0] &= ~0xc0000;
}

inline
void CString_constraint_Base::SetDefaultIs_all_lower(void)
{
    ResetIs_all_lower();
}

inline
CString_constraint_Base::TIs_all_lower CString_constraint_Base::GetIs_all_lower(void) const
{
    return m_Is_all_lower;
}

inline
void CString_constraint_Base::SetIs_all_lower(CString_constraint_Base::TIs_all_lower value)
{
    m_Is_all_lower = value;
    m_set_State[0] |= 0xc0000;
}

inline
CString_constraint_Base::TIs_all_lower& CString_constraint_Base::SetIs_all_lower(void)
{
#ifdef _DEBUG
    if (!IsSetIs_all_lower()) {
        memset(&m_Is_all_lower,UnassignedByte(),sizeof(m_Is_all_lower));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Is_all_lower;
}

inline
bool CString_constraint_Base::IsSetIs_all_punct(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CString_constraint_Base::CanGetIs_all_punct(void) const
{
    return true;
}

inline
void CString_constraint_Base::ResetIs_all_punct(void)
{
    m_Is_all_punct = false;
    m_set_State[0] &= ~0x300000;
}

inline
void CString_constraint_Base::SetDefaultIs_all_punct(void)
{
    ResetIs_all_punct();
}

inline
CString_constraint_Base::TIs_all_punct CString_constraint_Base::GetIs_all_punct(void) const
{
    return m_Is_all_punct;
}

inline
void CString_constraint_Base::SetIs_all_punct(CString_constraint_Base::TIs_all_punct value)
{
    m_Is_all_punct = value;
    m_set_State[0] |= 0x300000;
}

inline
CString_constraint_Base::TIs_all_punct& CString_constraint_Base::SetIs_all_punct(void)
{
#ifdef _DEBUG
    if (!IsSetIs_all_punct()) {
        memset(&m_Is_all_punct,UnassignedByte(),sizeof(m_Is_all_punct));
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_Is_all_punct;
}

inline
bool CString_constraint_Base::IsSetIgnore_weasel(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CString_constraint_Base::CanGetIgnore_weasel(void) const
{
    return true;
}

inline
void CString_constraint_Base::ResetIgnore_weasel(void)
{
    m_Ignore_weasel = false;
    m_set_State[0] &= ~0xc00000;
}

inline
void CString_constraint_Base::SetDefaultIgnore_weasel(void)
{
    ResetIgnore_weasel();
}

inline
CString_constraint_Base::TIgnore_weasel CString_constraint_Base::GetIgnore_weasel(void) const
{
    return m_Ignore_weasel;
}

inline
void CString_constraint_Base::SetIgnore_weasel(CString_constraint_Base::TIgnore_weasel value)
{
    m_Ignore_weasel = value;
    m_set_State[0] |= 0xc00000;
}

inline
CString_constraint_Base::TIgnore_weasel& CString_constraint_Base::SetIgnore_weasel(void)
{
#ifdef _DEBUG
    if (!IsSetIgnore_weasel()) {
        memset(&m_Ignore_weasel,UnassignedByte(),sizeof(m_Ignore_weasel));
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_Ignore_weasel;
}

inline
bool CString_constraint_Base::IsSetIs_first_cap(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CString_constraint_Base::CanGetIs_first_cap(void) const
{
    return true;
}

inline
void CString_constraint_Base::ResetIs_first_cap(void)
{
    m_Is_first_cap = false;
    m_set_State[0] &= ~0x3000000;
}

inline
void CString_constraint_Base::SetDefaultIs_first_cap(void)
{
    ResetIs_first_cap();
}

inline
CString_constraint_Base::TIs_first_cap CString_constraint_Base::GetIs_first_cap(void) const
{
    return m_Is_first_cap;
}

inline
void CString_constraint_Base::SetIs_first_cap(CString_constraint_Base::TIs_first_cap value)
{
    m_Is_first_cap = value;
    m_set_State[0] |= 0x3000000;
}

inline
CString_constraint_Base::TIs_first_cap& CString_constraint_Base::SetIs_first_cap(void)
{
#ifdef _DEBUG
    if (!IsSetIs_first_cap()) {
        memset(&m_Is_first_cap,UnassignedByte(),sizeof(m_Is_first_cap));
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_Is_first_cap;
}

inline
bool CString_constraint_Base::IsSetIs_first_each_cap(void) const
{
    return ((m_set_State[0] & 0xc000000) != 0);
}

inline
bool CString_constraint_Base::CanGetIs_first_each_cap(void) const
{
    return true;
}

inline
void CString_constraint_Base::ResetIs_first_each_cap(void)
{
    m_Is_first_each_cap = false;
    m_set_State[0] &= ~0xc000000;
}

inline
void CString_constraint_Base::SetDefaultIs_first_each_cap(void)
{
    ResetIs_first_each_cap();
}

inline
CString_constraint_Base::TIs_first_each_cap CString_constraint_Base::GetIs_first_each_cap(void) const
{
    return m_Is_first_each_cap;
}

inline
void CString_constraint_Base::SetIs_first_each_cap(CString_constraint_Base::TIs_first_each_cap value)
{
    m_Is_first_each_cap = value;
    m_set_State[0] |= 0xc000000;
}

inline
CString_constraint_Base::TIs_first_each_cap& CString_constraint_Base::SetIs_first_each_cap(void)
{
#ifdef _DEBUG
    if (!IsSetIs_first_each_cap()) {
        memset(&m_Is_first_each_cap,UnassignedByte(),sizeof(m_Is_first_each_cap));
    }
#endif
    m_set_State[0] |= 0x4000000;
    return m_Is_first_each_cap;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_STRING_CONSTRAINT_BASE_HPP
