/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Text_portion_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_TEXT_PORTION_BASE_HPP
#define OBJECTS_MACRO_TEXT_PORTION_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CText_marker;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CText_portion_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CText_portion_Base(void);
    // destructor
    virtual ~CText_portion_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CText_marker TLeft_marker;
    typedef bool TInclude_left;
    typedef CText_marker TRight_marker;
    typedef bool TInclude_right;
    typedef bool TInside;
    typedef bool TCase_sensitive;
    typedef bool TWhole_word;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_left_marker,
        e_include_left,
        e_right_marker,
        e_include_right,
        e_inside,
        e_case_sensitive,
        e_whole_word
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef CText_marker TLeft_marker
    ///  Check whether the Left_marker data member has been assigned a value.
    bool IsSetLeft_marker(void) const;
    /// Check whether it is safe or not to call GetLeft_marker method.
    bool CanGetLeft_marker(void) const;
    void ResetLeft_marker(void);
    const TLeft_marker& GetLeft_marker(void) const;
    void SetLeft_marker(TLeft_marker& value);
    TLeft_marker& SetLeft_marker(void);

    /// mandatory
    /// typedef bool TInclude_left
    ///  Check whether the Include_left data member has been assigned a value.
    bool IsSetInclude_left(void) const;
    /// Check whether it is safe or not to call GetInclude_left method.
    bool CanGetInclude_left(void) const;
    void ResetInclude_left(void);
    TInclude_left GetInclude_left(void) const;
    void SetInclude_left(TInclude_left value);
    TInclude_left& SetInclude_left(void);

    /// optional
    /// typedef CText_marker TRight_marker
    ///  Check whether the Right_marker data member has been assigned a value.
    bool IsSetRight_marker(void) const;
    /// Check whether it is safe or not to call GetRight_marker method.
    bool CanGetRight_marker(void) const;
    void ResetRight_marker(void);
    const TRight_marker& GetRight_marker(void) const;
    void SetRight_marker(TRight_marker& value);
    TRight_marker& SetRight_marker(void);

    /// mandatory
    /// typedef bool TInclude_right
    ///  Check whether the Include_right data member has been assigned a value.
    bool IsSetInclude_right(void) const;
    /// Check whether it is safe or not to call GetInclude_right method.
    bool CanGetInclude_right(void) const;
    void ResetInclude_right(void);
    TInclude_right GetInclude_right(void) const;
    void SetInclude_right(TInclude_right value);
    TInclude_right& SetInclude_right(void);

    /// mandatory
    /// typedef bool TInside
    ///  Check whether the Inside data member has been assigned a value.
    bool IsSetInside(void) const;
    /// Check whether it is safe or not to call GetInside method.
    bool CanGetInside(void) const;
    void ResetInside(void);
    TInside GetInside(void) const;
    void SetInside(TInside value);
    TInside& SetInside(void);

    /// optional with default false
    /// typedef bool TCase_sensitive
    ///  Check whether the Case_sensitive data member has been assigned a value.
    bool IsSetCase_sensitive(void) const;
    /// Check whether it is safe or not to call GetCase_sensitive method.
    bool CanGetCase_sensitive(void) const;
    void ResetCase_sensitive(void);
    void SetDefaultCase_sensitive(void);
    TCase_sensitive GetCase_sensitive(void) const;
    void SetCase_sensitive(TCase_sensitive value);
    TCase_sensitive& SetCase_sensitive(void);

    /// optional with default false
    /// typedef bool TWhole_word
    ///  Check whether the Whole_word data member has been assigned a value.
    bool IsSetWhole_word(void) const;
    /// Check whether it is safe or not to call GetWhole_word method.
    bool CanGetWhole_word(void) const;
    void ResetWhole_word(void);
    void SetDefaultWhole_word(void);
    TWhole_word GetWhole_word(void) const;
    void SetWhole_word(TWhole_word value);
    TWhole_word& SetWhole_word(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CText_portion_Base(const CText_portion_Base&);
    CText_portion_Base& operator=(const CText_portion_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TLeft_marker > m_Left_marker;
    bool m_Include_left;
    CRef< TRight_marker > m_Right_marker;
    bool m_Include_right;
    bool m_Inside;
    bool m_Case_sensitive;
    bool m_Whole_word;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CText_portion_Base::IsSetLeft_marker(void) const
{
    return m_Left_marker.NotEmpty();
}

inline
bool CText_portion_Base::CanGetLeft_marker(void) const
{
    return IsSetLeft_marker();
}

inline
const CText_portion_Base::TLeft_marker& CText_portion_Base::GetLeft_marker(void) const
{
    if (!CanGetLeft_marker()) {
        ThrowUnassigned(0);
    }
    return (*m_Left_marker);
}

inline
bool CText_portion_Base::IsSetInclude_left(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CText_portion_Base::CanGetInclude_left(void) const
{
    return IsSetInclude_left();
}

inline
void CText_portion_Base::ResetInclude_left(void)
{
    m_Include_left = 0;
    m_set_State[0] &= ~0xc;
}

inline
CText_portion_Base::TInclude_left CText_portion_Base::GetInclude_left(void) const
{
    if (!CanGetInclude_left()) {
        ThrowUnassigned(1);
    }
    return m_Include_left;
}

inline
void CText_portion_Base::SetInclude_left(CText_portion_Base::TInclude_left value)
{
    m_Include_left = value;
    m_set_State[0] |= 0xc;
}

inline
CText_portion_Base::TInclude_left& CText_portion_Base::SetInclude_left(void)
{
#ifdef _DEBUG
    if (!IsSetInclude_left()) {
        memset(&m_Include_left,UnassignedByte(),sizeof(m_Include_left));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Include_left;
}

inline
bool CText_portion_Base::IsSetRight_marker(void) const
{
    return m_Right_marker.NotEmpty();
}

inline
bool CText_portion_Base::CanGetRight_marker(void) const
{
    return IsSetRight_marker();
}

inline
const CText_portion_Base::TRight_marker& CText_portion_Base::GetRight_marker(void) const
{
    if (!CanGetRight_marker()) {
        ThrowUnassigned(2);
    }
    return (*m_Right_marker);
}

inline
bool CText_portion_Base::IsSetInclude_right(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CText_portion_Base::CanGetInclude_right(void) const
{
    return IsSetInclude_right();
}

inline
void CText_portion_Base::ResetInclude_right(void)
{
    m_Include_right = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CText_portion_Base::TInclude_right CText_portion_Base::GetInclude_right(void) const
{
    if (!CanGetInclude_right()) {
        ThrowUnassigned(3);
    }
    return m_Include_right;
}

inline
void CText_portion_Base::SetInclude_right(CText_portion_Base::TInclude_right value)
{
    m_Include_right = value;
    m_set_State[0] |= 0xc0;
}

inline
CText_portion_Base::TInclude_right& CText_portion_Base::SetInclude_right(void)
{
#ifdef _DEBUG
    if (!IsSetInclude_right()) {
        memset(&m_Include_right,UnassignedByte(),sizeof(m_Include_right));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Include_right;
}

inline
bool CText_portion_Base::IsSetInside(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CText_portion_Base::CanGetInside(void) const
{
    return IsSetInside();
}

inline
void CText_portion_Base::ResetInside(void)
{
    m_Inside = 0;
    m_set_State[0] &= ~0x300;
}

inline
CText_portion_Base::TInside CText_portion_Base::GetInside(void) const
{
    if (!CanGetInside()) {
        ThrowUnassigned(4);
    }
    return m_Inside;
}

inline
void CText_portion_Base::SetInside(CText_portion_Base::TInside value)
{
    m_Inside = value;
    m_set_State[0] |= 0x300;
}

inline
CText_portion_Base::TInside& CText_portion_Base::SetInside(void)
{
#ifdef _DEBUG
    if (!IsSetInside()) {
        memset(&m_Inside,UnassignedByte(),sizeof(m_Inside));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Inside;
}

inline
bool CText_portion_Base::IsSetCase_sensitive(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CText_portion_Base::CanGetCase_sensitive(void) const
{
    return true;
}

inline
void CText_portion_Base::ResetCase_sensitive(void)
{
    m_Case_sensitive = false;
    m_set_State[0] &= ~0xc00;
}

inline
void CText_portion_Base::SetDefaultCase_sensitive(void)
{
    ResetCase_sensitive();
}

inline
CText_portion_Base::TCase_sensitive CText_portion_Base::GetCase_sensitive(void) const
{
    return m_Case_sensitive;
}

inline
void CText_portion_Base::SetCase_sensitive(CText_portion_Base::TCase_sensitive value)
{
    m_Case_sensitive = value;
    m_set_State[0] |= 0xc00;
}

inline
CText_portion_Base::TCase_sensitive& CText_portion_Base::SetCase_sensitive(void)
{
#ifdef _DEBUG
    if (!IsSetCase_sensitive()) {
        memset(&m_Case_sensitive,UnassignedByte(),sizeof(m_Case_sensitive));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Case_sensitive;
}

inline
bool CText_portion_Base::IsSetWhole_word(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CText_portion_Base::CanGetWhole_word(void) const
{
    return true;
}

inline
void CText_portion_Base::ResetWhole_word(void)
{
    m_Whole_word = false;
    m_set_State[0] &= ~0x3000;
}

inline
void CText_portion_Base::SetDefaultWhole_word(void)
{
    ResetWhole_word();
}

inline
CText_portion_Base::TWhole_word CText_portion_Base::GetWhole_word(void) const
{
    return m_Whole_word;
}

inline
void CText_portion_Base::SetWhole_word(CText_portion_Base::TWhole_word value)
{
    m_Whole_word = value;
    m_set_State[0] |= 0x3000;
}

inline
CText_portion_Base::TWhole_word& CText_portion_Base::SetWhole_word(void)
{
#ifdef _DEBUG
    if (!IsSetWhole_word()) {
        memset(&m_Whole_word,UnassignedByte(),sizeof(m_Whole_word));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Whole_word;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_TEXT_PORTION_BASE_HPP
