/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Medline_mesh_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'medline.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MEDLINE_MEDLINE_MESH_BASE_HPP
#define OBJECTS_MEDLINE_MEDLINE_MESH_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CMedline_qual;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MEDLINE_EXPORT CMedline_mesh_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMedline_mesh_Base(void);
    // destructor
    virtual ~CMedline_mesh_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef bool TMp;
    typedef string TTerm;
    typedef list< CRef< CMedline_qual > > TQual;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_mp,
        e_term,
        e_qual
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// TRUE if main point (*)
    /// optional with default false
    /// typedef bool TMp
    ///  Check whether the Mp data member has been assigned a value.
    bool IsSetMp(void) const;
    /// Check whether it is safe or not to call GetMp method.
    bool CanGetMp(void) const;
    void ResetMp(void);
    void SetDefaultMp(void);
    TMp GetMp(void) const;
    void SetMp(TMp value);
    TMp& SetMp(void);

    /// the MeSH term
    /// mandatory
    /// typedef string TTerm
    ///  Check whether the Term data member has been assigned a value.
    bool IsSetTerm(void) const;
    /// Check whether it is safe or not to call GetTerm method.
    bool CanGetTerm(void) const;
    void ResetTerm(void);
    const TTerm& GetTerm(void) const;
    void SetTerm(const TTerm& value);
    void SetTerm(TTerm&& value);
    TTerm& SetTerm(void);

    /// qualifiers
    /// optional
    /// typedef list< CRef< CMedline_qual > > TQual
    ///  Check whether the Qual data member has been assigned a value.
    bool IsSetQual(void) const;
    /// Check whether it is safe or not to call GetQual method.
    bool CanGetQual(void) const;
    void ResetQual(void);
    const TQual& GetQual(void) const;
    TQual& SetQual(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMedline_mesh_Base(const CMedline_mesh_Base&);
    CMedline_mesh_Base& operator=(const CMedline_mesh_Base&);

    // data
    Uint4 m_set_State[1];
    bool m_Mp;
    string m_Term;
    list< CRef< CMedline_qual > > m_Qual;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMedline_mesh_Base::IsSetMp(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMedline_mesh_Base::CanGetMp(void) const
{
    return true;
}

inline
void CMedline_mesh_Base::ResetMp(void)
{
    m_Mp = false;
    m_set_State[0] &= ~0x3;
}

inline
void CMedline_mesh_Base::SetDefaultMp(void)
{
    ResetMp();
}

inline
CMedline_mesh_Base::TMp CMedline_mesh_Base::GetMp(void) const
{
    return m_Mp;
}

inline
void CMedline_mesh_Base::SetMp(CMedline_mesh_Base::TMp value)
{
    m_Mp = value;
    m_set_State[0] |= 0x3;
}

inline
CMedline_mesh_Base::TMp& CMedline_mesh_Base::SetMp(void)
{
#ifdef _DEBUG
    if (!IsSetMp()) {
        memset(&m_Mp,UnassignedByte(),sizeof(m_Mp));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Mp;
}

inline
bool CMedline_mesh_Base::IsSetTerm(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMedline_mesh_Base::CanGetTerm(void) const
{
    return IsSetTerm();
}

inline
const CMedline_mesh_Base::TTerm& CMedline_mesh_Base::GetTerm(void) const
{
    if (!CanGetTerm()) {
        ThrowUnassigned(1);
    }
    return m_Term;
}

inline
void CMedline_mesh_Base::SetTerm(const CMedline_mesh_Base::TTerm& value)
{
    m_Term = value;
    m_set_State[0] |= 0xc;
}

inline
void CMedline_mesh_Base::SetTerm(CMedline_mesh_Base::TTerm&& value)
{
    m_Term = std::forward<CMedline_mesh_Base::TTerm>(value);
    m_set_State[0] |= 0xc;
}

inline
CMedline_mesh_Base::TTerm& CMedline_mesh_Base::SetTerm(void)
{
#ifdef _DEBUG
    if (!IsSetTerm()) {
        m_Term = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Term;
}

inline
bool CMedline_mesh_Base::IsSetQual(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMedline_mesh_Base::CanGetQual(void) const
{
    return true;
}

inline
const CMedline_mesh_Base::TQual& CMedline_mesh_Base::GetQual(void) const
{
    return m_Qual;
}

inline
CMedline_mesh_Base::TQual& CMedline_mesh_Base::SetQual(void)
{
    m_set_State[0] |= 0x10;
    return m_Qual;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MEDLINE_MEDLINE_MESH_BASE_HPP
