/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Biostruc_graph_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb1.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB1_BIOSTRUC_GRAPH_BASE_HPP
#define OBJECTS_MMDB1_BIOSTRUC_GRAPH_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBiomol_descr;
class CInter_residue_bond;
class CMolecule_graph;
class CResidue_graph;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// A biostruc graph contains the complete chemical graph of the biomolecular 
/// assembly.  The assembly graph is defined hierarchically, in terms of 
/// subgraphs graphs of component molecules.  For PDB-derived biostrucs,
/// the molecules forming the assembly are the individual biopolymer chains and 
/// any non-polymer or "heterogen" groups which are present. 
/// The PDB-derived  "compound name" field appears as the name within the
/// biostruc-graph description.  PDB "class" and "source" fields appear as 
/// explicit attributes.  PDB-derived structures are assigned an assembly type 
/// of "other" unless they have been further classified as the "physiological
/// form" or "crystallographic cell" contents.  If they have, the source of the 
/// type classification appears as a citation within the  assembly description. 
/// Note that the biostruc-graph also includes as literals the subgraphs of 
/// any nonstandard residues present within it. For PDB-derived biostrucs these 
/// subgraphs are constructed automatically, with validation as described below.
class NCBI_MMDB1_EXPORT CBiostruc_graph_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBiostruc_graph_Base(void);
    // destructor
    virtual ~CBiostruc_graph_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< CRef< CBiomol_descr > > TDescr;
    typedef list< CRef< CMolecule_graph > > TMolecule_graphs;
    typedef list< CRef< CInter_residue_bond > > TInter_molecule_bonds;
    typedef list< CRef< CResidue_graph > > TResidue_graphs;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_descr,
        e_molecule_graphs,
        e_inter_molecule_bonds,
        e_residue_graphs
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef list< CRef< CBiomol_descr > > TDescr
    ///  Check whether the Descr data member has been assigned a value.
    bool IsSetDescr(void) const;
    /// Check whether it is safe or not to call GetDescr method.
    bool CanGetDescr(void) const;
    void ResetDescr(void);
    const TDescr& GetDescr(void) const;
    TDescr& SetDescr(void);

    /// mandatory
    /// typedef list< CRef< CMolecule_graph > > TMolecule_graphs
    ///  Check whether the Molecule_graphs data member has been assigned a value.
    bool IsSetMolecule_graphs(void) const;
    /// Check whether it is safe or not to call GetMolecule_graphs method.
    bool CanGetMolecule_graphs(void) const;
    void ResetMolecule_graphs(void);
    const TMolecule_graphs& GetMolecule_graphs(void) const;
    TMolecule_graphs& SetMolecule_graphs(void);

    /// optional
    /// typedef list< CRef< CInter_residue_bond > > TInter_molecule_bonds
    ///  Check whether the Inter_molecule_bonds data member has been assigned a value.
    bool IsSetInter_molecule_bonds(void) const;
    /// Check whether it is safe or not to call GetInter_molecule_bonds method.
    bool CanGetInter_molecule_bonds(void) const;
    void ResetInter_molecule_bonds(void);
    const TInter_molecule_bonds& GetInter_molecule_bonds(void) const;
    TInter_molecule_bonds& SetInter_molecule_bonds(void);

    /// optional
    /// typedef list< CRef< CResidue_graph > > TResidue_graphs
    ///  Check whether the Residue_graphs data member has been assigned a value.
    bool IsSetResidue_graphs(void) const;
    /// Check whether it is safe or not to call GetResidue_graphs method.
    bool CanGetResidue_graphs(void) const;
    void ResetResidue_graphs(void);
    const TResidue_graphs& GetResidue_graphs(void) const;
    TResidue_graphs& SetResidue_graphs(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBiostruc_graph_Base(const CBiostruc_graph_Base&);
    CBiostruc_graph_Base& operator=(const CBiostruc_graph_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CBiomol_descr > > m_Descr;
    list< CRef< CMolecule_graph > > m_Molecule_graphs;
    list< CRef< CInter_residue_bond > > m_Inter_molecule_bonds;
    list< CRef< CResidue_graph > > m_Residue_graphs;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBiostruc_graph_Base::IsSetDescr(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBiostruc_graph_Base::CanGetDescr(void) const
{
    return true;
}

inline
const CBiostruc_graph_Base::TDescr& CBiostruc_graph_Base::GetDescr(void) const
{
    return m_Descr;
}

inline
CBiostruc_graph_Base::TDescr& CBiostruc_graph_Base::SetDescr(void)
{
    m_set_State[0] |= 0x1;
    return m_Descr;
}

inline
bool CBiostruc_graph_Base::IsSetMolecule_graphs(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBiostruc_graph_Base::CanGetMolecule_graphs(void) const
{
    return true;
}

inline
const CBiostruc_graph_Base::TMolecule_graphs& CBiostruc_graph_Base::GetMolecule_graphs(void) const
{
    return m_Molecule_graphs;
}

inline
CBiostruc_graph_Base::TMolecule_graphs& CBiostruc_graph_Base::SetMolecule_graphs(void)
{
    m_set_State[0] |= 0x4;
    return m_Molecule_graphs;
}

inline
bool CBiostruc_graph_Base::IsSetInter_molecule_bonds(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CBiostruc_graph_Base::CanGetInter_molecule_bonds(void) const
{
    return true;
}

inline
const CBiostruc_graph_Base::TInter_molecule_bonds& CBiostruc_graph_Base::GetInter_molecule_bonds(void) const
{
    return m_Inter_molecule_bonds;
}

inline
CBiostruc_graph_Base::TInter_molecule_bonds& CBiostruc_graph_Base::SetInter_molecule_bonds(void)
{
    m_set_State[0] |= 0x10;
    return m_Inter_molecule_bonds;
}

inline
bool CBiostruc_graph_Base::IsSetResidue_graphs(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CBiostruc_graph_Base::CanGetResidue_graphs(void) const
{
    return true;
}

inline
const CBiostruc_graph_Base::TResidue_graphs& CBiostruc_graph_Base::GetResidue_graphs(void) const
{
    return m_Residue_graphs;
}

inline
CBiostruc_graph_Base::TResidue_graphs& CBiostruc_graph_Base::SetResidue_graphs(void)
{
    m_set_State[0] |= 0x40;
    return m_Residue_graphs;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB1_BIOSTRUC_GRAPH_BASE_HPP
