/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Surface_coordinates_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB2_SURFACE_COORDINATES_BASE_HPP
#define OBJECTS_MMDB2_SURFACE_COORDINATES_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBrick;
class CChem_graph_pntrs;
class CCone;
class CCylinder;
class CSphere;
class CT_mesh;
class CTriangles;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Literal surface coordinates define the chemical components whose structure
/// is described by a surface, and the surface itself.  The surface may be
/// either a regular geometric solid or a triangle-mesh of arbitrary shape.
class NCBI_MMDB2_EXPORT CSurface_coordinates_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CSurface_coordinates_Base(void);
    // destructor
    virtual ~CSurface_coordinates_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_MMDB2_EXPORT C_Surface : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Surface(void);
        // destructor
        ~C_Surface(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Sphere,
            e_Cone,
            e_Cylinder,
            e_Brick,
            e_Tmesh,
            e_Triangles
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 7 ///< == e_Triangles+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef CSphere TSphere;
        typedef CCone TCone;
        typedef CCylinder TCylinder;
        typedef CBrick TBrick;
        typedef CT_mesh TTmesh;
        typedef CTriangles TTriangles;
    
        // getters
        // setters
    
        // typedef CSphere TSphere
        bool IsSphere(void) const;
        const TSphere& GetSphere(void) const;
        TSphere& SetSphere(void);
        void SetSphere(TSphere& value);
    
        // typedef CCone TCone
        bool IsCone(void) const;
        const TCone& GetCone(void) const;
        TCone& SetCone(void);
        void SetCone(TCone& value);
    
        // typedef CCylinder TCylinder
        bool IsCylinder(void) const;
        const TCylinder& GetCylinder(void) const;
        TCylinder& SetCylinder(void);
        void SetCylinder(TCylinder& value);
    
        // typedef CBrick TBrick
        bool IsBrick(void) const;
        const TBrick& GetBrick(void) const;
        TBrick& SetBrick(void);
        void SetBrick(TBrick& value);
    
        // typedef CT_mesh TTmesh
        bool IsTmesh(void) const;
        const TTmesh& GetTmesh(void) const;
        TTmesh& SetTmesh(void);
        void SetTmesh(TTmesh& value);
    
        // typedef CTriangles TTriangles
        bool IsTriangles(void) const;
        const TTriangles& GetTriangles(void) const;
        TTriangles& SetTriangles(void);
        void SetTriangles(TTriangles& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Surface(const C_Surface& );
        C_Surface& operator=(const C_Surface& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
    // types
    typedef CChem_graph_pntrs TContents;
    typedef C_Surface TSurface;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_contents,
        e_surface
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CChem_graph_pntrs TContents
    ///  Check whether the Contents data member has been assigned a value.
    bool IsSetContents(void) const;
    /// Check whether it is safe or not to call GetContents method.
    bool CanGetContents(void) const;
    void ResetContents(void);
    const TContents& GetContents(void) const;
    void SetContents(TContents& value);
    TContents& SetContents(void);

    /// mandatory
    /// typedef C_Surface TSurface
    ///  Check whether the Surface data member has been assigned a value.
    bool IsSetSurface(void) const;
    /// Check whether it is safe or not to call GetSurface method.
    bool CanGetSurface(void) const;
    void ResetSurface(void);
    const TSurface& GetSurface(void) const;
    void SetSurface(TSurface& value);
    TSurface& SetSurface(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CSurface_coordinates_Base(const CSurface_coordinates_Base&);
    CSurface_coordinates_Base& operator=(const CSurface_coordinates_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TContents > m_Contents;
    CRef< TSurface > m_Surface;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CSurface_coordinates_Base::C_Surface::E_Choice CSurface_coordinates_Base::C_Surface::Which(void) const
{
    return m_choice;
}

inline
void CSurface_coordinates_Base::C_Surface::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CSurface_coordinates_Base::C_Surface::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CSurface_coordinates_Base::C_Surface::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CSurface_coordinates_Base::C_Surface::IsSphere(void) const
{
    return m_choice == e_Sphere;
}

inline
bool CSurface_coordinates_Base::C_Surface::IsCone(void) const
{
    return m_choice == e_Cone;
}

inline
bool CSurface_coordinates_Base::C_Surface::IsCylinder(void) const
{
    return m_choice == e_Cylinder;
}

inline
bool CSurface_coordinates_Base::C_Surface::IsBrick(void) const
{
    return m_choice == e_Brick;
}

inline
bool CSurface_coordinates_Base::C_Surface::IsTmesh(void) const
{
    return m_choice == e_Tmesh;
}

inline
bool CSurface_coordinates_Base::C_Surface::IsTriangles(void) const
{
    return m_choice == e_Triangles;
}

inline
bool CSurface_coordinates_Base::IsSetContents(void) const
{
    return m_Contents.NotEmpty();
}

inline
bool CSurface_coordinates_Base::CanGetContents(void) const
{
    return true;
}

inline
const CSurface_coordinates_Base::TContents& CSurface_coordinates_Base::GetContents(void) const
{
    if ( !m_Contents ) {
        const_cast<CSurface_coordinates_Base*>(this)->ResetContents();
    }
    return (*m_Contents);
}

inline
CSurface_coordinates_Base::TContents& CSurface_coordinates_Base::SetContents(void)
{
    if ( !m_Contents ) {
        ResetContents();
    }
    return (*m_Contents);
}

inline
bool CSurface_coordinates_Base::IsSetSurface(void) const
{
    return m_Surface.NotEmpty();
}

inline
bool CSurface_coordinates_Base::CanGetSurface(void) const
{
    return true;
}

inline
const CSurface_coordinates_Base::TSurface& CSurface_coordinates_Base::GetSurface(void) const
{
    if ( !m_Surface ) {
        const_cast<CSurface_coordinates_Base*>(this)->ResetSurface();
    }
    return (*m_Surface);
}

inline
CSurface_coordinates_Base::TSurface& CSurface_coordinates_Base::SetSurface(void)
{
    if ( !m_Surface ) {
        ResetSurface();
    }
    return (*m_Surface);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB2_SURFACE_COORDINATES_BASE_HPP
