/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Triangles_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB2_TRIANGLES_BASE_HPP
#define OBJECTS_MMDB2_TRIANGLES_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MMDB2_EXPORT CTriangles_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CTriangles_Base(void);
    // destructor
    virtual ~CTriangles_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TNumber_of_points;
    typedef int TScale_factor;
    typedef list< int > TX;
    typedef list< int > TY;
    typedef list< int > TZ;
    typedef int TNumber_of_triangles;
    typedef list< int > TV1;
    typedef list< int > TV2;
    typedef list< int > TV3;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_number_of_points,
        e_scale_factor,
        e_x,
        e_y,
        e_z,
        e_number_of_triangles,
        e_v1,
        e_v2,
        e_v3
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TNumber_of_points
    ///  Check whether the Number_of_points data member has been assigned a value.
    bool IsSetNumber_of_points(void) const;
    /// Check whether it is safe or not to call GetNumber_of_points method.
    bool CanGetNumber_of_points(void) const;
    void ResetNumber_of_points(void);
    TNumber_of_points GetNumber_of_points(void) const;
    void SetNumber_of_points(TNumber_of_points value);
    TNumber_of_points& SetNumber_of_points(void);

    /// mandatory
    /// typedef int TScale_factor
    ///  Check whether the Scale_factor data member has been assigned a value.
    bool IsSetScale_factor(void) const;
    /// Check whether it is safe or not to call GetScale_factor method.
    bool CanGetScale_factor(void) const;
    void ResetScale_factor(void);
    TScale_factor GetScale_factor(void) const;
    void SetScale_factor(TScale_factor value);
    TScale_factor& SetScale_factor(void);

    /// mandatory
    /// typedef list< int > TX
    ///  Check whether the X data member has been assigned a value.
    bool IsSetX(void) const;
    /// Check whether it is safe or not to call GetX method.
    bool CanGetX(void) const;
    void ResetX(void);
    const TX& GetX(void) const;
    TX& SetX(void);

    /// mandatory
    /// typedef list< int > TY
    ///  Check whether the Y data member has been assigned a value.
    bool IsSetY(void) const;
    /// Check whether it is safe or not to call GetY method.
    bool CanGetY(void) const;
    void ResetY(void);
    const TY& GetY(void) const;
    TY& SetY(void);

    /// mandatory
    /// typedef list< int > TZ
    ///  Check whether the Z data member has been assigned a value.
    bool IsSetZ(void) const;
    /// Check whether it is safe or not to call GetZ method.
    bool CanGetZ(void) const;
    void ResetZ(void);
    const TZ& GetZ(void) const;
    TZ& SetZ(void);

    /// mandatory
    /// typedef int TNumber_of_triangles
    ///  Check whether the Number_of_triangles data member has been assigned a value.
    bool IsSetNumber_of_triangles(void) const;
    /// Check whether it is safe or not to call GetNumber_of_triangles method.
    bool CanGetNumber_of_triangles(void) const;
    void ResetNumber_of_triangles(void);
    TNumber_of_triangles GetNumber_of_triangles(void) const;
    void SetNumber_of_triangles(TNumber_of_triangles value);
    TNumber_of_triangles& SetNumber_of_triangles(void);

    /// mandatory
    /// typedef list< int > TV1
    ///  Check whether the V1 data member has been assigned a value.
    bool IsSetV1(void) const;
    /// Check whether it is safe or not to call GetV1 method.
    bool CanGetV1(void) const;
    void ResetV1(void);
    const TV1& GetV1(void) const;
    TV1& SetV1(void);

    /// mandatory
    /// typedef list< int > TV2
    ///  Check whether the V2 data member has been assigned a value.
    bool IsSetV2(void) const;
    /// Check whether it is safe or not to call GetV2 method.
    bool CanGetV2(void) const;
    void ResetV2(void);
    const TV2& GetV2(void) const;
    TV2& SetV2(void);

    /// mandatory
    /// typedef list< int > TV3
    ///  Check whether the V3 data member has been assigned a value.
    bool IsSetV3(void) const;
    /// Check whether it is safe or not to call GetV3 method.
    bool CanGetV3(void) const;
    void ResetV3(void);
    const TV3& GetV3(void) const;
    TV3& SetV3(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CTriangles_Base(const CTriangles_Base&);
    CTriangles_Base& operator=(const CTriangles_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Number_of_points;
    int m_Scale_factor;
    list< int > m_X;
    list< int > m_Y;
    list< int > m_Z;
    int m_Number_of_triangles;
    list< int > m_V1;
    list< int > m_V2;
    list< int > m_V3;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CTriangles_Base::IsSetNumber_of_points(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CTriangles_Base::CanGetNumber_of_points(void) const
{
    return IsSetNumber_of_points();
}

inline
void CTriangles_Base::ResetNumber_of_points(void)
{
    m_Number_of_points = 0;
    m_set_State[0] &= ~0x3;
}

inline
CTriangles_Base::TNumber_of_points CTriangles_Base::GetNumber_of_points(void) const
{
    if (!CanGetNumber_of_points()) {
        ThrowUnassigned(0);
    }
    return m_Number_of_points;
}

inline
void CTriangles_Base::SetNumber_of_points(CTriangles_Base::TNumber_of_points value)
{
    m_Number_of_points = value;
    m_set_State[0] |= 0x3;
}

inline
CTriangles_Base::TNumber_of_points& CTriangles_Base::SetNumber_of_points(void)
{
#ifdef _DEBUG
    if (!IsSetNumber_of_points()) {
        memset(&m_Number_of_points,UnassignedByte(),sizeof(m_Number_of_points));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Number_of_points;
}

inline
bool CTriangles_Base::IsSetScale_factor(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CTriangles_Base::CanGetScale_factor(void) const
{
    return IsSetScale_factor();
}

inline
void CTriangles_Base::ResetScale_factor(void)
{
    m_Scale_factor = 0;
    m_set_State[0] &= ~0xc;
}

inline
CTriangles_Base::TScale_factor CTriangles_Base::GetScale_factor(void) const
{
    if (!CanGetScale_factor()) {
        ThrowUnassigned(1);
    }
    return m_Scale_factor;
}

inline
void CTriangles_Base::SetScale_factor(CTriangles_Base::TScale_factor value)
{
    m_Scale_factor = value;
    m_set_State[0] |= 0xc;
}

inline
CTriangles_Base::TScale_factor& CTriangles_Base::SetScale_factor(void)
{
#ifdef _DEBUG
    if (!IsSetScale_factor()) {
        memset(&m_Scale_factor,UnassignedByte(),sizeof(m_Scale_factor));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Scale_factor;
}

inline
bool CTriangles_Base::IsSetX(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CTriangles_Base::CanGetX(void) const
{
    return true;
}

inline
const CTriangles_Base::TX& CTriangles_Base::GetX(void) const
{
    return m_X;
}

inline
CTriangles_Base::TX& CTriangles_Base::SetX(void)
{
    m_set_State[0] |= 0x10;
    return m_X;
}

inline
bool CTriangles_Base::IsSetY(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CTriangles_Base::CanGetY(void) const
{
    return true;
}

inline
const CTriangles_Base::TY& CTriangles_Base::GetY(void) const
{
    return m_Y;
}

inline
CTriangles_Base::TY& CTriangles_Base::SetY(void)
{
    m_set_State[0] |= 0x40;
    return m_Y;
}

inline
bool CTriangles_Base::IsSetZ(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CTriangles_Base::CanGetZ(void) const
{
    return true;
}

inline
const CTriangles_Base::TZ& CTriangles_Base::GetZ(void) const
{
    return m_Z;
}

inline
CTriangles_Base::TZ& CTriangles_Base::SetZ(void)
{
    m_set_State[0] |= 0x100;
    return m_Z;
}

inline
bool CTriangles_Base::IsSetNumber_of_triangles(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CTriangles_Base::CanGetNumber_of_triangles(void) const
{
    return IsSetNumber_of_triangles();
}

inline
void CTriangles_Base::ResetNumber_of_triangles(void)
{
    m_Number_of_triangles = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CTriangles_Base::TNumber_of_triangles CTriangles_Base::GetNumber_of_triangles(void) const
{
    if (!CanGetNumber_of_triangles()) {
        ThrowUnassigned(5);
    }
    return m_Number_of_triangles;
}

inline
void CTriangles_Base::SetNumber_of_triangles(CTriangles_Base::TNumber_of_triangles value)
{
    m_Number_of_triangles = value;
    m_set_State[0] |= 0xc00;
}

inline
CTriangles_Base::TNumber_of_triangles& CTriangles_Base::SetNumber_of_triangles(void)
{
#ifdef _DEBUG
    if (!IsSetNumber_of_triangles()) {
        memset(&m_Number_of_triangles,UnassignedByte(),sizeof(m_Number_of_triangles));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Number_of_triangles;
}

inline
bool CTriangles_Base::IsSetV1(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CTriangles_Base::CanGetV1(void) const
{
    return true;
}

inline
const CTriangles_Base::TV1& CTriangles_Base::GetV1(void) const
{
    return m_V1;
}

inline
CTriangles_Base::TV1& CTriangles_Base::SetV1(void)
{
    m_set_State[0] |= 0x1000;
    return m_V1;
}

inline
bool CTriangles_Base::IsSetV2(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CTriangles_Base::CanGetV2(void) const
{
    return true;
}

inline
const CTriangles_Base::TV2& CTriangles_Base::GetV2(void) const
{
    return m_V2;
}

inline
CTriangles_Base::TV2& CTriangles_Base::SetV2(void)
{
    m_set_State[0] |= 0x4000;
    return m_V2;
}

inline
bool CTriangles_Base::IsSetV3(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CTriangles_Base::CanGetV3(void) const
{
    return true;
}

inline
const CTriangles_Base::TV3& CTriangles_Base::GetV3(void) const
{
    return m_V3;
}

inline
CTriangles_Base::TV3& CTriangles_Base::SetV3(void)
{
    m_set_State[0] |= 0x10000;
    return m_V3;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB2_TRIANGLES_BASE_HPP
