/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cone_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb3.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB3_CONE_BASE_HPP
#define OBJECTS_MMDB3_CONE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CModel_space_point;
class CRealValue;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MMDB3_EXPORT CCone_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCone_Base(void);
    // destructor
    virtual ~CCone_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CModel_space_point TAxis_top;
    typedef CModel_space_point TAxis_bottom;
    typedef CRealValue TRadius_bottom;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_axis_top,
        e_axis_bottom,
        e_radius_bottom
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CModel_space_point TAxis_top
    ///  Check whether the Axis_top data member has been assigned a value.
    bool IsSetAxis_top(void) const;
    /// Check whether it is safe or not to call GetAxis_top method.
    bool CanGetAxis_top(void) const;
    void ResetAxis_top(void);
    const TAxis_top& GetAxis_top(void) const;
    void SetAxis_top(TAxis_top& value);
    TAxis_top& SetAxis_top(void);

    /// mandatory
    /// typedef CModel_space_point TAxis_bottom
    ///  Check whether the Axis_bottom data member has been assigned a value.
    bool IsSetAxis_bottom(void) const;
    /// Check whether it is safe or not to call GetAxis_bottom method.
    bool CanGetAxis_bottom(void) const;
    void ResetAxis_bottom(void);
    const TAxis_bottom& GetAxis_bottom(void) const;
    void SetAxis_bottom(TAxis_bottom& value);
    TAxis_bottom& SetAxis_bottom(void);

    /// mandatory
    /// typedef CRealValue TRadius_bottom
    ///  Check whether the Radius_bottom data member has been assigned a value.
    bool IsSetRadius_bottom(void) const;
    /// Check whether it is safe or not to call GetRadius_bottom method.
    bool CanGetRadius_bottom(void) const;
    void ResetRadius_bottom(void);
    const TRadius_bottom& GetRadius_bottom(void) const;
    void SetRadius_bottom(TRadius_bottom& value);
    TRadius_bottom& SetRadius_bottom(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCone_Base(const CCone_Base&);
    CCone_Base& operator=(const CCone_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TAxis_top > m_Axis_top;
    CRef< TAxis_bottom > m_Axis_bottom;
    CRef< TRadius_bottom > m_Radius_bottom;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCone_Base::IsSetAxis_top(void) const
{
    return m_Axis_top.NotEmpty();
}

inline
bool CCone_Base::CanGetAxis_top(void) const
{
    return true;
}

inline
const CCone_Base::TAxis_top& CCone_Base::GetAxis_top(void) const
{
    if ( !m_Axis_top ) {
        const_cast<CCone_Base*>(this)->ResetAxis_top();
    }
    return (*m_Axis_top);
}

inline
CCone_Base::TAxis_top& CCone_Base::SetAxis_top(void)
{
    if ( !m_Axis_top ) {
        ResetAxis_top();
    }
    return (*m_Axis_top);
}

inline
bool CCone_Base::IsSetAxis_bottom(void) const
{
    return m_Axis_bottom.NotEmpty();
}

inline
bool CCone_Base::CanGetAxis_bottom(void) const
{
    return true;
}

inline
const CCone_Base::TAxis_bottom& CCone_Base::GetAxis_bottom(void) const
{
    if ( !m_Axis_bottom ) {
        const_cast<CCone_Base*>(this)->ResetAxis_bottom();
    }
    return (*m_Axis_bottom);
}

inline
CCone_Base::TAxis_bottom& CCone_Base::SetAxis_bottom(void)
{
    if ( !m_Axis_bottom ) {
        ResetAxis_bottom();
    }
    return (*m_Axis_bottom);
}

inline
bool CCone_Base::IsSetRadius_bottom(void) const
{
    return m_Radius_bottom.NotEmpty();
}

inline
bool CCone_Base::CanGetRadius_bottom(void) const
{
    return true;
}

inline
const CCone_Base::TRadius_bottom& CCone_Base::GetRadius_bottom(void) const
{
    if ( !m_Radius_bottom ) {
        const_cast<CCone_Base*>(this)->ResetRadius_bottom();
    }
    return (*m_Radius_bottom);
}

inline
CCone_Base::TRadius_bottom& CCone_Base::SetRadius_bottom(void)
{
    if ( !m_Radius_bottom ) {
        ResetRadius_bottom();
    }
    return (*m_Radius_bottom);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB3_CONE_BASE_HPP
