/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cylinder_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb3.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB3_CYLINDER_BASE_HPP
#define OBJECTS_MMDB3_CYLINDER_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CModel_space_point;
class CRealValue;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MMDB3_EXPORT CCylinder_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCylinder_Base(void);
    // destructor
    virtual ~CCylinder_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CModel_space_point TAxis_top;
    typedef CModel_space_point TAxis_bottom;
    typedef CRealValue TRadius;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_axis_top,
        e_axis_bottom,
        e_radius
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CModel_space_point TAxis_top
    ///  Check whether the Axis_top data member has been assigned a value.
    bool IsSetAxis_top(void) const;
    /// Check whether it is safe or not to call GetAxis_top method.
    bool CanGetAxis_top(void) const;
    void ResetAxis_top(void);
    const TAxis_top& GetAxis_top(void) const;
    void SetAxis_top(TAxis_top& value);
    TAxis_top& SetAxis_top(void);

    /// mandatory
    /// typedef CModel_space_point TAxis_bottom
    ///  Check whether the Axis_bottom data member has been assigned a value.
    bool IsSetAxis_bottom(void) const;
    /// Check whether it is safe or not to call GetAxis_bottom method.
    bool CanGetAxis_bottom(void) const;
    void ResetAxis_bottom(void);
    const TAxis_bottom& GetAxis_bottom(void) const;
    void SetAxis_bottom(TAxis_bottom& value);
    TAxis_bottom& SetAxis_bottom(void);

    /// mandatory
    /// typedef CRealValue TRadius
    ///  Check whether the Radius data member has been assigned a value.
    bool IsSetRadius(void) const;
    /// Check whether it is safe or not to call GetRadius method.
    bool CanGetRadius(void) const;
    void ResetRadius(void);
    const TRadius& GetRadius(void) const;
    void SetRadius(TRadius& value);
    TRadius& SetRadius(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCylinder_Base(const CCylinder_Base&);
    CCylinder_Base& operator=(const CCylinder_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TAxis_top > m_Axis_top;
    CRef< TAxis_bottom > m_Axis_bottom;
    CRef< TRadius > m_Radius;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCylinder_Base::IsSetAxis_top(void) const
{
    return m_Axis_top.NotEmpty();
}

inline
bool CCylinder_Base::CanGetAxis_top(void) const
{
    return true;
}

inline
const CCylinder_Base::TAxis_top& CCylinder_Base::GetAxis_top(void) const
{
    if ( !m_Axis_top ) {
        const_cast<CCylinder_Base*>(this)->ResetAxis_top();
    }
    return (*m_Axis_top);
}

inline
CCylinder_Base::TAxis_top& CCylinder_Base::SetAxis_top(void)
{
    if ( !m_Axis_top ) {
        ResetAxis_top();
    }
    return (*m_Axis_top);
}

inline
bool CCylinder_Base::IsSetAxis_bottom(void) const
{
    return m_Axis_bottom.NotEmpty();
}

inline
bool CCylinder_Base::CanGetAxis_bottom(void) const
{
    return true;
}

inline
const CCylinder_Base::TAxis_bottom& CCylinder_Base::GetAxis_bottom(void) const
{
    if ( !m_Axis_bottom ) {
        const_cast<CCylinder_Base*>(this)->ResetAxis_bottom();
    }
    return (*m_Axis_bottom);
}

inline
CCylinder_Base::TAxis_bottom& CCylinder_Base::SetAxis_bottom(void)
{
    if ( !m_Axis_bottom ) {
        ResetAxis_bottom();
    }
    return (*m_Axis_bottom);
}

inline
bool CCylinder_Base::IsSetRadius(void) const
{
    return m_Radius.NotEmpty();
}

inline
bool CCylinder_Base::CanGetRadius(void) const
{
    return true;
}

inline
const CCylinder_Base::TRadius& CCylinder_Base::GetRadius(void) const
{
    if ( !m_Radius ) {
        const_cast<CCylinder_Base*>(this)->ResetRadius();
    }
    return (*m_Radius);
}

inline
CCylinder_Base::TRadius& CCylinder_Base::SetRadius(void)
{
    if ( !m_Radius ) {
        ResetRadius();
    }
    return (*m_Radius);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB3_CYLINDER_BASE_HPP
