/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Model_space_point_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb3.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB3_MODEL_SPACE_POINT_BASE_HPP
#define OBJECTS_MMDB3_MODEL_SPACE_POINT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MMDB3_EXPORT CModel_space_point_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CModel_space_point_Base(void);
    // destructor
    virtual ~CModel_space_point_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TScale_factor;
    typedef int TX;
    typedef int TY;
    typedef int TZ;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_scale_factor,
        e_x,
        e_y,
        e_z
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TScale_factor
    ///  Check whether the Scale_factor data member has been assigned a value.
    bool IsSetScale_factor(void) const;
    /// Check whether it is safe or not to call GetScale_factor method.
    bool CanGetScale_factor(void) const;
    void ResetScale_factor(void);
    TScale_factor GetScale_factor(void) const;
    void SetScale_factor(TScale_factor value);
    TScale_factor& SetScale_factor(void);

    /// mandatory
    /// typedef int TX
    ///  Check whether the X data member has been assigned a value.
    bool IsSetX(void) const;
    /// Check whether it is safe or not to call GetX method.
    bool CanGetX(void) const;
    void ResetX(void);
    TX GetX(void) const;
    void SetX(TX value);
    TX& SetX(void);

    /// mandatory
    /// typedef int TY
    ///  Check whether the Y data member has been assigned a value.
    bool IsSetY(void) const;
    /// Check whether it is safe or not to call GetY method.
    bool CanGetY(void) const;
    void ResetY(void);
    TY GetY(void) const;
    void SetY(TY value);
    TY& SetY(void);

    /// mandatory
    /// typedef int TZ
    ///  Check whether the Z data member has been assigned a value.
    bool IsSetZ(void) const;
    /// Check whether it is safe or not to call GetZ method.
    bool CanGetZ(void) const;
    void ResetZ(void);
    TZ GetZ(void) const;
    void SetZ(TZ value);
    TZ& SetZ(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CModel_space_point_Base(const CModel_space_point_Base&);
    CModel_space_point_Base& operator=(const CModel_space_point_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Scale_factor;
    int m_X;
    int m_Y;
    int m_Z;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CModel_space_point_Base::IsSetScale_factor(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CModel_space_point_Base::CanGetScale_factor(void) const
{
    return IsSetScale_factor();
}

inline
void CModel_space_point_Base::ResetScale_factor(void)
{
    m_Scale_factor = 0;
    m_set_State[0] &= ~0x3;
}

inline
CModel_space_point_Base::TScale_factor CModel_space_point_Base::GetScale_factor(void) const
{
    if (!CanGetScale_factor()) {
        ThrowUnassigned(0);
    }
    return m_Scale_factor;
}

inline
void CModel_space_point_Base::SetScale_factor(CModel_space_point_Base::TScale_factor value)
{
    m_Scale_factor = value;
    m_set_State[0] |= 0x3;
}

inline
CModel_space_point_Base::TScale_factor& CModel_space_point_Base::SetScale_factor(void)
{
#ifdef _DEBUG
    if (!IsSetScale_factor()) {
        memset(&m_Scale_factor,UnassignedByte(),sizeof(m_Scale_factor));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Scale_factor;
}

inline
bool CModel_space_point_Base::IsSetX(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CModel_space_point_Base::CanGetX(void) const
{
    return IsSetX();
}

inline
void CModel_space_point_Base::ResetX(void)
{
    m_X = 0;
    m_set_State[0] &= ~0xc;
}

inline
CModel_space_point_Base::TX CModel_space_point_Base::GetX(void) const
{
    if (!CanGetX()) {
        ThrowUnassigned(1);
    }
    return m_X;
}

inline
void CModel_space_point_Base::SetX(CModel_space_point_Base::TX value)
{
    m_X = value;
    m_set_State[0] |= 0xc;
}

inline
CModel_space_point_Base::TX& CModel_space_point_Base::SetX(void)
{
#ifdef _DEBUG
    if (!IsSetX()) {
        memset(&m_X,UnassignedByte(),sizeof(m_X));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_X;
}

inline
bool CModel_space_point_Base::IsSetY(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CModel_space_point_Base::CanGetY(void) const
{
    return IsSetY();
}

inline
void CModel_space_point_Base::ResetY(void)
{
    m_Y = 0;
    m_set_State[0] &= ~0x30;
}

inline
CModel_space_point_Base::TY CModel_space_point_Base::GetY(void) const
{
    if (!CanGetY()) {
        ThrowUnassigned(2);
    }
    return m_Y;
}

inline
void CModel_space_point_Base::SetY(CModel_space_point_Base::TY value)
{
    m_Y = value;
    m_set_State[0] |= 0x30;
}

inline
CModel_space_point_Base::TY& CModel_space_point_Base::SetY(void)
{
#ifdef _DEBUG
    if (!IsSetY()) {
        memset(&m_Y,UnassignedByte(),sizeof(m_Y));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Y;
}

inline
bool CModel_space_point_Base::IsSetZ(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CModel_space_point_Base::CanGetZ(void) const
{
    return IsSetZ();
}

inline
void CModel_space_point_Base::ResetZ(void)
{
    m_Z = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CModel_space_point_Base::TZ CModel_space_point_Base::GetZ(void) const
{
    if (!CanGetZ()) {
        ThrowUnassigned(3);
    }
    return m_Z;
}

inline
void CModel_space_point_Base::SetZ(CModel_space_point_Base::TZ value)
{
    m_Z = value;
    m_set_State[0] |= 0xc0;
}

inline
CModel_space_point_Base::TZ& CModel_space_point_Base::SetZ(void)
{
#ifdef _DEBUG
    if (!IsSetZ()) {
        memset(&m_Z,UnassignedByte(),sizeof(m_Z));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Z;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB3_MODEL_SPACE_POINT_BASE_HPP
