/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Region_pntrs_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb3.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB3_REGION_PNTRS_BASE_HPP
#define OBJECTS_MMDB3_REGION_PNTRS_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <objects/mmdb2/Model_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CRegion_boundary;
class CRegion_coordinates;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Region motifs describe features defined by spatial location, such as the
/// site specified by a coordinate value, or a rgeion within a bounding volume.
class NCBI_MMDB3_EXPORT CRegion_pntrs_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CRegion_pntrs_Base(void);
    // destructor
    virtual ~CRegion_pntrs_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_MMDB3_EXPORT C_Region : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Region(void);
        // destructor
        ~C_Region(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Site,
            e_Boundary
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_Boundary+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef list< CRef< CRegion_coordinates > > TSite;
        typedef list< CRef< CRegion_boundary > > TBoundary;
    
        // getters
        // setters
    
        // typedef list< CRef< CRegion_coordinates > > TSite
        bool IsSite(void) const;
        const TSite& GetSite(void) const;
        TSite& SetSite(void);
    
        // typedef list< CRef< CRegion_boundary > > TBoundary
        bool IsBoundary(void) const;
        const TBoundary& GetBoundary(void) const;
        TBoundary& SetBoundary(void);
    
    
    private:
        // copy constructor and assignment operator
        C_Region(const C_Region& );
        C_Region& operator=(const C_Region& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            NCBI_NS_NCBI::CUnionBuffer<TSite> m_Site;
            NCBI_NS_NCBI::CUnionBuffer<TBoundary> m_Boundary;
            void* m_dummy_pointer_for_alignment;
        };
    };
    // types
    typedef CModel_id TModel_id;
    typedef C_Region TRegion;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_model_id,
        e_region
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CModel_id TModel_id
    ///  Check whether the Model_id data member has been assigned a value.
    bool IsSetModel_id(void) const;
    /// Check whether it is safe or not to call GetModel_id method.
    bool CanGetModel_id(void) const;
    void ResetModel_id(void);
    const TModel_id& GetModel_id(void) const;
    void SetModel_id(const TModel_id& value);
    TModel_id& SetModel_id(void);

    /// mandatory
    /// typedef C_Region TRegion
    ///  Check whether the Region data member has been assigned a value.
    bool IsSetRegion(void) const;
    /// Check whether it is safe or not to call GetRegion method.
    bool CanGetRegion(void) const;
    void ResetRegion(void);
    const TRegion& GetRegion(void) const;
    void SetRegion(TRegion& value);
    TRegion& SetRegion(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CRegion_pntrs_Base(const CRegion_pntrs_Base&);
    CRegion_pntrs_Base& operator=(const CRegion_pntrs_Base&);

    // data
    Uint4 m_set_State[1];
    CModel_id m_Model_id;
    CRef< TRegion > m_Region;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CRegion_pntrs_Base::C_Region::E_Choice CRegion_pntrs_Base::C_Region::Which(void) const
{
    return m_choice;
}

inline
void CRegion_pntrs_Base::C_Region::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CRegion_pntrs_Base::C_Region::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CRegion_pntrs_Base::C_Region::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CRegion_pntrs_Base::C_Region::IsSite(void) const
{
    return m_choice == e_Site;
}

inline
const CRegion_pntrs_Base::C_Region::TSite& CRegion_pntrs_Base::C_Region::GetSite(void) const
{
    CheckSelected(e_Site);
    return *m_Site;
}

inline
CRegion_pntrs_Base::C_Region::TSite& CRegion_pntrs_Base::C_Region::SetSite(void)
{
    Select(e_Site, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Site;
}

inline
bool CRegion_pntrs_Base::C_Region::IsBoundary(void) const
{
    return m_choice == e_Boundary;
}

inline
const CRegion_pntrs_Base::C_Region::TBoundary& CRegion_pntrs_Base::C_Region::GetBoundary(void) const
{
    CheckSelected(e_Boundary);
    return *m_Boundary;
}

inline
CRegion_pntrs_Base::C_Region::TBoundary& CRegion_pntrs_Base::C_Region::SetBoundary(void)
{
    Select(e_Boundary, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_Boundary;
}

inline
bool CRegion_pntrs_Base::IsSetModel_id(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CRegion_pntrs_Base::CanGetModel_id(void) const
{
    return IsSetModel_id();
}

inline
void CRegion_pntrs_Base::ResetModel_id(void)
{
    m_Model_id = CModel_id(0);
    m_set_State[0] &= ~0x3;
}

inline
const CRegion_pntrs_Base::TModel_id& CRegion_pntrs_Base::GetModel_id(void) const
{
    if (!CanGetModel_id()) {
        ThrowUnassigned(0);
    }
    return m_Model_id;
}

inline
void CRegion_pntrs_Base::SetModel_id(const CRegion_pntrs_Base::TModel_id& value)
{
    m_Model_id = value;
    m_set_State[0] |= 0x3;
}

inline
CRegion_pntrs_Base::TModel_id& CRegion_pntrs_Base::SetModel_id(void)
{
    m_set_State[0] |= 0x1;
    return m_Model_id;
}

inline
bool CRegion_pntrs_Base::IsSetRegion(void) const
{
    return m_Region.NotEmpty();
}

inline
bool CRegion_pntrs_Base::CanGetRegion(void) const
{
    return true;
}

inline
const CRegion_pntrs_Base::TRegion& CRegion_pntrs_Base::GetRegion(void) const
{
    if ( !m_Region ) {
        const_cast<CRegion_pntrs_Base*>(this)->ResetRegion();
    }
    return (*m_Region);
}

inline
CRegion_pntrs_Base::TRegion& CRegion_pntrs_Base::SetRegion(void)
{
    if ( !m_Region ) {
        ResetRegion();
    }
    return (*m_Region);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB3_REGION_PNTRS_BASE_HPP
