/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Rot_matrix_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb3.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB3_ROT_MATRIX_BASE_HPP
#define OBJECTS_MMDB3_ROT_MATRIX_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// A rotation matrix is defined by 9 numbers, given by row, i.e.,
/// with column indices varying fastest.
/// Coordinates, as a matrix with columns x, y, an z, are rotated 
/// via multiplication with the rotation matrix. 
/// A translation matrix is defined by 3 numbers, which is added to
/// the rotated coordinates for specified amount of translation. 
class NCBI_MMDB3_EXPORT CRot_matrix_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CRot_matrix_Base(void);
    // destructor
    virtual ~CRot_matrix_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TScale_factor;
    typedef int TRot_11;
    typedef int TRot_12;
    typedef int TRot_13;
    typedef int TRot_21;
    typedef int TRot_22;
    typedef int TRot_23;
    typedef int TRot_31;
    typedef int TRot_32;
    typedef int TRot_33;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_scale_factor,
        e_rot_11,
        e_rot_12,
        e_rot_13,
        e_rot_21,
        e_rot_22,
        e_rot_23,
        e_rot_31,
        e_rot_32,
        e_rot_33
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 11> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TScale_factor
    ///  Check whether the Scale_factor data member has been assigned a value.
    bool IsSetScale_factor(void) const;
    /// Check whether it is safe or not to call GetScale_factor method.
    bool CanGetScale_factor(void) const;
    void ResetScale_factor(void);
    TScale_factor GetScale_factor(void) const;
    void SetScale_factor(TScale_factor value);
    TScale_factor& SetScale_factor(void);

    /// mandatory
    /// typedef int TRot_11
    ///  Check whether the Rot_11 data member has been assigned a value.
    bool IsSetRot_11(void) const;
    /// Check whether it is safe or not to call GetRot_11 method.
    bool CanGetRot_11(void) const;
    void ResetRot_11(void);
    TRot_11 GetRot_11(void) const;
    void SetRot_11(TRot_11 value);
    TRot_11& SetRot_11(void);

    /// mandatory
    /// typedef int TRot_12
    ///  Check whether the Rot_12 data member has been assigned a value.
    bool IsSetRot_12(void) const;
    /// Check whether it is safe or not to call GetRot_12 method.
    bool CanGetRot_12(void) const;
    void ResetRot_12(void);
    TRot_12 GetRot_12(void) const;
    void SetRot_12(TRot_12 value);
    TRot_12& SetRot_12(void);

    /// mandatory
    /// typedef int TRot_13
    ///  Check whether the Rot_13 data member has been assigned a value.
    bool IsSetRot_13(void) const;
    /// Check whether it is safe or not to call GetRot_13 method.
    bool CanGetRot_13(void) const;
    void ResetRot_13(void);
    TRot_13 GetRot_13(void) const;
    void SetRot_13(TRot_13 value);
    TRot_13& SetRot_13(void);

    /// mandatory
    /// typedef int TRot_21
    ///  Check whether the Rot_21 data member has been assigned a value.
    bool IsSetRot_21(void) const;
    /// Check whether it is safe or not to call GetRot_21 method.
    bool CanGetRot_21(void) const;
    void ResetRot_21(void);
    TRot_21 GetRot_21(void) const;
    void SetRot_21(TRot_21 value);
    TRot_21& SetRot_21(void);

    /// mandatory
    /// typedef int TRot_22
    ///  Check whether the Rot_22 data member has been assigned a value.
    bool IsSetRot_22(void) const;
    /// Check whether it is safe or not to call GetRot_22 method.
    bool CanGetRot_22(void) const;
    void ResetRot_22(void);
    TRot_22 GetRot_22(void) const;
    void SetRot_22(TRot_22 value);
    TRot_22& SetRot_22(void);

    /// mandatory
    /// typedef int TRot_23
    ///  Check whether the Rot_23 data member has been assigned a value.
    bool IsSetRot_23(void) const;
    /// Check whether it is safe or not to call GetRot_23 method.
    bool CanGetRot_23(void) const;
    void ResetRot_23(void);
    TRot_23 GetRot_23(void) const;
    void SetRot_23(TRot_23 value);
    TRot_23& SetRot_23(void);

    /// mandatory
    /// typedef int TRot_31
    ///  Check whether the Rot_31 data member has been assigned a value.
    bool IsSetRot_31(void) const;
    /// Check whether it is safe or not to call GetRot_31 method.
    bool CanGetRot_31(void) const;
    void ResetRot_31(void);
    TRot_31 GetRot_31(void) const;
    void SetRot_31(TRot_31 value);
    TRot_31& SetRot_31(void);

    /// mandatory
    /// typedef int TRot_32
    ///  Check whether the Rot_32 data member has been assigned a value.
    bool IsSetRot_32(void) const;
    /// Check whether it is safe or not to call GetRot_32 method.
    bool CanGetRot_32(void) const;
    void ResetRot_32(void);
    TRot_32 GetRot_32(void) const;
    void SetRot_32(TRot_32 value);
    TRot_32& SetRot_32(void);

    /// mandatory
    /// typedef int TRot_33
    ///  Check whether the Rot_33 data member has been assigned a value.
    bool IsSetRot_33(void) const;
    /// Check whether it is safe or not to call GetRot_33 method.
    bool CanGetRot_33(void) const;
    void ResetRot_33(void);
    TRot_33 GetRot_33(void) const;
    void SetRot_33(TRot_33 value);
    TRot_33& SetRot_33(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CRot_matrix_Base(const CRot_matrix_Base&);
    CRot_matrix_Base& operator=(const CRot_matrix_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Scale_factor;
    int m_Rot_11;
    int m_Rot_12;
    int m_Rot_13;
    int m_Rot_21;
    int m_Rot_22;
    int m_Rot_23;
    int m_Rot_31;
    int m_Rot_32;
    int m_Rot_33;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CRot_matrix_Base::IsSetScale_factor(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CRot_matrix_Base::CanGetScale_factor(void) const
{
    return IsSetScale_factor();
}

inline
void CRot_matrix_Base::ResetScale_factor(void)
{
    m_Scale_factor = 0;
    m_set_State[0] &= ~0x3;
}

inline
CRot_matrix_Base::TScale_factor CRot_matrix_Base::GetScale_factor(void) const
{
    if (!CanGetScale_factor()) {
        ThrowUnassigned(0);
    }
    return m_Scale_factor;
}

inline
void CRot_matrix_Base::SetScale_factor(CRot_matrix_Base::TScale_factor value)
{
    m_Scale_factor = value;
    m_set_State[0] |= 0x3;
}

inline
CRot_matrix_Base::TScale_factor& CRot_matrix_Base::SetScale_factor(void)
{
#ifdef _DEBUG
    if (!IsSetScale_factor()) {
        memset(&m_Scale_factor,UnassignedByte(),sizeof(m_Scale_factor));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Scale_factor;
}

inline
bool CRot_matrix_Base::IsSetRot_11(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CRot_matrix_Base::CanGetRot_11(void) const
{
    return IsSetRot_11();
}

inline
void CRot_matrix_Base::ResetRot_11(void)
{
    m_Rot_11 = 0;
    m_set_State[0] &= ~0xc;
}

inline
CRot_matrix_Base::TRot_11 CRot_matrix_Base::GetRot_11(void) const
{
    if (!CanGetRot_11()) {
        ThrowUnassigned(1);
    }
    return m_Rot_11;
}

inline
void CRot_matrix_Base::SetRot_11(CRot_matrix_Base::TRot_11 value)
{
    m_Rot_11 = value;
    m_set_State[0] |= 0xc;
}

inline
CRot_matrix_Base::TRot_11& CRot_matrix_Base::SetRot_11(void)
{
#ifdef _DEBUG
    if (!IsSetRot_11()) {
        memset(&m_Rot_11,UnassignedByte(),sizeof(m_Rot_11));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Rot_11;
}

inline
bool CRot_matrix_Base::IsSetRot_12(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CRot_matrix_Base::CanGetRot_12(void) const
{
    return IsSetRot_12();
}

inline
void CRot_matrix_Base::ResetRot_12(void)
{
    m_Rot_12 = 0;
    m_set_State[0] &= ~0x30;
}

inline
CRot_matrix_Base::TRot_12 CRot_matrix_Base::GetRot_12(void) const
{
    if (!CanGetRot_12()) {
        ThrowUnassigned(2);
    }
    return m_Rot_12;
}

inline
void CRot_matrix_Base::SetRot_12(CRot_matrix_Base::TRot_12 value)
{
    m_Rot_12 = value;
    m_set_State[0] |= 0x30;
}

inline
CRot_matrix_Base::TRot_12& CRot_matrix_Base::SetRot_12(void)
{
#ifdef _DEBUG
    if (!IsSetRot_12()) {
        memset(&m_Rot_12,UnassignedByte(),sizeof(m_Rot_12));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Rot_12;
}

inline
bool CRot_matrix_Base::IsSetRot_13(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CRot_matrix_Base::CanGetRot_13(void) const
{
    return IsSetRot_13();
}

inline
void CRot_matrix_Base::ResetRot_13(void)
{
    m_Rot_13 = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CRot_matrix_Base::TRot_13 CRot_matrix_Base::GetRot_13(void) const
{
    if (!CanGetRot_13()) {
        ThrowUnassigned(3);
    }
    return m_Rot_13;
}

inline
void CRot_matrix_Base::SetRot_13(CRot_matrix_Base::TRot_13 value)
{
    m_Rot_13 = value;
    m_set_State[0] |= 0xc0;
}

inline
CRot_matrix_Base::TRot_13& CRot_matrix_Base::SetRot_13(void)
{
#ifdef _DEBUG
    if (!IsSetRot_13()) {
        memset(&m_Rot_13,UnassignedByte(),sizeof(m_Rot_13));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Rot_13;
}

inline
bool CRot_matrix_Base::IsSetRot_21(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CRot_matrix_Base::CanGetRot_21(void) const
{
    return IsSetRot_21();
}

inline
void CRot_matrix_Base::ResetRot_21(void)
{
    m_Rot_21 = 0;
    m_set_State[0] &= ~0x300;
}

inline
CRot_matrix_Base::TRot_21 CRot_matrix_Base::GetRot_21(void) const
{
    if (!CanGetRot_21()) {
        ThrowUnassigned(4);
    }
    return m_Rot_21;
}

inline
void CRot_matrix_Base::SetRot_21(CRot_matrix_Base::TRot_21 value)
{
    m_Rot_21 = value;
    m_set_State[0] |= 0x300;
}

inline
CRot_matrix_Base::TRot_21& CRot_matrix_Base::SetRot_21(void)
{
#ifdef _DEBUG
    if (!IsSetRot_21()) {
        memset(&m_Rot_21,UnassignedByte(),sizeof(m_Rot_21));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Rot_21;
}

inline
bool CRot_matrix_Base::IsSetRot_22(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CRot_matrix_Base::CanGetRot_22(void) const
{
    return IsSetRot_22();
}

inline
void CRot_matrix_Base::ResetRot_22(void)
{
    m_Rot_22 = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CRot_matrix_Base::TRot_22 CRot_matrix_Base::GetRot_22(void) const
{
    if (!CanGetRot_22()) {
        ThrowUnassigned(5);
    }
    return m_Rot_22;
}

inline
void CRot_matrix_Base::SetRot_22(CRot_matrix_Base::TRot_22 value)
{
    m_Rot_22 = value;
    m_set_State[0] |= 0xc00;
}

inline
CRot_matrix_Base::TRot_22& CRot_matrix_Base::SetRot_22(void)
{
#ifdef _DEBUG
    if (!IsSetRot_22()) {
        memset(&m_Rot_22,UnassignedByte(),sizeof(m_Rot_22));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Rot_22;
}

inline
bool CRot_matrix_Base::IsSetRot_23(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CRot_matrix_Base::CanGetRot_23(void) const
{
    return IsSetRot_23();
}

inline
void CRot_matrix_Base::ResetRot_23(void)
{
    m_Rot_23 = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CRot_matrix_Base::TRot_23 CRot_matrix_Base::GetRot_23(void) const
{
    if (!CanGetRot_23()) {
        ThrowUnassigned(6);
    }
    return m_Rot_23;
}

inline
void CRot_matrix_Base::SetRot_23(CRot_matrix_Base::TRot_23 value)
{
    m_Rot_23 = value;
    m_set_State[0] |= 0x3000;
}

inline
CRot_matrix_Base::TRot_23& CRot_matrix_Base::SetRot_23(void)
{
#ifdef _DEBUG
    if (!IsSetRot_23()) {
        memset(&m_Rot_23,UnassignedByte(),sizeof(m_Rot_23));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Rot_23;
}

inline
bool CRot_matrix_Base::IsSetRot_31(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CRot_matrix_Base::CanGetRot_31(void) const
{
    return IsSetRot_31();
}

inline
void CRot_matrix_Base::ResetRot_31(void)
{
    m_Rot_31 = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CRot_matrix_Base::TRot_31 CRot_matrix_Base::GetRot_31(void) const
{
    if (!CanGetRot_31()) {
        ThrowUnassigned(7);
    }
    return m_Rot_31;
}

inline
void CRot_matrix_Base::SetRot_31(CRot_matrix_Base::TRot_31 value)
{
    m_Rot_31 = value;
    m_set_State[0] |= 0xc000;
}

inline
CRot_matrix_Base::TRot_31& CRot_matrix_Base::SetRot_31(void)
{
#ifdef _DEBUG
    if (!IsSetRot_31()) {
        memset(&m_Rot_31,UnassignedByte(),sizeof(m_Rot_31));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Rot_31;
}

inline
bool CRot_matrix_Base::IsSetRot_32(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CRot_matrix_Base::CanGetRot_32(void) const
{
    return IsSetRot_32();
}

inline
void CRot_matrix_Base::ResetRot_32(void)
{
    m_Rot_32 = 0;
    m_set_State[0] &= ~0x30000;
}

inline
CRot_matrix_Base::TRot_32 CRot_matrix_Base::GetRot_32(void) const
{
    if (!CanGetRot_32()) {
        ThrowUnassigned(8);
    }
    return m_Rot_32;
}

inline
void CRot_matrix_Base::SetRot_32(CRot_matrix_Base::TRot_32 value)
{
    m_Rot_32 = value;
    m_set_State[0] |= 0x30000;
}

inline
CRot_matrix_Base::TRot_32& CRot_matrix_Base::SetRot_32(void)
{
#ifdef _DEBUG
    if (!IsSetRot_32()) {
        memset(&m_Rot_32,UnassignedByte(),sizeof(m_Rot_32));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Rot_32;
}

inline
bool CRot_matrix_Base::IsSetRot_33(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CRot_matrix_Base::CanGetRot_33(void) const
{
    return IsSetRot_33();
}

inline
void CRot_matrix_Base::ResetRot_33(void)
{
    m_Rot_33 = 0;
    m_set_State[0] &= ~0xc0000;
}

inline
CRot_matrix_Base::TRot_33 CRot_matrix_Base::GetRot_33(void) const
{
    if (!CanGetRot_33()) {
        ThrowUnassigned(9);
    }
    return m_Rot_33;
}

inline
void CRot_matrix_Base::SetRot_33(CRot_matrix_Base::TRot_33 value)
{
    m_Rot_33 = value;
    m_set_State[0] |= 0xc0000;
}

inline
CRot_matrix_Base::TRot_33& CRot_matrix_Base::SetRot_33(void)
{
#ifdef _DEBUG
    if (!IsSetRot_33()) {
        memset(&m_Rot_33,UnassignedByte(),sizeof(m_Rot_33));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Rot_33;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB3_ROT_MATRIX_BASE_HPP
