/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Ncbi_mime_asn1_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'ncbimime.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_NCBIMIME_NCBI_MIME_ASN1_BASE_HPP
#define OBJECTS_NCBIMIME_NCBI_MIME_ASN1_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBiostruc_align;
class CBiostruc_align_seq;
class CBiostruc_seq;
class CBiostruc_seqs;
class CBiostruc_seqs_aligns_cdd;
class CEntrez_general;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_NCBIMIME_EXPORT CNcbi_mime_asn1_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CNcbi_mime_asn1_Base(void);
    // destructor
    virtual ~CNcbi_mime_asn1_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Entrez,       ///< just a structure
        e_Alignstruc,   ///< structures & sequences & alignments
        e_Alignseq,     ///< sequence alignment
        e_Strucseq,     ///< structure & sequences
        e_Strucseqs,    ///< structure & sequences & alignments
        e_General       ///< all-purpose "grab bag"  others may be added here in the future
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 7 ///< == e_General+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CEntrez_general TEntrez;
    typedef CBiostruc_align TAlignstruc;
    typedef CBiostruc_align_seq TAlignseq;
    typedef CBiostruc_seq TStrucseq;
    typedef CBiostruc_seqs TStrucseqs;
    typedef CBiostruc_seqs_aligns_cdd TGeneral;

    // getters
    // setters

    // typedef CEntrez_general TEntrez
    bool IsEntrez(void) const;
    const TEntrez& GetEntrez(void) const;
    TEntrez& SetEntrez(void);
    void SetEntrez(TEntrez& value);

    // typedef CBiostruc_align TAlignstruc
    bool IsAlignstruc(void) const;
    const TAlignstruc& GetAlignstruc(void) const;
    TAlignstruc& SetAlignstruc(void);
    void SetAlignstruc(TAlignstruc& value);

    // typedef CBiostruc_align_seq TAlignseq
    bool IsAlignseq(void) const;
    const TAlignseq& GetAlignseq(void) const;
    TAlignseq& SetAlignseq(void);
    void SetAlignseq(TAlignseq& value);

    // typedef CBiostruc_seq TStrucseq
    bool IsStrucseq(void) const;
    const TStrucseq& GetStrucseq(void) const;
    TStrucseq& SetStrucseq(void);
    void SetStrucseq(TStrucseq& value);

    // typedef CBiostruc_seqs TStrucseqs
    bool IsStrucseqs(void) const;
    const TStrucseqs& GetStrucseqs(void) const;
    TStrucseqs& SetStrucseqs(void);
    void SetStrucseqs(TStrucseqs& value);

    // typedef CBiostruc_seqs_aligns_cdd TGeneral
    bool IsGeneral(void) const;
    const TGeneral& GetGeneral(void) const;
    TGeneral& SetGeneral(void);
    void SetGeneral(TGeneral& value);


private:
    // copy constructor and assignment operator
    CNcbi_mime_asn1_Base(const CNcbi_mime_asn1_Base& );
    CNcbi_mime_asn1_Base& operator=(const CNcbi_mime_asn1_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    NCBI_NS_NCBI::CSerialObject *m_object;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CNcbi_mime_asn1_Base::E_Choice CNcbi_mime_asn1_Base::Which(void) const
{
    return m_choice;
}

inline
void CNcbi_mime_asn1_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CNcbi_mime_asn1_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CNcbi_mime_asn1_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CNcbi_mime_asn1_Base::IsEntrez(void) const
{
    return m_choice == e_Entrez;
}

inline
bool CNcbi_mime_asn1_Base::IsAlignstruc(void) const
{
    return m_choice == e_Alignstruc;
}

inline
bool CNcbi_mime_asn1_Base::IsAlignseq(void) const
{
    return m_choice == e_Alignseq;
}

inline
bool CNcbi_mime_asn1_Base::IsStrucseq(void) const
{
    return m_choice == e_Strucseq;
}

inline
bool CNcbi_mime_asn1_Base::IsStrucseqs(void) const
{
    return m_choice == e_Strucseqs;
}

inline
bool CNcbi_mime_asn1_Base::IsGeneral(void) const
{
    return m_choice == e_General;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_NCBIMIME_NCBI_MIME_ASN1_BASE_HPP
