/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MSModSpec_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'omssa.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_OMSSA_MSMODSPEC_BASE_HPP
#define OBJECTS_OMSSA_MSMODSPEC_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objects/omssa/MSMod.hpp>
#include <objects/omssa/MSModType.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CMSMassSet;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Modification Definition
class NCBI_OMSSA_EXPORT CMSModSpec_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMSModSpec_Base(void);
    // destructor
    virtual ~CMSModSpec_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TMod;
    typedef int TType;
    typedef string TName;
    typedef double TMonomass;
    typedef double TAveragemass;
    typedef double TN15mass;
    typedef list< string > TResidues;
    typedef CMSMassSet TNeutralloss;
    typedef int TUnimod;
    typedef string TPsi_ms;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_mod,
        e_type,
        e_name,
        e_monomass,
        e_averagemass,
        e_n15mass,
        e_residues,
        e_neutralloss,
        e_unimod,
        e_psi_ms
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 11> TmemberIndex;

    // getters
    // setters

    /// what is the mod
    /// mandatory
    /// typedef int TMod
    ///  Check whether the Mod data member has been assigned a value.
    bool IsSetMod(void) const;
    /// Check whether it is safe or not to call GetMod method.
    bool CanGetMod(void) const;
    void ResetMod(void);
    TMod GetMod(void) const;
    void SetMod(TMod value);
    TMod& SetMod(void);

    /// modification type
    /// mandatory
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// friendly name of mod
    /// mandatory
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// monoisotopic mass
    /// mandatory
    /// typedef double TMonomass
    ///  Check whether the Monomass data member has been assigned a value.
    bool IsSetMonomass(void) const;
    /// Check whether it is safe or not to call GetMonomass method.
    bool CanGetMonomass(void) const;
    void ResetMonomass(void);
    TMonomass GetMonomass(void) const;
    void SetMonomass(TMonomass value);
    TMonomass& SetMonomass(void);

    /// average mass
    /// mandatory
    /// typedef double TAveragemass
    ///  Check whether the Averagemass data member has been assigned a value.
    bool IsSetAveragemass(void) const;
    /// Check whether it is safe or not to call GetAveragemass method.
    bool CanGetAveragemass(void) const;
    void ResetAveragemass(void);
    TAveragemass GetAveragemass(void) const;
    void SetAveragemass(TAveragemass value);
    TAveragemass& SetAveragemass(void);

    /// monoisotopic n15 mass
    /// mandatory
    /// typedef double TN15mass
    ///  Check whether the N15mass data member has been assigned a value.
    bool IsSetN15mass(void) const;
    /// Check whether it is safe or not to call GetN15mass method.
    bool CanGetN15mass(void) const;
    void ResetN15mass(void);
    TN15mass GetN15mass(void) const;
    void SetN15mass(TN15mass value);
    TN15mass& SetN15mass(void);

    /// residues to apply mod to
    /// optional
    /// typedef list< string > TResidues
    ///  Check whether the Residues data member has been assigned a value.
    bool IsSetResidues(void) const;
    /// Check whether it is safe or not to call GetResidues method.
    bool CanGetResidues(void) const;
    void ResetResidues(void);
    const TResidues& GetResidues(void) const;
    TResidues& SetResidues(void);

    /// loss after precursor mass determination
    /// optional
    /// typedef CMSMassSet TNeutralloss
    ///  Check whether the Neutralloss data member has been assigned a value.
    bool IsSetNeutralloss(void) const;
    /// Check whether it is safe or not to call GetNeutralloss method.
    bool CanGetNeutralloss(void) const;
    void ResetNeutralloss(void);
    const TNeutralloss& GetNeutralloss(void) const;
    void SetNeutralloss(TNeutralloss& value);
    TNeutralloss& SetNeutralloss(void);

    /// the equivalent Unimod Accession number
    /// optional
    /// typedef int TUnimod
    ///  Check whether the Unimod data member has been assigned a value.
    bool IsSetUnimod(void) const;
    /// Check whether it is safe or not to call GetUnimod method.
    bool CanGetUnimod(void) const;
    void ResetUnimod(void);
    TUnimod GetUnimod(void) const;
    void SetUnimod(TUnimod value);
    TUnimod& SetUnimod(void);

    /// the PSI-MS equivalent name  
    /// optional
    /// typedef string TPsi_ms
    ///  Check whether the Psi_ms data member has been assigned a value.
    bool IsSetPsi_ms(void) const;
    /// Check whether it is safe or not to call GetPsi_ms method.
    bool CanGetPsi_ms(void) const;
    void ResetPsi_ms(void);
    const TPsi_ms& GetPsi_ms(void) const;
    void SetPsi_ms(const TPsi_ms& value);
    void SetPsi_ms(TPsi_ms&& value);
    TPsi_ms& SetPsi_ms(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMSModSpec_Base(const CMSModSpec_Base&);
    CMSModSpec_Base& operator=(const CMSModSpec_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Mod;
    int m_Type;
    string m_Name;
    double m_Monomass;
    double m_Averagemass;
    double m_N15mass;
    list< string > m_Residues;
    CRef< TNeutralloss > m_Neutralloss;
    int m_Unimod;
    string m_Psi_ms;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMSModSpec_Base::IsSetMod(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMSModSpec_Base::CanGetMod(void) const
{
    return IsSetMod();
}

inline
void CMSModSpec_Base::ResetMod(void)
{
    m_Mod = (int)(0);
    m_set_State[0] &= ~0x3;
}

inline
CMSModSpec_Base::TMod CMSModSpec_Base::GetMod(void) const
{
    if (!CanGetMod()) {
        ThrowUnassigned(0);
    }
    return m_Mod;
}

inline
void CMSModSpec_Base::SetMod(CMSModSpec_Base::TMod value)
{
    m_Mod = value;
    m_set_State[0] |= 0x3;
}

inline
CMSModSpec_Base::TMod& CMSModSpec_Base::SetMod(void)
{
#ifdef _DEBUG
    if (!IsSetMod()) {
        memset(&m_Mod,UnassignedByte(),sizeof(m_Mod));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Mod;
}

inline
bool CMSModSpec_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMSModSpec_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CMSModSpec_Base::ResetType(void)
{
    m_Type = (int)(0);
    m_set_State[0] &= ~0xc;
}

inline
CMSModSpec_Base::TType CMSModSpec_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(1);
    }
    return m_Type;
}

inline
void CMSModSpec_Base::SetType(CMSModSpec_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0xc;
}

inline
CMSModSpec_Base::TType& CMSModSpec_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Type;
}

inline
bool CMSModSpec_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMSModSpec_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CMSModSpec_Base::TName& CMSModSpec_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(2);
    }
    return m_Name;
}

inline
void CMSModSpec_Base::SetName(const CMSModSpec_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x30;
}

inline
void CMSModSpec_Base::SetName(CMSModSpec_Base::TName&& value)
{
    m_Name = std::forward<CMSModSpec_Base::TName>(value);
    m_set_State[0] |= 0x30;
}

inline
CMSModSpec_Base::TName& CMSModSpec_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Name;
}

inline
bool CMSModSpec_Base::IsSetMonomass(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMSModSpec_Base::CanGetMonomass(void) const
{
    return IsSetMonomass();
}

inline
void CMSModSpec_Base::ResetMonomass(void)
{
    m_Monomass = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CMSModSpec_Base::TMonomass CMSModSpec_Base::GetMonomass(void) const
{
    if (!CanGetMonomass()) {
        ThrowUnassigned(3);
    }
    return m_Monomass;
}

inline
void CMSModSpec_Base::SetMonomass(CMSModSpec_Base::TMonomass value)
{
    m_Monomass = value;
    m_set_State[0] |= 0xc0;
}

inline
CMSModSpec_Base::TMonomass& CMSModSpec_Base::SetMonomass(void)
{
#ifdef _DEBUG
    if (!IsSetMonomass()) {
        memset(&m_Monomass,UnassignedByte(),sizeof(m_Monomass));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Monomass;
}

inline
bool CMSModSpec_Base::IsSetAveragemass(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMSModSpec_Base::CanGetAveragemass(void) const
{
    return IsSetAveragemass();
}

inline
void CMSModSpec_Base::ResetAveragemass(void)
{
    m_Averagemass = 0;
    m_set_State[0] &= ~0x300;
}

inline
CMSModSpec_Base::TAveragemass CMSModSpec_Base::GetAveragemass(void) const
{
    if (!CanGetAveragemass()) {
        ThrowUnassigned(4);
    }
    return m_Averagemass;
}

inline
void CMSModSpec_Base::SetAveragemass(CMSModSpec_Base::TAveragemass value)
{
    m_Averagemass = value;
    m_set_State[0] |= 0x300;
}

inline
CMSModSpec_Base::TAveragemass& CMSModSpec_Base::SetAveragemass(void)
{
#ifdef _DEBUG
    if (!IsSetAveragemass()) {
        memset(&m_Averagemass,UnassignedByte(),sizeof(m_Averagemass));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Averagemass;
}

inline
bool CMSModSpec_Base::IsSetN15mass(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMSModSpec_Base::CanGetN15mass(void) const
{
    return IsSetN15mass();
}

inline
void CMSModSpec_Base::ResetN15mass(void)
{
    m_N15mass = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CMSModSpec_Base::TN15mass CMSModSpec_Base::GetN15mass(void) const
{
    if (!CanGetN15mass()) {
        ThrowUnassigned(5);
    }
    return m_N15mass;
}

inline
void CMSModSpec_Base::SetN15mass(CMSModSpec_Base::TN15mass value)
{
    m_N15mass = value;
    m_set_State[0] |= 0xc00;
}

inline
CMSModSpec_Base::TN15mass& CMSModSpec_Base::SetN15mass(void)
{
#ifdef _DEBUG
    if (!IsSetN15mass()) {
        memset(&m_N15mass,UnassignedByte(),sizeof(m_N15mass));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_N15mass;
}

inline
bool CMSModSpec_Base::IsSetResidues(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMSModSpec_Base::CanGetResidues(void) const
{
    return true;
}

inline
const CMSModSpec_Base::TResidues& CMSModSpec_Base::GetResidues(void) const
{
    return m_Residues;
}

inline
CMSModSpec_Base::TResidues& CMSModSpec_Base::SetResidues(void)
{
    m_set_State[0] |= 0x1000;
    return m_Residues;
}

inline
bool CMSModSpec_Base::IsSetNeutralloss(void) const
{
    return m_Neutralloss.NotEmpty();
}

inline
bool CMSModSpec_Base::CanGetNeutralloss(void) const
{
    return IsSetNeutralloss();
}

inline
const CMSModSpec_Base::TNeutralloss& CMSModSpec_Base::GetNeutralloss(void) const
{
    if (!CanGetNeutralloss()) {
        ThrowUnassigned(7);
    }
    return (*m_Neutralloss);
}

inline
bool CMSModSpec_Base::IsSetUnimod(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CMSModSpec_Base::CanGetUnimod(void) const
{
    return IsSetUnimod();
}

inline
void CMSModSpec_Base::ResetUnimod(void)
{
    m_Unimod = 0;
    m_set_State[0] &= ~0x30000;
}

inline
CMSModSpec_Base::TUnimod CMSModSpec_Base::GetUnimod(void) const
{
    if (!CanGetUnimod()) {
        ThrowUnassigned(8);
    }
    return m_Unimod;
}

inline
void CMSModSpec_Base::SetUnimod(CMSModSpec_Base::TUnimod value)
{
    m_Unimod = value;
    m_set_State[0] |= 0x30000;
}

inline
CMSModSpec_Base::TUnimod& CMSModSpec_Base::SetUnimod(void)
{
#ifdef _DEBUG
    if (!IsSetUnimod()) {
        memset(&m_Unimod,UnassignedByte(),sizeof(m_Unimod));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Unimod;
}

inline
bool CMSModSpec_Base::IsSetPsi_ms(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CMSModSpec_Base::CanGetPsi_ms(void) const
{
    return IsSetPsi_ms();
}

inline
const CMSModSpec_Base::TPsi_ms& CMSModSpec_Base::GetPsi_ms(void) const
{
    if (!CanGetPsi_ms()) {
        ThrowUnassigned(9);
    }
    return m_Psi_ms;
}

inline
void CMSModSpec_Base::SetPsi_ms(const CMSModSpec_Base::TPsi_ms& value)
{
    m_Psi_ms = value;
    m_set_State[0] |= 0xc0000;
}

inline
void CMSModSpec_Base::SetPsi_ms(CMSModSpec_Base::TPsi_ms&& value)
{
    m_Psi_ms = std::forward<CMSModSpec_Base::TPsi_ms>(value);
    m_set_State[0] |= 0xc0000;
}

inline
CMSModSpec_Base::TPsi_ms& CMSModSpec_Base::SetPsi_ms(void)
{
#ifdef _DEBUG
    if (!IsSetPsi_ms()) {
        m_Psi_ms = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Psi_ms;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_OMSSA_MSMODSPEC_BASE_HPP
