/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MSMod_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'omssa.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_OMSSA_MSMOD_BASE_HPP
#define OBJECTS_OMSSA_MSMOD_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/// enumerate modifications
enum EMSMod {
    eMSMod_methylk                   =     0,  ///< methylation of K
    eMSMod_oxym                      =     1,  ///< oxidation of methionine
    eMSMod_carboxymethylc            =     2,  ///< carboxymethyl cysteine
    eMSMod_carbamidomethylc          =     3,  ///< carbamidomethyl cysteine
    eMSMod_deamidationkq             =     4,  ///< deamidation of K and Q
    eMSMod_propionamidec             =     5,  ///< propionamide cysteine
    eMSMod_phosphorylations          =     6,  ///< phosphorylation of S
    eMSMod_phosphorylationt          =     7,  ///< phosphorylation of T
    eMSMod_phosphorylationy          =     8,  ///< phosphorylation of Y    
    eMSMod_ntermmcleave              =     9,  ///< N terminal methionine cleavage
    eMSMod_ntermacetyl               =    10,  ///< N terminal protein acetyl
    eMSMod_ntermmethyl               =    11,  ///< N terminal protein methyl
    eMSMod_ntermtrimethyl            =    12,  ///< N terminal protein trimethyl
    eMSMod_methythiold               =    13,  ///< beta methythiolation of D
    eMSMod_methylq                   =    14,  ///< methylation of Q
    eMSMod_trimethylk                =    15,  ///< trimethylation of K
    eMSMod_methyld                   =    16,  ///< methylation of D
    eMSMod_methyle                   =    17,  ///< methylation of E
    eMSMod_ctermpepmethyl            =    18,  ///< C terminal methylation
    eMSMod_trideuteromethyld         =    19,  ///< trideuteromethylation of D
    eMSMod_trideuteromethyle         =    20,  ///< trideuteromethylation of E
    eMSMod_ctermpeptrideuteromethyl  =    21,  ///< C terminal trideuteromethylation
    eMSMod_nformylmet                =    22,
    eMSMod_twoamino3oxobutanoicacid  =    23,
    eMSMod_acetylk                   =    24,
    eMSMod_ctermamide                =    25,
    eMSMod_bmethylthiold             =    26,
    eMSMod_carbamidomethylk          =    27,
    eMSMod_carbamidometylh           =    28,
    eMSMod_carbamidomethyld          =    29,
    eMSMod_carbamidomethyle          =    30,
    eMSMod_carbamylk                 =    31,
    eMSMod_ntermcarbamyl             =    32,
    eMSMod_citrullinationr           =    33,
    eMSMod_cysteicacidc              =    34,
    eMSMod_diiodinationy             =    35,
    eMSMod_dimethylk                 =    36,
    eMSMod_dimethylr                 =    37,
    eMSMod_ntermpepdimethyl          =    38,
    eMSMod_dihydroxyf                =    39,
    eMSMod_thioacetylk               =    40,
    eMSMod_ntermpeptioacetyl         =    41,
    eMSMod_farnesylationc            =    42,
    eMSMod_formylk                   =    43,
    eMSMod_ntermpepformyl            =    44,
    eMSMod_formylkynureninw          =    45,
    eMSMod_phef                      =    46,
    eMSMod_gammacarboxyld            =    47,
    eMSMod_gammacarboxyle            =    48,
    eMSMod_geranylgeranylc           =    49,
    eMSMod_ntermpepglucuronylg       =    50,
    eMSMod_glutathionec              =    51,
    eMSMod_glyglyk                   =    52,
    eMSMod_guanidinationk            =    53,
    eMSMod_his2asnh                  =    54,
    eMSMod_his2asph                  =    55,
    eMSMod_ctermpephsem              =    56,
    eMSMod_ctermpephselactm          =    57,
    eMSMod_hydroxykynureninw         =    58,
    eMSMod_hydroxylationd            =    59,
    eMSMod_hydroxylationk            =    60,
    eMSMod_hydroxylationn            =    61,
    eMSMod_hydroxylationp            =    62,
    eMSMod_hydroxylationf            =    63,
    eMSMod_hydroxylationy            =    64,
    eMSMod_iodinationy               =    65,
    eMSMod_kynureninw                =    66,
    eMSMod_lipoylk                   =    67,
    eMSMod_ctermpepmeester           =    68,
    eMSMod_meesterd                  =    69,
    eMSMod_meestere                  =    70,
    eMSMod_meesters                  =    71,
    eMSMod_meestery                  =    72,
    eMSMod_methylc                   =    73,
    eMSMod_methylh                   =    74,
    eMSMod_methyln                   =    75,
    eMSMod_ntermpepmethyl            =    76,
    eMSMod_methylr                   =    77,
    eMSMod_ntermpepmyristoyeylationg =    78,
    eMSMod_ntermpepmyristoyl4hg      =    79,
    eMSMod_ntermpepmyristoylationg   =    80,
    eMSMod_myristoylationk           =    81,
    eMSMod_ntermformyl               =    82,
    eMSMod_nemc                      =    83,
    eMSMod_nipcam                    =    84,
    eMSMod_nitrow                    =    85,
    eMSMod_nitroy                    =    86,
    eMSMod_ctermpepo18               =    87,
    eMSMod_ctermpepdio18             =    88,
    eMSMod_oxyh                      =    89,
    eMSMod_oxyw                      =    90,
    eMSMod_ppantetheines             =    91,
    eMSMod_palmitoylationc           =    92,
    eMSMod_palmitoylationk           =    93,
    eMSMod_palmitoylations           =    94,
    eMSMod_palmitoylationt           =    95,
    eMSMod_phospholosss              =    96,
    eMSMod_phospholosst              =    97,
    eMSMod_phospholossy              =    98,
    eMSMod_phosphoneutrallossc       =    99,
    eMSMod_phosphoneutrallossd       =   100,
    eMSMod_phosphoneutrallossh       =   101,
    eMSMod_propionylk                =   102,
    eMSMod_ntermpeppropionyl         =   103,
    eMSMod_propionylheavyk           =   104,
    eMSMod_ntermpeppropionylheavy    =   105,
    eMSMod_pyridylk                  =   106,
    eMSMod_ntermpeppyridyl           =   107,
    eMSMod_ntermpeppyrocmc           =   108,
    eMSMod_ntermpeppyroe             =   109,
    eMSMod_ntermpeppyroq             =   110,
    eMSMod_pyroglutamicp             =   111,
    eMSMod_spyridylethylc            =   112,
    eMSMod_semetm                    =   113,
    eMSMod_sulfationy                =   114,
    eMSMod_suphonem                  =   115,
    eMSMod_triiodinationy            =   116,
    eMSMod_trimethylationr           =   117,
    eMSMod_ntermpeptripalmitatec     =   118,
    eMSMod_usermod1                  =   119,  ///< start of user defined mods
    eMSMod_usermod2                  =   120,
    eMSMod_usermod3                  =   121,
    eMSMod_usermod4                  =   122,
    eMSMod_usermod5                  =   123,
    eMSMod_usermod6                  =   124,
    eMSMod_usermod7                  =   125,
    eMSMod_usermod8                  =   126,
    eMSMod_usermod9                  =   127,
    eMSMod_usermod10                 =   128,  ///< end of user defined mods
    eMSMod_icatlight                 =   129,
    eMSMod_icatheavy                 =   130,
    eMSMod_camthiopropanoylk         =   131,
    eMSMod_phosphoneutrallosss       =   132,
    eMSMod_phosphoneutrallosst       =   133,
    eMSMod_phosphoetdlosss           =   134,
    eMSMod_phosphoetdlosst           =   135,
    eMSMod_arg_13c6                  =   136,
    eMSMod_arg_13c6_15n4             =   137,
    eMSMod_lys_13c6                  =   138,
    eMSMod_oxy18                     =   139,
    eMSMod_beta_elim_s               =   140,
    eMSMod_beta_elim_t               =   141,
    eMSMod_usermod11                 =   142,
    eMSMod_usermod12                 =   143,
    eMSMod_usermod13                 =   144,
    eMSMod_usermod14                 =   145,
    eMSMod_usermod15                 =   146,
    eMSMod_usermod16                 =   147,
    eMSMod_usermod17                 =   148,
    eMSMod_usermod18                 =   149,
    eMSMod_usermod19                 =   150,
    eMSMod_usermod20                 =   151,
    eMSMod_usermod21                 =   152,
    eMSMod_usermod22                 =   153,
    eMSMod_usermod23                 =   154,
    eMSMod_usermod24                 =   155,
    eMSMod_usermod25                 =   156,
    eMSMod_usermod26                 =   157,
    eMSMod_usermod27                 =   158,
    eMSMod_usermod28                 =   159,
    eMSMod_usermod29                 =   160,
    eMSMod_usermod30                 =   161,
    eMSMod_sulfinicacid              =   162,
    eMSMod_arg2orn                   =   163,
    eMSMod_dehydro                   =   164,
    eMSMod_carboxykynurenin          =   165,
    eMSMod_sumoylation               =   166,
    eMSMod_iTRAQ114nterm             =   167,
    eMSMod_iTRAQ114K                 =   168,
    eMSMod_iTRAQ114Y                 =   169,
    eMSMod_iTRAQ115nterm             =   170,
    eMSMod_iTRAQ115K                 =   171,
    eMSMod_iTRAQ115Y                 =   172,
    eMSMod_iTRAQ116nterm             =   173,
    eMSMod_iTRAQ116K                 =   174,
    eMSMod_iTRAQ116Y                 =   175,
    eMSMod_iTRAQ117nterm             =   176,
    eMSMod_iTRAQ117K                 =   177,
    eMSMod_iTRAQ117Y                 =   178,
    eMSMod_mmts                      =   179,
    eMSMod_lys_2H4                   =   180,
    eMSMod_lys_13C615N2              =   181,
    eMSMod_hexNAcN                   =   182,
    eMSMod_dHexHexNAcN               =   183,
    eMSMod_hexNAcS                   =   184,
    eMSMod_hexNAcT                   =   185,
    eMSMod_mod186                    =   186,
    eMSMod_mod187                    =   187,
    eMSMod_mod188                    =   188,
    eMSMod_mod189                    =   189,
    eMSMod_mod190                    =   190,
    eMSMod_mod191                    =   191,
    eMSMod_mod192                    =   192,
    eMSMod_mod193                    =   193,
    eMSMod_mod194                    =   194,
    eMSMod_mod195                    =   195,
    eMSMod_mod196                    =   196,
    eMSMod_mod197                    =   197,
    eMSMod_mod198                    =   198,
    eMSMod_mod199                    =   199,
    eMSMod_mod200                    =   200,
    eMSMod_mod201                    =   201,
    eMSMod_mod202                    =   202,
    eMSMod_mod203                    =   203,
    eMSMod_mod204                    =   204,
    eMSMod_mod205                    =   205,
    eMSMod_mod206                    =   206,
    eMSMod_mod207                    =   207,
    eMSMod_mod208                    =   208,
    eMSMod_mod209                    =   209,
    eMSMod_mod210                    =   210,
    eMSMod_mod211                    =   211,
    eMSMod_mod212                    =   212,
    eMSMod_mod213                    =   213,
    eMSMod_mod214                    =   214,
    eMSMod_mod215                    =   215,
    eMSMod_mod216                    =   216,
    eMSMod_mod217                    =   217,
    eMSMod_mod218                    =   218,
    eMSMod_mod219                    =   219,
    eMSMod_mod220                    =   220,
    eMSMod_mod221                    =   221,
    eMSMod_mod222                    =   222,
    eMSMod_mod223                    =   223,
    eMSMod_mod224                    =   224,
    eMSMod_mod225                    =   225,
    eMSMod_mod226                    =   226,
    eMSMod_mod227                    =   227,
    eMSMod_mod228                    =   228,
    eMSMod_mod229                    =   229,
    eMSMod_mod230                    =   230,
    eMSMod_max                       =   231,  ///< maximum number of mods
    eMSMod_unknown                   =  9999,  ///< modification of unknown type
    eMSMod_none                      = 10000
};

/// Access to EMSMod's attributes (values, names) as defined in spec
NCBI_OMSSA_EXPORT const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EMSMod)(void);


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_OMSSA_MSMOD_BASE_HPP
