/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MSScoreSet_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'omssa.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_OMSSA_MSSCORESET_BASE_HPP
#define OBJECTS_OMSSA_MSSCORESET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// sets of scores
class NCBI_OMSSA_EXPORT CMSScoreSet_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMSScoreSet_Base(void);
    // destructor
    virtual ~CMSScoreSet_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TName;
    typedef double TValue;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_name,
        e_value
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// mandatory
    /// typedef double TValue
    ///  Check whether the Value data member has been assigned a value.
    bool IsSetValue(void) const;
    /// Check whether it is safe or not to call GetValue method.
    bool CanGetValue(void) const;
    void ResetValue(void);
    TValue GetValue(void) const;
    void SetValue(TValue value);
    TValue& SetValue(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMSScoreSet_Base(const CMSScoreSet_Base&);
    CMSScoreSet_Base& operator=(const CMSScoreSet_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Name;
    double m_Value;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMSScoreSet_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMSScoreSet_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CMSScoreSet_Base::TName& CMSScoreSet_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(0);
    }
    return m_Name;
}

inline
void CMSScoreSet_Base::SetName(const CMSScoreSet_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x3;
}

inline
void CMSScoreSet_Base::SetName(CMSScoreSet_Base::TName&& value)
{
    m_Name = std::forward<CMSScoreSet_Base::TName>(value);
    m_set_State[0] |= 0x3;
}

inline
CMSScoreSet_Base::TName& CMSScoreSet_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Name;
}

inline
bool CMSScoreSet_Base::IsSetValue(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMSScoreSet_Base::CanGetValue(void) const
{
    return IsSetValue();
}

inline
void CMSScoreSet_Base::ResetValue(void)
{
    m_Value = 0;
    m_set_State[0] &= ~0xc;
}

inline
CMSScoreSet_Base::TValue CMSScoreSet_Base::GetValue(void) const
{
    if (!CanGetValue()) {
        ThrowUnassigned(1);
    }
    return m_Value;
}

inline
void CMSScoreSet_Base::SetValue(CMSScoreSet_Base::TValue value)
{
    m_Value = value;
    m_set_State[0] |= 0xc;
}

inline
CMSScoreSet_Base::TValue& CMSScoreSet_Base::SetValue(void)
{
#ifdef _DEBUG
    if (!IsSetValue()) {
        memset(&m_Value,UnassignedByte(),sizeof(m_Value));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Value;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_OMSSA_MSSCORESET_BASE_HPP
