/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MSSearch_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'omssa.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_OMSSA_MSSEARCH_BASE_HPP
#define OBJECTS_OMSSA_MSSEARCH_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CMSRequest;
class CMSResponse;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// holds both search requests and responses
class NCBI_OMSSA_EXPORT CMSSearch_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMSSearch_Base(void);
    // destructor
    virtual ~CMSSearch_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< CRef< CMSRequest > > TRequest;
    typedef list< CRef< CMSResponse > > TResponse;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_request,
        e_response
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// optional
    /// typedef list< CRef< CMSRequest > > TRequest
    ///  Check whether the Request data member has been assigned a value.
    bool IsSetRequest(void) const;
    /// Check whether it is safe or not to call GetRequest method.
    bool CanGetRequest(void) const;
    void ResetRequest(void);
    const TRequest& GetRequest(void) const;
    TRequest& SetRequest(void);

    /// optional
    /// typedef list< CRef< CMSResponse > > TResponse
    ///  Check whether the Response data member has been assigned a value.
    bool IsSetResponse(void) const;
    /// Check whether it is safe or not to call GetResponse method.
    bool CanGetResponse(void) const;
    void ResetResponse(void);
    const TResponse& GetResponse(void) const;
    TResponse& SetResponse(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMSSearch_Base(const CMSSearch_Base&);
    CMSSearch_Base& operator=(const CMSSearch_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CMSRequest > > m_Request;
    list< CRef< CMSResponse > > m_Response;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMSSearch_Base::IsSetRequest(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMSSearch_Base::CanGetRequest(void) const
{
    return true;
}

inline
const CMSSearch_Base::TRequest& CMSSearch_Base::GetRequest(void) const
{
    return m_Request;
}

inline
CMSSearch_Base::TRequest& CMSSearch_Base::SetRequest(void)
{
    m_set_State[0] |= 0x1;
    return m_Request;
}

inline
bool CMSSearch_Base::IsSetResponse(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMSSearch_Base::CanGetResponse(void) const
{
    return true;
}

inline
const CMSSearch_Base::TResponse& CMSSearch_Base::GetResponse(void) const
{
    return m_Response;
}

inline
CMSSearch_Base::TResponse& CMSSearch_Base::SetResponse(void)
{
    m_set_State[0] |= 0x4;
    return m_Response;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_OMSSA_MSSEARCH_BASE_HPP
