/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file MSSpectrum_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'omssa.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_OMSSA_MSSPECTRUM_BASE_HPP
#define OBJECTS_OMSSA_MSSPECTRUM_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CNameValue;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Holds a single spectrum
class NCBI_OMSSA_EXPORT CMSSpectrum_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMSSpectrum_Base(void);
    // destructor
    virtual ~CMSSpectrum_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TNumber;
    typedef list< int > TCharge;
    typedef int TPrecursormz;
    typedef vector< int > TMz;
    typedef vector< int > TAbundance;
    typedef double TIscale;
    typedef list< string > TIds;
    typedef list< CRef< CNameValue > > TNamevalue;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_number,
        e_charge,
        e_precursormz,
        e_mz,
        e_abundance,
        e_iscale,
        e_ids,
        e_namevalue
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 9> TmemberIndex;

    // getters
    // setters

    /// unique number of spectrum
    /// mandatory
    /// typedef int TNumber
    ///  Check whether the Number data member has been assigned a value.
    bool IsSetNumber(void) const;
    /// Check whether it is safe or not to call GetNumber method.
    bool CanGetNumber(void) const;
    void ResetNumber(void);
    TNumber GetNumber(void) const;
    void SetNumber(TNumber value);
    TNumber& SetNumber(void);

    /// may be more than one if unknown
    /// mandatory
    /// typedef list< int > TCharge
    ///  Check whether the Charge data member has been assigned a value.
    bool IsSetCharge(void) const;
    /// Check whether it is safe or not to call GetCharge method.
    bool CanGetCharge(void) const;
    void ResetCharge(void);
    const TCharge& GetCharge(void) const;
    TCharge& SetCharge(void);

    /// scaled precursor m/z, scale is in MSSearchSettings
    /// mandatory
    /// typedef int TPrecursormz
    ///  Check whether the Precursormz data member has been assigned a value.
    bool IsSetPrecursormz(void) const;
    /// Check whether it is safe or not to call GetPrecursormz method.
    bool CanGetPrecursormz(void) const;
    void ResetPrecursormz(void);
    TPrecursormz GetPrecursormz(void) const;
    void SetPrecursormz(TPrecursormz value);
    TPrecursormz& SetPrecursormz(void);

    /// scaled product m/z
    /// mandatory
    /// typedef vector< int > TMz
    ///  Check whether the Mz data member has been assigned a value.
    bool IsSetMz(void) const;
    /// Check whether it is safe or not to call GetMz method.
    bool CanGetMz(void) const;
    void ResetMz(void);
    const TMz& GetMz(void) const;
    TMz& SetMz(void);

    /// scaled product abundance
    /// mandatory
    /// typedef vector< int > TAbundance
    ///  Check whether the Abundance data member has been assigned a value.
    bool IsSetAbundance(void) const;
    /// Check whether it is safe or not to call GetAbundance method.
    bool CanGetAbundance(void) const;
    void ResetAbundance(void);
    const TAbundance& GetAbundance(void) const;
    TAbundance& SetAbundance(void);

    /// abundance scale, float to integer
    /// mandatory
    /// typedef double TIscale
    ///  Check whether the Iscale data member has been assigned a value.
    bool IsSetIscale(void) const;
    /// Check whether it is safe or not to call GetIscale method.
    bool CanGetIscale(void) const;
    void ResetIscale(void);
    TIscale GetIscale(void) const;
    void SetIscale(TIscale value);
    TIscale& SetIscale(void);

    /// ids/filenames
    /// optional
    /// typedef list< string > TIds
    ///  Check whether the Ids data member has been assigned a value.
    bool IsSetIds(void) const;
    /// Check whether it is safe or not to call GetIds method.
    bool CanGetIds(void) const;
    void ResetIds(void);
    const TIds& GetIds(void) const;
    TIds& SetIds(void);

    /// extra info: retention times, etc.
    /// optional
    /// typedef list< CRef< CNameValue > > TNamevalue
    ///  Check whether the Namevalue data member has been assigned a value.
    bool IsSetNamevalue(void) const;
    /// Check whether it is safe or not to call GetNamevalue method.
    bool CanGetNamevalue(void) const;
    void ResetNamevalue(void);
    const TNamevalue& GetNamevalue(void) const;
    TNamevalue& SetNamevalue(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMSSpectrum_Base(const CMSSpectrum_Base&);
    CMSSpectrum_Base& operator=(const CMSSpectrum_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Number;
    list< int > m_Charge;
    int m_Precursormz;
    vector< int > m_Mz;
    vector< int > m_Abundance;
    double m_Iscale;
    list< string > m_Ids;
    list< CRef< CNameValue > > m_Namevalue;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMSSpectrum_Base::IsSetNumber(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMSSpectrum_Base::CanGetNumber(void) const
{
    return IsSetNumber();
}

inline
void CMSSpectrum_Base::ResetNumber(void)
{
    m_Number = 0;
    m_set_State[0] &= ~0x3;
}

inline
CMSSpectrum_Base::TNumber CMSSpectrum_Base::GetNumber(void) const
{
    if (!CanGetNumber()) {
        ThrowUnassigned(0);
    }
    return m_Number;
}

inline
void CMSSpectrum_Base::SetNumber(CMSSpectrum_Base::TNumber value)
{
    m_Number = value;
    m_set_State[0] |= 0x3;
}

inline
CMSSpectrum_Base::TNumber& CMSSpectrum_Base::SetNumber(void)
{
#ifdef _DEBUG
    if (!IsSetNumber()) {
        memset(&m_Number,UnassignedByte(),sizeof(m_Number));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Number;
}

inline
bool CMSSpectrum_Base::IsSetCharge(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMSSpectrum_Base::CanGetCharge(void) const
{
    return true;
}

inline
const CMSSpectrum_Base::TCharge& CMSSpectrum_Base::GetCharge(void) const
{
    return m_Charge;
}

inline
CMSSpectrum_Base::TCharge& CMSSpectrum_Base::SetCharge(void)
{
    m_set_State[0] |= 0x4;
    return m_Charge;
}

inline
bool CMSSpectrum_Base::IsSetPrecursormz(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMSSpectrum_Base::CanGetPrecursormz(void) const
{
    return IsSetPrecursormz();
}

inline
void CMSSpectrum_Base::ResetPrecursormz(void)
{
    m_Precursormz = 0;
    m_set_State[0] &= ~0x30;
}

inline
CMSSpectrum_Base::TPrecursormz CMSSpectrum_Base::GetPrecursormz(void) const
{
    if (!CanGetPrecursormz()) {
        ThrowUnassigned(2);
    }
    return m_Precursormz;
}

inline
void CMSSpectrum_Base::SetPrecursormz(CMSSpectrum_Base::TPrecursormz value)
{
    m_Precursormz = value;
    m_set_State[0] |= 0x30;
}

inline
CMSSpectrum_Base::TPrecursormz& CMSSpectrum_Base::SetPrecursormz(void)
{
#ifdef _DEBUG
    if (!IsSetPrecursormz()) {
        memset(&m_Precursormz,UnassignedByte(),sizeof(m_Precursormz));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Precursormz;
}

inline
bool CMSSpectrum_Base::IsSetMz(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CMSSpectrum_Base::CanGetMz(void) const
{
    return true;
}

inline
const CMSSpectrum_Base::TMz& CMSSpectrum_Base::GetMz(void) const
{
    return m_Mz;
}

inline
CMSSpectrum_Base::TMz& CMSSpectrum_Base::SetMz(void)
{
    m_set_State[0] |= 0x40;
    return m_Mz;
}

inline
bool CMSSpectrum_Base::IsSetAbundance(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CMSSpectrum_Base::CanGetAbundance(void) const
{
    return true;
}

inline
const CMSSpectrum_Base::TAbundance& CMSSpectrum_Base::GetAbundance(void) const
{
    return m_Abundance;
}

inline
CMSSpectrum_Base::TAbundance& CMSSpectrum_Base::SetAbundance(void)
{
    m_set_State[0] |= 0x100;
    return m_Abundance;
}

inline
bool CMSSpectrum_Base::IsSetIscale(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CMSSpectrum_Base::CanGetIscale(void) const
{
    return IsSetIscale();
}

inline
void CMSSpectrum_Base::ResetIscale(void)
{
    m_Iscale = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CMSSpectrum_Base::TIscale CMSSpectrum_Base::GetIscale(void) const
{
    if (!CanGetIscale()) {
        ThrowUnassigned(5);
    }
    return m_Iscale;
}

inline
void CMSSpectrum_Base::SetIscale(CMSSpectrum_Base::TIscale value)
{
    m_Iscale = value;
    m_set_State[0] |= 0xc00;
}

inline
CMSSpectrum_Base::TIscale& CMSSpectrum_Base::SetIscale(void)
{
#ifdef _DEBUG
    if (!IsSetIscale()) {
        memset(&m_Iscale,UnassignedByte(),sizeof(m_Iscale));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Iscale;
}

inline
bool CMSSpectrum_Base::IsSetIds(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CMSSpectrum_Base::CanGetIds(void) const
{
    return true;
}

inline
const CMSSpectrum_Base::TIds& CMSSpectrum_Base::GetIds(void) const
{
    return m_Ids;
}

inline
CMSSpectrum_Base::TIds& CMSSpectrum_Base::SetIds(void)
{
    m_set_State[0] |= 0x1000;
    return m_Ids;
}

inline
bool CMSSpectrum_Base::IsSetNamevalue(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CMSSpectrum_Base::CanGetNamevalue(void) const
{
    return true;
}

inline
const CMSSpectrum_Base::TNamevalue& CMSSpectrum_Base::GetNamevalue(void) const
{
    return m_Namevalue;
}

inline
CMSSpectrum_Base::TNamevalue& CMSSpectrum_Base::SetNamevalue(void)
{
    m_set_State[0] |= 0x4000;
    return m_Namevalue;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_OMSSA_MSSPECTRUM_BASE_HPP
