/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_AssayPanelTestResult_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcassay.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCASSAY_PC_ASSAYPANELTESTRESULT_BASE_HPP
#define OBJECTS_PCASSAY_PC_ASSAYPANELTESTRESULT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_PCASSAY_EXPORT CPC_AssayPanelTestResult_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_AssayPanelTestResult_Base(void);
    // destructor
    virtual ~CPC_AssayPanelTestResult_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EReadout_annot {
        eReadout_annot_regular = 1,  ///< to indicate this TID column is a regular readout
        eReadout_annot_outcome = 2,  ///< to indicate this TID column is  "outcome" of the particular panel member
        eReadout_annot_score   = 3,  ///< to indicate this TID column reports activity score of the particular panel member  to be used for neighboring assays
        eReadout_annot_ac      = 4  ///< to indicate this TID column is "active concentration"     'outcome' and 'ac' type of TID are to be used for data analysis   across members of panel  or across multiple assays including other panel assays
    };
    
    /// Access to EReadout_annot's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EReadout_annot)(void);
    
    // types
    typedef int TMid;
    typedef int TReadout_annot;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_mid,
        e_readout_annot
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// panel member ID, see PC-AssayPanelMemberInfo
    /// track association between a group of TIDs and panel member
    /// mandatory
    /// typedef int TMid
    ///  Check whether the Mid data member has been assigned a value.
    bool IsSetMid(void) const;
    /// Check whether it is safe or not to call GetMid method.
    bool CanGetMid(void) const;
    void ResetMid(void);
    TMid GetMid(void) const;
    void SetMid(TMid value);
    TMid& SetMid(void);

    /// optional with default eReadout_annot_regular
    /// typedef int TReadout_annot
    ///  Check whether the Readout_annot data member has been assigned a value.
    bool IsSetReadout_annot(void) const;
    /// Check whether it is safe or not to call GetReadout_annot method.
    bool CanGetReadout_annot(void) const;
    void ResetReadout_annot(void);
    void SetDefaultReadout_annot(void);
    TReadout_annot GetReadout_annot(void) const;
    void SetReadout_annot(TReadout_annot value);
    TReadout_annot& SetReadout_annot(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_AssayPanelTestResult_Base(const CPC_AssayPanelTestResult_Base&);
    CPC_AssayPanelTestResult_Base& operator=(const CPC_AssayPanelTestResult_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Mid;
    int m_Readout_annot;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_AssayPanelTestResult_Base::IsSetMid(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_AssayPanelTestResult_Base::CanGetMid(void) const
{
    return IsSetMid();
}

inline
void CPC_AssayPanelTestResult_Base::ResetMid(void)
{
    m_Mid = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPC_AssayPanelTestResult_Base::TMid CPC_AssayPanelTestResult_Base::GetMid(void) const
{
    if (!CanGetMid()) {
        ThrowUnassigned(0);
    }
    return m_Mid;
}

inline
void CPC_AssayPanelTestResult_Base::SetMid(CPC_AssayPanelTestResult_Base::TMid value)
{
    m_Mid = value;
    m_set_State[0] |= 0x3;
}

inline
CPC_AssayPanelTestResult_Base::TMid& CPC_AssayPanelTestResult_Base::SetMid(void)
{
#ifdef _DEBUG
    if (!IsSetMid()) {
        memset(&m_Mid,UnassignedByte(),sizeof(m_Mid));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Mid;
}

inline
bool CPC_AssayPanelTestResult_Base::IsSetReadout_annot(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_AssayPanelTestResult_Base::CanGetReadout_annot(void) const
{
    return true;
}

inline
void CPC_AssayPanelTestResult_Base::ResetReadout_annot(void)
{
    m_Readout_annot = eReadout_annot_regular;
    m_set_State[0] &= ~0xc;
}

inline
void CPC_AssayPanelTestResult_Base::SetDefaultReadout_annot(void)
{
    ResetReadout_annot();
}

inline
CPC_AssayPanelTestResult_Base::TReadout_annot CPC_AssayPanelTestResult_Base::GetReadout_annot(void) const
{
    return m_Readout_annot;
}

inline
void CPC_AssayPanelTestResult_Base::SetReadout_annot(CPC_AssayPanelTestResult_Base::TReadout_annot value)
{
    m_Readout_annot = value;
    m_set_State[0] |= 0xc;
}

inline
CPC_AssayPanelTestResult_Base::TReadout_annot& CPC_AssayPanelTestResult_Base::SetReadout_annot(void)
{
#ifdef _DEBUG
    if (!IsSetReadout_annot()) {
        memset(&m_Readout_annot,UnassignedByte(),sizeof(m_Readout_annot));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Readout_annot;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCASSAY_PC_ASSAYPANELTESTRESULT_BASE_HPP
