/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_ConcentrationAttr_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcassay2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCASSAY2_PC_CONCENTRATIONATTR_BASE_HPP
#define OBJECTS_PCASSAY2_PC_CONCENTRATIONATTR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::

#ifndef BEGIN_pcassay2_SCOPE
#  define BEGIN_pcassay2_SCOPE BEGIN_SCOPE(pcassay2)
#  define END_pcassay2_SCOPE END_SCOPE(pcassay2)
#endif
BEGIN_pcassay2_SCOPE // namespace ncbi::objects::pcassay2::


// generated classes

/////////////////////////////////////////////////////////////////////////////
///The concentration attribute is to indicate that the readout under this test result field is biological concentration-response data, the attribute provides the value and unit of the tested concentration
class CPC_ConcentrationAttr_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_ConcentrationAttr_Base(void);
    // destructor
    virtual ~CPC_ConcentrationAttr_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// Units for Concentration
    enum EUnit {
        eUnit_um = 5  ///< microM
    };
    
    /// Access to EUnit's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EUnit)(void);
    
    // types
    typedef double TConcentration;
    typedef int TUnit;
    typedef int TDr_id;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_concentration,
        e_unit,
        e_dr_id
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef double TConcentration
    ///  Check whether the Concentration data member has been assigned a value.
    bool IsSetConcentration(void) const;
    /// Check whether it is safe or not to call GetConcentration method.
    bool CanGetConcentration(void) const;
    void ResetConcentration(void);
    TConcentration GetConcentration(void) const;
    void SetConcentration(TConcentration value);
    TConcentration& SetConcentration(void);

    /// mandatory
    /// typedef int TUnit
    ///  Check whether the Unit data member has been assigned a value.
    bool IsSetUnit(void) const;
    /// Check whether it is safe or not to call GetUnit method.
    bool CanGetUnit(void) const;
    void ResetUnit(void);
    TUnit GetUnit(void) const;
    void SetUnit(TUnit value);
    TUnit& SetUnit(void);

    /// Dose-Response Attribution ID (if applicable)
    /// optional
    /// typedef int TDr_id
    ///  Check whether the Dr_id data member has been assigned a value.
    bool IsSetDr_id(void) const;
    /// Check whether it is safe or not to call GetDr_id method.
    bool CanGetDr_id(void) const;
    void ResetDr_id(void);
    TDr_id GetDr_id(void) const;
    void SetDr_id(TDr_id value);
    TDr_id& SetDr_id(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_ConcentrationAttr_Base(const CPC_ConcentrationAttr_Base&);
    CPC_ConcentrationAttr_Base& operator=(const CPC_ConcentrationAttr_Base&);

    // data
    Uint4 m_set_State[1];
    double m_Concentration;
    int m_Unit;
    int m_Dr_id;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_ConcentrationAttr_Base::IsSetConcentration(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_ConcentrationAttr_Base::CanGetConcentration(void) const
{
    return IsSetConcentration();
}

inline
void CPC_ConcentrationAttr_Base::ResetConcentration(void)
{
    m_Concentration = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPC_ConcentrationAttr_Base::TConcentration CPC_ConcentrationAttr_Base::GetConcentration(void) const
{
    if (!CanGetConcentration()) {
        ThrowUnassigned(0);
    }
    return m_Concentration;
}

inline
void CPC_ConcentrationAttr_Base::SetConcentration(CPC_ConcentrationAttr_Base::TConcentration value)
{
    m_Concentration = value;
    m_set_State[0] |= 0x3;
}

inline
CPC_ConcentrationAttr_Base::TConcentration& CPC_ConcentrationAttr_Base::SetConcentration(void)
{
#ifdef _DEBUG
    if (!IsSetConcentration()) {
        memset(&m_Concentration,UnassignedByte(),sizeof(m_Concentration));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Concentration;
}

inline
bool CPC_ConcentrationAttr_Base::IsSetUnit(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_ConcentrationAttr_Base::CanGetUnit(void) const
{
    return IsSetUnit();
}

inline
void CPC_ConcentrationAttr_Base::ResetUnit(void)
{
    m_Unit = (EUnit)(0);
    m_set_State[0] &= ~0xc;
}

inline
CPC_ConcentrationAttr_Base::TUnit CPC_ConcentrationAttr_Base::GetUnit(void) const
{
    if (!CanGetUnit()) {
        ThrowUnassigned(1);
    }
    return m_Unit;
}

inline
void CPC_ConcentrationAttr_Base::SetUnit(CPC_ConcentrationAttr_Base::TUnit value)
{
    m_Unit = value;
    m_set_State[0] |= 0xc;
}

inline
CPC_ConcentrationAttr_Base::TUnit& CPC_ConcentrationAttr_Base::SetUnit(void)
{
#ifdef _DEBUG
    if (!IsSetUnit()) {
        memset(&m_Unit,UnassignedByte(),sizeof(m_Unit));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Unit;
}

inline
bool CPC_ConcentrationAttr_Base::IsSetDr_id(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPC_ConcentrationAttr_Base::CanGetDr_id(void) const
{
    return IsSetDr_id();
}

inline
void CPC_ConcentrationAttr_Base::ResetDr_id(void)
{
    m_Dr_id = 0;
    m_set_State[0] &= ~0x30;
}

inline
CPC_ConcentrationAttr_Base::TDr_id CPC_ConcentrationAttr_Base::GetDr_id(void) const
{
    if (!CanGetDr_id()) {
        ThrowUnassigned(2);
    }
    return m_Dr_id;
}

inline
void CPC_ConcentrationAttr_Base::SetDr_id(CPC_ConcentrationAttr_Base::TDr_id value)
{
    m_Dr_id = value;
    m_set_State[0] |= 0x30;
}

inline
CPC_ConcentrationAttr_Base::TDr_id& CPC_ConcentrationAttr_Base::SetDr_id(void)
{
#ifdef _DEBUG
    if (!IsSetDr_id()) {
        memset(&m_Dr_id,UnassignedByte(),sizeof(m_Dr_id));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Dr_id;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_pcassay2_SCOPE // namespace ncbi::objects::pcassay2::

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCASSAY2_PC_CONCENTRATIONATTR_BASE_HPP
