/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_CoordinateType_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_COORDINATETYPE_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_COORDINATETYPE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/// Coordinate Set Type Distinctions
enum EPC_CoordinateType {
    ePC_CoordinateType_twod             =   1,  ///< 2D Coordinates
    ePC_CoordinateType_threed           =   2,  ///< 3D Coordinates (should also indicate units, below)
    ePC_CoordinateType_submitted        =   3,  ///< Depositor Provided Coordinates
    ePC_CoordinateType_experimental     =   4,  ///< Experimentally Determined Coordinates
    ePC_CoordinateType_computed         =   5,  ///< Computed Coordinates
    ePC_CoordinateType_standardized     =   6,  ///< Standardized Coordinates
    ePC_CoordinateType_augmented        =   7,  ///< Hybrid Original with Computed Coordinates (e.g., explicit H)
    ePC_CoordinateType_aligned          =   8,  ///< Template used to align drawing
    ePC_CoordinateType_compact          =   9,  ///< Drawing uses shorthand forms (e.g., COOH, OCH3, Et, etc.)
    ePC_CoordinateType_units_angstroms  =  10,  ///< (3D) Coordinate units are Angstroms
    ePC_CoordinateType_units_nanometers =  11,  ///< (3D) Coordinate units are nanometers
    ePC_CoordinateType_units_pixel      =  12,  ///< (2D) Coordinate units are pixels
    ePC_CoordinateType_units_points     =  13,  ///< (2D) Coordinate units are points
    ePC_CoordinateType_units_stdbonds   =  14,  ///< (2D) Coordinate units are standard bond lengths (1.0)
    ePC_CoordinateType_units_unknown    = 255  ///< Coordinate units are unknown or unspecified
};

/// Access to EPC_CoordinateType's attributes (values, names) as defined in spec
NCBI_PCSUBSTANCE_EXPORT const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EPC_CoordinateType)(void);


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_COORDINATETYPE_BASE_HPP
