/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_Count_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_COUNT_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_COUNT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Counts of various properties of a Compound
class NCBI_PCSUBSTANCE_EXPORT CPC_Count_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_Count_Base(void);
    // destructor
    virtual ~CPC_Count_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int THeavy_atom;
    typedef int TAtom_chiral;
    typedef int TAtom_chiral_def;
    typedef int TAtom_chiral_undef;
    typedef int TBond_chiral;
    typedef int TBond_chiral_def;
    typedef int TBond_chiral_undef;
    typedef int TIsotope_atom;
    typedef int TCovalent_unit;
    typedef int TTautomers;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_heavy_atom,
        e_atom_chiral,
        e_atom_chiral_def,
        e_atom_chiral_undef,
        e_bond_chiral,
        e_bond_chiral_def,
        e_bond_chiral_undef,
        e_isotope_atom,
        e_covalent_unit,
        e_tautomers
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 11> TmemberIndex;

    // getters
    // setters

    /// Total count of non-Hydrogen (Heavy) Atoms
    /// mandatory
    /// typedef int THeavy_atom
    ///  Check whether the Heavy_atom data member has been assigned a value.
    bool IsSetHeavy_atom(void) const;
    /// Check whether it is safe or not to call GetHeavy_atom method.
    bool CanGetHeavy_atom(void) const;
    void ResetHeavy_atom(void);
    THeavy_atom GetHeavy_atom(void) const;
    void SetHeavy_atom(THeavy_atom value);
    THeavy_atom& SetHeavy_atom(void);

    /// StereoChemistry Counts
    /// Total count of (SP3) Chiral Atoms
    /// mandatory
    /// typedef int TAtom_chiral
    ///  Check whether the Atom_chiral data member has been assigned a value.
    bool IsSetAtom_chiral(void) const;
    /// Check whether it is safe or not to call GetAtom_chiral method.
    bool CanGetAtom_chiral(void) const;
    void ResetAtom_chiral(void);
    TAtom_chiral GetAtom_chiral(void) const;
    void SetAtom_chiral(TAtom_chiral value);
    TAtom_chiral& SetAtom_chiral(void);

    /// Total count of Defined (SP3) Chiral Atoms
    /// mandatory
    /// typedef int TAtom_chiral_def
    ///  Check whether the Atom_chiral_def data member has been assigned a value.
    bool IsSetAtom_chiral_def(void) const;
    /// Check whether it is safe or not to call GetAtom_chiral_def method.
    bool CanGetAtom_chiral_def(void) const;
    void ResetAtom_chiral_def(void);
    TAtom_chiral_def GetAtom_chiral_def(void) const;
    void SetAtom_chiral_def(TAtom_chiral_def value);
    TAtom_chiral_def& SetAtom_chiral_def(void);

    /// Total count of Undefined (SP3) Chiral Atoms
    /// mandatory
    /// typedef int TAtom_chiral_undef
    ///  Check whether the Atom_chiral_undef data member has been assigned a value.
    bool IsSetAtom_chiral_undef(void) const;
    /// Check whether it is safe or not to call GetAtom_chiral_undef method.
    bool CanGetAtom_chiral_undef(void) const;
    void ResetAtom_chiral_undef(void);
    TAtom_chiral_undef GetAtom_chiral_undef(void) const;
    void SetAtom_chiral_undef(TAtom_chiral_undef value);
    TAtom_chiral_undef& SetAtom_chiral_undef(void);

    /// Total count of (SP2) Chiral Bonds
    /// mandatory
    /// typedef int TBond_chiral
    ///  Check whether the Bond_chiral data member has been assigned a value.
    bool IsSetBond_chiral(void) const;
    /// Check whether it is safe or not to call GetBond_chiral method.
    bool CanGetBond_chiral(void) const;
    void ResetBond_chiral(void);
    TBond_chiral GetBond_chiral(void) const;
    void SetBond_chiral(TBond_chiral value);
    TBond_chiral& SetBond_chiral(void);

    /// Total count of (SP2) Defined Chiral Bonds
    /// mandatory
    /// typedef int TBond_chiral_def
    ///  Check whether the Bond_chiral_def data member has been assigned a value.
    bool IsSetBond_chiral_def(void) const;
    /// Check whether it is safe or not to call GetBond_chiral_def method.
    bool CanGetBond_chiral_def(void) const;
    void ResetBond_chiral_def(void);
    TBond_chiral_def GetBond_chiral_def(void) const;
    void SetBond_chiral_def(TBond_chiral_def value);
    TBond_chiral_def& SetBond_chiral_def(void);

    /// Total count of (SP2) Undefined Chiral Bonds
    /// mandatory
    /// typedef int TBond_chiral_undef
    ///  Check whether the Bond_chiral_undef data member has been assigned a value.
    bool IsSetBond_chiral_undef(void) const;
    /// Check whether it is safe or not to call GetBond_chiral_undef method.
    bool CanGetBond_chiral_undef(void) const;
    void ResetBond_chiral_undef(void);
    TBond_chiral_undef GetBond_chiral_undef(void) const;
    void SetBond_chiral_undef(TBond_chiral_undef value);
    TBond_chiral_undef& SetBond_chiral_undef(void);

    /// Isotopic Counts
    /// Total count of Atoms with Isotopic Information
    /// mandatory
    /// typedef int TIsotope_atom
    ///  Check whether the Isotope_atom data member has been assigned a value.
    bool IsSetIsotope_atom(void) const;
    /// Check whether it is safe or not to call GetIsotope_atom method.
    bool CanGetIsotope_atom(void) const;
    void ResetIsotope_atom(void);
    TIsotope_atom GetIsotope_atom(void) const;
    void SetIsotope_atom(TIsotope_atom value);
    TIsotope_atom& SetIsotope_atom(void);

    /// Discrete Structure Counts
    /// Total count of covalently-bonded units in the record
    /// mandatory
    /// typedef int TCovalent_unit
    ///  Check whether the Covalent_unit data member has been assigned a value.
    bool IsSetCovalent_unit(void) const;
    /// Check whether it is safe or not to call GetCovalent_unit method.
    bool CanGetCovalent_unit(void) const;
    void ResetCovalent_unit(void);
    TCovalent_unit GetCovalent_unit(void) const;
    void SetCovalent_unit(TCovalent_unit value);
    TCovalent_unit& SetCovalent_unit(void);

    /// Number of possible tautomers (Max. 999)
    /// mandatory
    /// typedef int TTautomers
    ///  Check whether the Tautomers data member has been assigned a value.
    bool IsSetTautomers(void) const;
    /// Check whether it is safe or not to call GetTautomers method.
    bool CanGetTautomers(void) const;
    void ResetTautomers(void);
    TTautomers GetTautomers(void) const;
    void SetTautomers(TTautomers value);
    TTautomers& SetTautomers(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_Count_Base(const CPC_Count_Base&);
    CPC_Count_Base& operator=(const CPC_Count_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Heavy_atom;
    int m_Atom_chiral;
    int m_Atom_chiral_def;
    int m_Atom_chiral_undef;
    int m_Bond_chiral;
    int m_Bond_chiral_def;
    int m_Bond_chiral_undef;
    int m_Isotope_atom;
    int m_Covalent_unit;
    int m_Tautomers;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_Count_Base::IsSetHeavy_atom(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_Count_Base::CanGetHeavy_atom(void) const
{
    return IsSetHeavy_atom();
}

inline
void CPC_Count_Base::ResetHeavy_atom(void)
{
    m_Heavy_atom = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPC_Count_Base::THeavy_atom CPC_Count_Base::GetHeavy_atom(void) const
{
    if (!CanGetHeavy_atom()) {
        ThrowUnassigned(0);
    }
    return m_Heavy_atom;
}

inline
void CPC_Count_Base::SetHeavy_atom(CPC_Count_Base::THeavy_atom value)
{
    m_Heavy_atom = value;
    m_set_State[0] |= 0x3;
}

inline
CPC_Count_Base::THeavy_atom& CPC_Count_Base::SetHeavy_atom(void)
{
#ifdef _DEBUG
    if (!IsSetHeavy_atom()) {
        memset(&m_Heavy_atom,UnassignedByte(),sizeof(m_Heavy_atom));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Heavy_atom;
}

inline
bool CPC_Count_Base::IsSetAtom_chiral(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_Count_Base::CanGetAtom_chiral(void) const
{
    return IsSetAtom_chiral();
}

inline
void CPC_Count_Base::ResetAtom_chiral(void)
{
    m_Atom_chiral = 0;
    m_set_State[0] &= ~0xc;
}

inline
CPC_Count_Base::TAtom_chiral CPC_Count_Base::GetAtom_chiral(void) const
{
    if (!CanGetAtom_chiral()) {
        ThrowUnassigned(1);
    }
    return m_Atom_chiral;
}

inline
void CPC_Count_Base::SetAtom_chiral(CPC_Count_Base::TAtom_chiral value)
{
    m_Atom_chiral = value;
    m_set_State[0] |= 0xc;
}

inline
CPC_Count_Base::TAtom_chiral& CPC_Count_Base::SetAtom_chiral(void)
{
#ifdef _DEBUG
    if (!IsSetAtom_chiral()) {
        memset(&m_Atom_chiral,UnassignedByte(),sizeof(m_Atom_chiral));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Atom_chiral;
}

inline
bool CPC_Count_Base::IsSetAtom_chiral_def(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPC_Count_Base::CanGetAtom_chiral_def(void) const
{
    return IsSetAtom_chiral_def();
}

inline
void CPC_Count_Base::ResetAtom_chiral_def(void)
{
    m_Atom_chiral_def = 0;
    m_set_State[0] &= ~0x30;
}

inline
CPC_Count_Base::TAtom_chiral_def CPC_Count_Base::GetAtom_chiral_def(void) const
{
    if (!CanGetAtom_chiral_def()) {
        ThrowUnassigned(2);
    }
    return m_Atom_chiral_def;
}

inline
void CPC_Count_Base::SetAtom_chiral_def(CPC_Count_Base::TAtom_chiral_def value)
{
    m_Atom_chiral_def = value;
    m_set_State[0] |= 0x30;
}

inline
CPC_Count_Base::TAtom_chiral_def& CPC_Count_Base::SetAtom_chiral_def(void)
{
#ifdef _DEBUG
    if (!IsSetAtom_chiral_def()) {
        memset(&m_Atom_chiral_def,UnassignedByte(),sizeof(m_Atom_chiral_def));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Atom_chiral_def;
}

inline
bool CPC_Count_Base::IsSetAtom_chiral_undef(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPC_Count_Base::CanGetAtom_chiral_undef(void) const
{
    return IsSetAtom_chiral_undef();
}

inline
void CPC_Count_Base::ResetAtom_chiral_undef(void)
{
    m_Atom_chiral_undef = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CPC_Count_Base::TAtom_chiral_undef CPC_Count_Base::GetAtom_chiral_undef(void) const
{
    if (!CanGetAtom_chiral_undef()) {
        ThrowUnassigned(3);
    }
    return m_Atom_chiral_undef;
}

inline
void CPC_Count_Base::SetAtom_chiral_undef(CPC_Count_Base::TAtom_chiral_undef value)
{
    m_Atom_chiral_undef = value;
    m_set_State[0] |= 0xc0;
}

inline
CPC_Count_Base::TAtom_chiral_undef& CPC_Count_Base::SetAtom_chiral_undef(void)
{
#ifdef _DEBUG
    if (!IsSetAtom_chiral_undef()) {
        memset(&m_Atom_chiral_undef,UnassignedByte(),sizeof(m_Atom_chiral_undef));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Atom_chiral_undef;
}

inline
bool CPC_Count_Base::IsSetBond_chiral(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPC_Count_Base::CanGetBond_chiral(void) const
{
    return IsSetBond_chiral();
}

inline
void CPC_Count_Base::ResetBond_chiral(void)
{
    m_Bond_chiral = 0;
    m_set_State[0] &= ~0x300;
}

inline
CPC_Count_Base::TBond_chiral CPC_Count_Base::GetBond_chiral(void) const
{
    if (!CanGetBond_chiral()) {
        ThrowUnassigned(4);
    }
    return m_Bond_chiral;
}

inline
void CPC_Count_Base::SetBond_chiral(CPC_Count_Base::TBond_chiral value)
{
    m_Bond_chiral = value;
    m_set_State[0] |= 0x300;
}

inline
CPC_Count_Base::TBond_chiral& CPC_Count_Base::SetBond_chiral(void)
{
#ifdef _DEBUG
    if (!IsSetBond_chiral()) {
        memset(&m_Bond_chiral,UnassignedByte(),sizeof(m_Bond_chiral));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Bond_chiral;
}

inline
bool CPC_Count_Base::IsSetBond_chiral_def(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CPC_Count_Base::CanGetBond_chiral_def(void) const
{
    return IsSetBond_chiral_def();
}

inline
void CPC_Count_Base::ResetBond_chiral_def(void)
{
    m_Bond_chiral_def = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CPC_Count_Base::TBond_chiral_def CPC_Count_Base::GetBond_chiral_def(void) const
{
    if (!CanGetBond_chiral_def()) {
        ThrowUnassigned(5);
    }
    return m_Bond_chiral_def;
}

inline
void CPC_Count_Base::SetBond_chiral_def(CPC_Count_Base::TBond_chiral_def value)
{
    m_Bond_chiral_def = value;
    m_set_State[0] |= 0xc00;
}

inline
CPC_Count_Base::TBond_chiral_def& CPC_Count_Base::SetBond_chiral_def(void)
{
#ifdef _DEBUG
    if (!IsSetBond_chiral_def()) {
        memset(&m_Bond_chiral_def,UnassignedByte(),sizeof(m_Bond_chiral_def));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Bond_chiral_def;
}

inline
bool CPC_Count_Base::IsSetBond_chiral_undef(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CPC_Count_Base::CanGetBond_chiral_undef(void) const
{
    return IsSetBond_chiral_undef();
}

inline
void CPC_Count_Base::ResetBond_chiral_undef(void)
{
    m_Bond_chiral_undef = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CPC_Count_Base::TBond_chiral_undef CPC_Count_Base::GetBond_chiral_undef(void) const
{
    if (!CanGetBond_chiral_undef()) {
        ThrowUnassigned(6);
    }
    return m_Bond_chiral_undef;
}

inline
void CPC_Count_Base::SetBond_chiral_undef(CPC_Count_Base::TBond_chiral_undef value)
{
    m_Bond_chiral_undef = value;
    m_set_State[0] |= 0x3000;
}

inline
CPC_Count_Base::TBond_chiral_undef& CPC_Count_Base::SetBond_chiral_undef(void)
{
#ifdef _DEBUG
    if (!IsSetBond_chiral_undef()) {
        memset(&m_Bond_chiral_undef,UnassignedByte(),sizeof(m_Bond_chiral_undef));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Bond_chiral_undef;
}

inline
bool CPC_Count_Base::IsSetIsotope_atom(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CPC_Count_Base::CanGetIsotope_atom(void) const
{
    return IsSetIsotope_atom();
}

inline
void CPC_Count_Base::ResetIsotope_atom(void)
{
    m_Isotope_atom = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CPC_Count_Base::TIsotope_atom CPC_Count_Base::GetIsotope_atom(void) const
{
    if (!CanGetIsotope_atom()) {
        ThrowUnassigned(7);
    }
    return m_Isotope_atom;
}

inline
void CPC_Count_Base::SetIsotope_atom(CPC_Count_Base::TIsotope_atom value)
{
    m_Isotope_atom = value;
    m_set_State[0] |= 0xc000;
}

inline
CPC_Count_Base::TIsotope_atom& CPC_Count_Base::SetIsotope_atom(void)
{
#ifdef _DEBUG
    if (!IsSetIsotope_atom()) {
        memset(&m_Isotope_atom,UnassignedByte(),sizeof(m_Isotope_atom));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Isotope_atom;
}

inline
bool CPC_Count_Base::IsSetCovalent_unit(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CPC_Count_Base::CanGetCovalent_unit(void) const
{
    return IsSetCovalent_unit();
}

inline
void CPC_Count_Base::ResetCovalent_unit(void)
{
    m_Covalent_unit = 0;
    m_set_State[0] &= ~0x30000;
}

inline
CPC_Count_Base::TCovalent_unit CPC_Count_Base::GetCovalent_unit(void) const
{
    if (!CanGetCovalent_unit()) {
        ThrowUnassigned(8);
    }
    return m_Covalent_unit;
}

inline
void CPC_Count_Base::SetCovalent_unit(CPC_Count_Base::TCovalent_unit value)
{
    m_Covalent_unit = value;
    m_set_State[0] |= 0x30000;
}

inline
CPC_Count_Base::TCovalent_unit& CPC_Count_Base::SetCovalent_unit(void)
{
#ifdef _DEBUG
    if (!IsSetCovalent_unit()) {
        memset(&m_Covalent_unit,UnassignedByte(),sizeof(m_Covalent_unit));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Covalent_unit;
}

inline
bool CPC_Count_Base::IsSetTautomers(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CPC_Count_Base::CanGetTautomers(void) const
{
    return IsSetTautomers();
}

inline
void CPC_Count_Base::ResetTautomers(void)
{
    m_Tautomers = 0;
    m_set_State[0] &= ~0xc0000;
}

inline
CPC_Count_Base::TTautomers CPC_Count_Base::GetTautomers(void) const
{
    if (!CanGetTautomers()) {
        ThrowUnassigned(9);
    }
    return m_Tautomers;
}

inline
void CPC_Count_Base::SetTautomers(CPC_Count_Base::TTautomers value)
{
    m_Tautomers = value;
    m_set_State[0] |= 0xc0000;
}

inline
CPC_Count_Base::TTautomers& CPC_Count_Base::SetTautomers(void)
{
#ifdef _DEBUG
    if (!IsSetTautomers()) {
        memset(&m_Tautomers,UnassignedByte(),sizeof(m_Tautomers));
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Tautomers;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_COUNT_BASE_HPP
