/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_Group_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_GROUP_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_GROUP_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CPC_Bracket;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Superatom group (e.g. from MOL Sgroup)
class NCBI_PCSUBSTANCE_EXPORT CPC_Group_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_Group_Base(void);
    // destructor
    virtual ~CPC_Group_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /// These enumerated values are adapted from the ctfile format specification
    /// Type of group (e.g. from MOL field STY)
    enum EType {
        eType_sup     =   1,  ///< Superatom
        eType_mul     =   2,  ///< Multiple group
        eType_sru     =   3,  ///< Structure repeat unit (polymer)
        eType_mon     =   4,  ///< Monomer
        eType_mer     =   5,  ///< Mer type
        eType_cop     =   6,  ///< Copolymer
        eType_cro     =   7,  ///< Crosslink
        eType_mod     =   8,  ///< Modification
        eType_gra     =   9,  ///< Graft
        eType_com     =  10,  ///< Component
        eType_mix     =  11,  ///< Mixture
        eType_for     =  12,  ///< Formulation
        eType_dat     =  13,  ///< Data Sgroup
        eType_any     =  14,  ///< Any polymer
        eType_gen     =  15,  ///< Generic
        eType_unknown = 255
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    /// Subtype (e.g. from MOL field SST)
    enum ESubtype {
        eSubtype_alt     =   1,  ///< Alternating
        eSubtype_ran     =   2,  ///< Random
        eSubtype_blo     =   3,  ///< Block
        eSubtype_unknown = 255
    };
    
    /// Access to ESubtype's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ESubtype)(void);
    
    /// Connectivity (e.g. from MOL field SCN)
    enum EConnectivity {
        eConnectivity_hh      =   1,  ///< Head-to-head
        eConnectivity_ht      =   2,  ///< Head-to-tail
        eConnectivity_eu      =   3,  ///< Either unknown
        eConnectivity_unknown = 255
    };
    
    /// Access to EConnectivity's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EConnectivity)(void);
    
    /////////////////////////////////////////////////////////////////////////////
    /// Repeat count (e.g. for polymers)
    class NCBI_PCSUBSTANCE_EXPORT C_Repeat_count : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Repeat_count(void);
        // destructor
        ~C_Repeat_count(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class NCBI_PCSUBSTANCE_EXPORT C_Range : public CSerialObject
        {
            typedef CSerialObject Tparent;
        public:
            // constructor
            C_Range(void);
            // destructor
            ~C_Range(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef int TLower;
            typedef int TUpper;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_lower,
                e_upper
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
        
            // getters
            // setters
        
            /// mandatory
            /// typedef int TLower
            ///  Check whether the Lower data member has been assigned a value.
            bool IsSetLower(void) const;
            /// Check whether it is safe or not to call GetLower method.
            bool CanGetLower(void) const;
            void ResetLower(void);
            TLower GetLower(void) const;
            void SetLower(TLower value);
            TLower& SetLower(void);
        
            /// mandatory
            /// typedef int TUpper
            ///  Check whether the Upper data member has been assigned a value.
            bool IsSetUpper(void) const;
            /// Check whether it is safe or not to call GetUpper method.
            bool CanGetUpper(void) const;
            void ResetUpper(void);
            TUpper GetUpper(void) const;
            void SetUpper(TUpper value);
            TUpper& SetUpper(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_Range(const C_Range&);
            C_Range& operator=(const C_Range&);
        
            // data
            Uint4 m_set_State[1];
            int m_Lower;
            int m_Upper;
        };
    
        /// Choice variants.
        enum E_Choice {
            e_not_set = 0,  ///< No variant selected
            e_Exact,
            e_Range
        };
        /// Maximum+1 value of the choice variant enumerator.
        enum E_ChoiceStopper {
            e_MaxChoice = 3 ///< == e_Range+1
        };
    
        /// Reset the whole object
        void Reset(void);
    
        /// Reset the selection (set it to e_not_set).
        void ResetSelection(void);
    
        /// Which variant is currently selected.
        E_Choice Which(void) const;
    
        /// Verify selection, throw exception if it differs from the expected.
        void CheckSelected(E_Choice index) const;
    
        /// Throw 'InvalidSelection' exception.
        NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;
    
        /// Retrieve selection name (for diagnostic purposes).
        static string SelectionName(E_Choice index);
    
        /// Select the requested variant if needed.
        void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
        /// Select the requested variant if needed,
        /// allocating CObject variants from memory pool.
        void Select(E_Choice index,
                    EResetVariant reset,
                    CObjectMemoryPool* pool);
    
        // types
        typedef int TExact;
        typedef C_Range TRange;
    
        // getters
        // setters
    
        // typedef int TExact
        bool IsExact(void) const;
        TExact GetExact(void) const;
        TExact& SetExact(void);
        void SetExact(TExact value);
    
        // typedef C_Range TRange
        bool IsRange(void) const;
        const TRange& GetRange(void) const;
        TRange& SetRange(void);
        void SetRange(TRange& value);
    
    
    private:
        // copy constructor and assignment operator
        C_Repeat_count(const C_Repeat_count& );
        C_Repeat_count& operator=(const C_Repeat_count& );
        // choice state
        E_Choice m_choice;
        // helper methods
        void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);
    
        static const char* const sm_SelectionNames[];
        // data
        union {
            TExact m_Exact;
            NCBI_NS_NCBI::CSerialObject *m_object;
        };
    };
    /////////////////////////////////////////////////////////////////////////////
    /// Special bonds in this group (typically capping/crossing bonds, e.g. from MOL field SBL)
    ///   If present, from and to must be parallel lists of aid from PC-Bonds
    class NCBI_PCSUBSTANCE_EXPORT C_Bonds : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Bonds(void);
        // destructor
        ~C_Bonds(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef vector< int > TFrom;
        typedef vector< int > TTo;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_from,
            e_to
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef vector< int > TFrom
        ///  Check whether the From data member has been assigned a value.
        bool IsSetFrom(void) const;
        /// Check whether it is safe or not to call GetFrom method.
        bool CanGetFrom(void) const;
        void ResetFrom(void);
        const TFrom& GetFrom(void) const;
        TFrom& SetFrom(void);
    
        /// mandatory
        /// typedef vector< int > TTo
        ///  Check whether the To data member has been assigned a value.
        bool IsSetTo(void) const;
        /// Check whether it is safe or not to call GetTo method.
        bool CanGetTo(void) const;
        void ResetTo(void);
        const TTo& GetTo(void) const;
        TTo& SetTo(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Bonds(const C_Bonds&);
        C_Bonds& operator=(const C_Bonds&);
    
        // data
        Uint4 m_set_State[1];
        vector< int > m_From;
        vector< int > m_To;
    };
    /////////////////////////////////////////////////////////////////////////////
    /// Bracket display (e.g. from MOL field SDI)
    class NCBI_PCSUBSTANCE_EXPORT C_Brackets : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Brackets(void);
        // destructor
        ~C_Brackets(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef CPC_Bracket TLeft;
        typedef CPC_Bracket TRight;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_left,
            e_right
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef CPC_Bracket TLeft
        ///  Check whether the Left data member has been assigned a value.
        bool IsSetLeft(void) const;
        /// Check whether it is safe or not to call GetLeft method.
        bool CanGetLeft(void) const;
        void ResetLeft(void);
        const TLeft& GetLeft(void) const;
        void SetLeft(TLeft& value);
        TLeft& SetLeft(void);
    
        /// mandatory
        /// typedef CPC_Bracket TRight
        ///  Check whether the Right data member has been assigned a value.
        bool IsSetRight(void) const;
        /// Check whether it is safe or not to call GetRight method.
        bool CanGetRight(void) const;
        void ResetRight(void);
        const TRight& GetRight(void) const;
        void SetRight(TRight& value);
        TRight& SetRight(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Brackets(const C_Brackets&);
        C_Brackets& operator=(const C_Brackets&);
    
        // data
        Uint4 m_set_State[1];
        CRef< TLeft > m_Left;
        CRef< TRight > m_Right;
    };
    // types
    typedef vector< int > TAtoms;
    typedef int TType;
    typedef int TSubtype;
    typedef int TConnectivity;
    typedef int TLabel;
    typedef string TSubscript;
    typedef C_Repeat_count TRepeat_count;
    typedef C_Bonds TBonds;
    typedef C_Brackets TBrackets;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_atoms,
        e_type,
        e_subtype,
        e_connectivity,
        e_label,
        e_subscript,
        e_repeat_count,
        e_bonds,
        e_brackets
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;

    // getters
    // setters

    /// Atoms in this group (list of aid from PC-Atoms, e.g. from MOL FIELD SAL)
    /// mandatory
    /// typedef vector< int > TAtoms
    ///  Check whether the Atoms data member has been assigned a value.
    bool IsSetAtoms(void) const;
    /// Check whether it is safe or not to call GetAtoms method.
    bool CanGetAtoms(void) const;
    void ResetAtoms(void);
    const TAtoms& GetAtoms(void) const;
    TAtoms& SetAtoms(void);

    /// mandatory
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// optional
    /// typedef int TSubtype
    ///  Check whether the Subtype data member has been assigned a value.
    bool IsSetSubtype(void) const;
    /// Check whether it is safe or not to call GetSubtype method.
    bool CanGetSubtype(void) const;
    void ResetSubtype(void);
    TSubtype GetSubtype(void) const;
    void SetSubtype(TSubtype value);
    TSubtype& SetSubtype(void);

    /// optional
    /// typedef int TConnectivity
    ///  Check whether the Connectivity data member has been assigned a value.
    bool IsSetConnectivity(void) const;
    /// Check whether it is safe or not to call GetConnectivity method.
    bool CanGetConnectivity(void) const;
    void ResetConnectivity(void);
    TConnectivity GetConnectivity(void) const;
    void SetConnectivity(TConnectivity value);
    TConnectivity& SetConnectivity(void);

    /// Label (e.g. from MOL field SLB)
    /// optional
    /// typedef int TLabel
    ///  Check whether the Label data member has been assigned a value.
    bool IsSetLabel(void) const;
    /// Check whether it is safe or not to call GetLabel method.
    bool CanGetLabel(void) const;
    void ResetLabel(void);
    TLabel GetLabel(void) const;
    void SetLabel(TLabel value);
    TLabel& SetLabel(void);

    /// Subscript (e.g. from MOL field SMT)
    /// optional
    /// typedef string TSubscript
    ///  Check whether the Subscript data member has been assigned a value.
    bool IsSetSubscript(void) const;
    /// Check whether it is safe or not to call GetSubscript method.
    bool CanGetSubscript(void) const;
    void ResetSubscript(void);
    const TSubscript& GetSubscript(void) const;
    void SetSubscript(const TSubscript& value);
    void SetSubscript(TSubscript&& value);
    TSubscript& SetSubscript(void);

    /// optional
    /// typedef C_Repeat_count TRepeat_count
    ///  Check whether the Repeat_count data member has been assigned a value.
    bool IsSetRepeat_count(void) const;
    /// Check whether it is safe or not to call GetRepeat_count method.
    bool CanGetRepeat_count(void) const;
    void ResetRepeat_count(void);
    const TRepeat_count& GetRepeat_count(void) const;
    void SetRepeat_count(TRepeat_count& value);
    TRepeat_count& SetRepeat_count(void);

    /// optional
    /// typedef C_Bonds TBonds
    ///  Check whether the Bonds data member has been assigned a value.
    bool IsSetBonds(void) const;
    /// Check whether it is safe or not to call GetBonds method.
    bool CanGetBonds(void) const;
    void ResetBonds(void);
    const TBonds& GetBonds(void) const;
    void SetBonds(TBonds& value);
    TBonds& SetBonds(void);

    /// optional
    /// typedef C_Brackets TBrackets
    ///  Check whether the Brackets data member has been assigned a value.
    bool IsSetBrackets(void) const;
    /// Check whether it is safe or not to call GetBrackets method.
    bool CanGetBrackets(void) const;
    void ResetBrackets(void);
    const TBrackets& GetBrackets(void) const;
    void SetBrackets(TBrackets& value);
    TBrackets& SetBrackets(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_Group_Base(const CPC_Group_Base&);
    CPC_Group_Base& operator=(const CPC_Group_Base&);

    // data
    Uint4 m_set_State[1];
    vector< int > m_Atoms;
    int m_Type;
    int m_Subtype;
    int m_Connectivity;
    int m_Label;
    string m_Subscript;
    CRef< TRepeat_count > m_Repeat_count;
    CRef< TBonds > m_Bonds;
    CRef< TBrackets > m_Brackets;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_Group_Base::C_Repeat_count::C_Range::IsSetLower(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_Group_Base::C_Repeat_count::C_Range::CanGetLower(void) const
{
    return IsSetLower();
}

inline
void CPC_Group_Base::C_Repeat_count::C_Range::ResetLower(void)
{
    m_Lower = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPC_Group_Base::C_Repeat_count::C_Range::TLower CPC_Group_Base::C_Repeat_count::C_Range::GetLower(void) const
{
    if (!CanGetLower()) {
        ThrowUnassigned(0);
    }
    return m_Lower;
}

inline
void CPC_Group_Base::C_Repeat_count::C_Range::SetLower(CPC_Group_Base::C_Repeat_count::C_Range::TLower value)
{
    m_Lower = value;
    m_set_State[0] |= 0x3;
}

inline
CPC_Group_Base::C_Repeat_count::C_Range::TLower& CPC_Group_Base::C_Repeat_count::C_Range::SetLower(void)
{
#ifdef _DEBUG
    if (!IsSetLower()) {
        memset(&m_Lower,UnassignedByte(),sizeof(m_Lower));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Lower;
}

inline
bool CPC_Group_Base::C_Repeat_count::C_Range::IsSetUpper(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_Group_Base::C_Repeat_count::C_Range::CanGetUpper(void) const
{
    return IsSetUpper();
}

inline
void CPC_Group_Base::C_Repeat_count::C_Range::ResetUpper(void)
{
    m_Upper = 0;
    m_set_State[0] &= ~0xc;
}

inline
CPC_Group_Base::C_Repeat_count::C_Range::TUpper CPC_Group_Base::C_Repeat_count::C_Range::GetUpper(void) const
{
    if (!CanGetUpper()) {
        ThrowUnassigned(1);
    }
    return m_Upper;
}

inline
void CPC_Group_Base::C_Repeat_count::C_Range::SetUpper(CPC_Group_Base::C_Repeat_count::C_Range::TUpper value)
{
    m_Upper = value;
    m_set_State[0] |= 0xc;
}

inline
CPC_Group_Base::C_Repeat_count::C_Range::TUpper& CPC_Group_Base::C_Repeat_count::C_Range::SetUpper(void)
{
#ifdef _DEBUG
    if (!IsSetUpper()) {
        memset(&m_Upper,UnassignedByte(),sizeof(m_Upper));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Upper;
}

inline
CPC_Group_Base::C_Repeat_count::E_Choice CPC_Group_Base::C_Repeat_count::Which(void) const
{
    return m_choice;
}

inline
void CPC_Group_Base::C_Repeat_count::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CPC_Group_Base::C_Repeat_count::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CPC_Group_Base::C_Repeat_count::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CPC_Group_Base::C_Repeat_count::IsExact(void) const
{
    return m_choice == e_Exact;
}

inline
CPC_Group_Base::C_Repeat_count::TExact CPC_Group_Base::C_Repeat_count::GetExact(void) const
{
    CheckSelected(e_Exact);
    return m_Exact;
}

inline
CPC_Group_Base::C_Repeat_count::TExact& CPC_Group_Base::C_Repeat_count::SetExact(void)
{
    Select(e_Exact, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Exact;
}

inline
void CPC_Group_Base::C_Repeat_count::SetExact(CPC_Group_Base::C_Repeat_count::TExact value)
{
    Select(e_Exact, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Exact = value;
}

inline
bool CPC_Group_Base::C_Repeat_count::IsRange(void) const
{
    return m_choice == e_Range;
}

inline
bool CPC_Group_Base::C_Bonds::IsSetFrom(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_Group_Base::C_Bonds::CanGetFrom(void) const
{
    return true;
}

inline
const CPC_Group_Base::C_Bonds::TFrom& CPC_Group_Base::C_Bonds::GetFrom(void) const
{
    return m_From;
}

inline
CPC_Group_Base::C_Bonds::TFrom& CPC_Group_Base::C_Bonds::SetFrom(void)
{
    m_set_State[0] |= 0x1;
    return m_From;
}

inline
bool CPC_Group_Base::C_Bonds::IsSetTo(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_Group_Base::C_Bonds::CanGetTo(void) const
{
    return true;
}

inline
const CPC_Group_Base::C_Bonds::TTo& CPC_Group_Base::C_Bonds::GetTo(void) const
{
    return m_To;
}

inline
CPC_Group_Base::C_Bonds::TTo& CPC_Group_Base::C_Bonds::SetTo(void)
{
    m_set_State[0] |= 0x4;
    return m_To;
}

inline
bool CPC_Group_Base::C_Brackets::IsSetLeft(void) const
{
    return m_Left.NotEmpty();
}

inline
bool CPC_Group_Base::C_Brackets::CanGetLeft(void) const
{
    return true;
}

inline
const CPC_Group_Base::C_Brackets::TLeft& CPC_Group_Base::C_Brackets::GetLeft(void) const
{
    if ( !m_Left ) {
        const_cast<C_Brackets*>(this)->ResetLeft();
    }
    return (*m_Left);
}

inline
CPC_Group_Base::C_Brackets::TLeft& CPC_Group_Base::C_Brackets::SetLeft(void)
{
    if ( !m_Left ) {
        ResetLeft();
    }
    return (*m_Left);
}

inline
bool CPC_Group_Base::C_Brackets::IsSetRight(void) const
{
    return m_Right.NotEmpty();
}

inline
bool CPC_Group_Base::C_Brackets::CanGetRight(void) const
{
    return true;
}

inline
const CPC_Group_Base::C_Brackets::TRight& CPC_Group_Base::C_Brackets::GetRight(void) const
{
    if ( !m_Right ) {
        const_cast<C_Brackets*>(this)->ResetRight();
    }
    return (*m_Right);
}

inline
CPC_Group_Base::C_Brackets::TRight& CPC_Group_Base::C_Brackets::SetRight(void)
{
    if ( !m_Right ) {
        ResetRight();
    }
    return (*m_Right);
}

inline
bool CPC_Group_Base::IsSetAtoms(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_Group_Base::CanGetAtoms(void) const
{
    return true;
}

inline
const CPC_Group_Base::TAtoms& CPC_Group_Base::GetAtoms(void) const
{
    return m_Atoms;
}

inline
CPC_Group_Base::TAtoms& CPC_Group_Base::SetAtoms(void)
{
    m_set_State[0] |= 0x1;
    return m_Atoms;
}

inline
bool CPC_Group_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_Group_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CPC_Group_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0xc;
}

inline
CPC_Group_Base::TType CPC_Group_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(1);
    }
    return m_Type;
}

inline
void CPC_Group_Base::SetType(CPC_Group_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0xc;
}

inline
CPC_Group_Base::TType& CPC_Group_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Type;
}

inline
bool CPC_Group_Base::IsSetSubtype(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPC_Group_Base::CanGetSubtype(void) const
{
    return IsSetSubtype();
}

inline
void CPC_Group_Base::ResetSubtype(void)
{
    m_Subtype = (ESubtype)(0);
    m_set_State[0] &= ~0x30;
}

inline
CPC_Group_Base::TSubtype CPC_Group_Base::GetSubtype(void) const
{
    if (!CanGetSubtype()) {
        ThrowUnassigned(2);
    }
    return m_Subtype;
}

inline
void CPC_Group_Base::SetSubtype(CPC_Group_Base::TSubtype value)
{
    m_Subtype = value;
    m_set_State[0] |= 0x30;
}

inline
CPC_Group_Base::TSubtype& CPC_Group_Base::SetSubtype(void)
{
#ifdef _DEBUG
    if (!IsSetSubtype()) {
        memset(&m_Subtype,UnassignedByte(),sizeof(m_Subtype));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Subtype;
}

inline
bool CPC_Group_Base::IsSetConnectivity(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPC_Group_Base::CanGetConnectivity(void) const
{
    return IsSetConnectivity();
}

inline
void CPC_Group_Base::ResetConnectivity(void)
{
    m_Connectivity = (EConnectivity)(0);
    m_set_State[0] &= ~0xc0;
}

inline
CPC_Group_Base::TConnectivity CPC_Group_Base::GetConnectivity(void) const
{
    if (!CanGetConnectivity()) {
        ThrowUnassigned(3);
    }
    return m_Connectivity;
}

inline
void CPC_Group_Base::SetConnectivity(CPC_Group_Base::TConnectivity value)
{
    m_Connectivity = value;
    m_set_State[0] |= 0xc0;
}

inline
CPC_Group_Base::TConnectivity& CPC_Group_Base::SetConnectivity(void)
{
#ifdef _DEBUG
    if (!IsSetConnectivity()) {
        memset(&m_Connectivity,UnassignedByte(),sizeof(m_Connectivity));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Connectivity;
}

inline
bool CPC_Group_Base::IsSetLabel(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPC_Group_Base::CanGetLabel(void) const
{
    return IsSetLabel();
}

inline
void CPC_Group_Base::ResetLabel(void)
{
    m_Label = 0;
    m_set_State[0] &= ~0x300;
}

inline
CPC_Group_Base::TLabel CPC_Group_Base::GetLabel(void) const
{
    if (!CanGetLabel()) {
        ThrowUnassigned(4);
    }
    return m_Label;
}

inline
void CPC_Group_Base::SetLabel(CPC_Group_Base::TLabel value)
{
    m_Label = value;
    m_set_State[0] |= 0x300;
}

inline
CPC_Group_Base::TLabel& CPC_Group_Base::SetLabel(void)
{
#ifdef _DEBUG
    if (!IsSetLabel()) {
        memset(&m_Label,UnassignedByte(),sizeof(m_Label));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Label;
}

inline
bool CPC_Group_Base::IsSetSubscript(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CPC_Group_Base::CanGetSubscript(void) const
{
    return IsSetSubscript();
}

inline
const CPC_Group_Base::TSubscript& CPC_Group_Base::GetSubscript(void) const
{
    if (!CanGetSubscript()) {
        ThrowUnassigned(5);
    }
    return m_Subscript;
}

inline
void CPC_Group_Base::SetSubscript(const CPC_Group_Base::TSubscript& value)
{
    m_Subscript = value;
    m_set_State[0] |= 0xc00;
}

inline
void CPC_Group_Base::SetSubscript(CPC_Group_Base::TSubscript&& value)
{
    m_Subscript = std::forward<CPC_Group_Base::TSubscript>(value);
    m_set_State[0] |= 0xc00;
}

inline
CPC_Group_Base::TSubscript& CPC_Group_Base::SetSubscript(void)
{
#ifdef _DEBUG
    if (!IsSetSubscript()) {
        m_Subscript = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Subscript;
}

inline
bool CPC_Group_Base::IsSetRepeat_count(void) const
{
    return m_Repeat_count.NotEmpty();
}

inline
bool CPC_Group_Base::CanGetRepeat_count(void) const
{
    return IsSetRepeat_count();
}

inline
const CPC_Group_Base::TRepeat_count& CPC_Group_Base::GetRepeat_count(void) const
{
    if (!CanGetRepeat_count()) {
        ThrowUnassigned(6);
    }
    return (*m_Repeat_count);
}

inline
bool CPC_Group_Base::IsSetBonds(void) const
{
    return m_Bonds.NotEmpty();
}

inline
bool CPC_Group_Base::CanGetBonds(void) const
{
    return IsSetBonds();
}

inline
const CPC_Group_Base::TBonds& CPC_Group_Base::GetBonds(void) const
{
    if (!CanGetBonds()) {
        ThrowUnassigned(7);
    }
    return (*m_Bonds);
}

inline
bool CPC_Group_Base::IsSetBrackets(void) const
{
    return m_Brackets.NotEmpty();
}

inline
bool CPC_Group_Base::CanGetBrackets(void) const
{
    return IsSetBrackets();
}

inline
const CPC_Group_Base::TBrackets& CPC_Group_Base::GetBrackets(void) const
{
    if (!CanGetBrackets()) {
        ThrowUnassigned(8);
    }
    return (*m_Brackets);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_GROUP_BASE_HPP
