/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_StereoCenter_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_STEREOCENTER_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_STEREOCENTER_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CPC_StereoOctahedral;
class CPC_StereoPentagonalBiPyramid;
class CPC_StereoPlanar;
class CPC_StereoSquarePlanar;
class CPC_StereoTShape;
class CPC_StereoTetrahedral;
class CPC_StereoTrigonalBiPyramid;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Allowed Stereogenic Center Types
///   [Using IUPAC Stereogenic Center recommendations and terminology]
class NCBI_PCSUBSTANCE_EXPORT CPC_StereoCenter_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_StereoCenter_Base(void);
    // destructor
    virtual ~CPC_StereoCenter_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,   ///< No variant selected
        e_Tetrahedral,   ///< Tetrahedral (SP3) StereoCenter
        e_Planar,        ///< Planar (SP2) StereoCenter
        e_Squareplanar,  ///< Square Planar (SP4) StereoCenter
        e_Octahedral,    ///< Octahedral (OC-6) / Square Pyramid (SPY-5) StereoCenters
        e_Bipyramid,     ///< Trigonal BiPyramid (TBPY-4 and TBPY-5) StereoCenters
        e_Tshape,        ///< T-Shaped (TS-3) StereoCenters
        e_Pentagonal     ///< Pentagonal BiPyramid (PBPY-7) StereoCenters
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 8 ///< == e_Pentagonal+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef CPC_StereoTetrahedral TTetrahedral;
    typedef CPC_StereoPlanar TPlanar;
    typedef CPC_StereoSquarePlanar TSquareplanar;
    typedef CPC_StereoOctahedral TOctahedral;
    typedef CPC_StereoTrigonalBiPyramid TBipyramid;
    typedef CPC_StereoTShape TTshape;
    typedef CPC_StereoPentagonalBiPyramid TPentagonal;

    // getters
    // setters

    // typedef CPC_StereoTetrahedral TTetrahedral
    bool IsTetrahedral(void) const;
    const TTetrahedral& GetTetrahedral(void) const;
    TTetrahedral& SetTetrahedral(void);
    void SetTetrahedral(TTetrahedral& value);

    // typedef CPC_StereoPlanar TPlanar
    bool IsPlanar(void) const;
    const TPlanar& GetPlanar(void) const;
    TPlanar& SetPlanar(void);
    void SetPlanar(TPlanar& value);

    // typedef CPC_StereoSquarePlanar TSquareplanar
    bool IsSquareplanar(void) const;
    const TSquareplanar& GetSquareplanar(void) const;
    TSquareplanar& SetSquareplanar(void);
    void SetSquareplanar(TSquareplanar& value);

    // typedef CPC_StereoOctahedral TOctahedral
    bool IsOctahedral(void) const;
    const TOctahedral& GetOctahedral(void) const;
    TOctahedral& SetOctahedral(void);
    void SetOctahedral(TOctahedral& value);

    // typedef CPC_StereoTrigonalBiPyramid TBipyramid
    bool IsBipyramid(void) const;
    const TBipyramid& GetBipyramid(void) const;
    TBipyramid& SetBipyramid(void);
    void SetBipyramid(TBipyramid& value);

    // typedef CPC_StereoTShape TTshape
    bool IsTshape(void) const;
    const TTshape& GetTshape(void) const;
    TTshape& SetTshape(void);
    void SetTshape(TTshape& value);

    // typedef CPC_StereoPentagonalBiPyramid TPentagonal
    bool IsPentagonal(void) const;
    const TPentagonal& GetPentagonal(void) const;
    TPentagonal& SetPentagonal(void);
    void SetPentagonal(TPentagonal& value);


private:
    // copy constructor and assignment operator
    CPC_StereoCenter_Base(const CPC_StereoCenter_Base& );
    CPC_StereoCenter_Base& operator=(const CPC_StereoCenter_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    NCBI_NS_NCBI::CSerialObject *m_object;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CPC_StereoCenter_Base::E_Choice CPC_StereoCenter_Base::Which(void) const
{
    return m_choice;
}

inline
void CPC_StereoCenter_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CPC_StereoCenter_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CPC_StereoCenter_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CPC_StereoCenter_Base::IsTetrahedral(void) const
{
    return m_choice == e_Tetrahedral;
}

inline
bool CPC_StereoCenter_Base::IsPlanar(void) const
{
    return m_choice == e_Planar;
}

inline
bool CPC_StereoCenter_Base::IsSquareplanar(void) const
{
    return m_choice == e_Squareplanar;
}

inline
bool CPC_StereoCenter_Base::IsOctahedral(void) const
{
    return m_choice == e_Octahedral;
}

inline
bool CPC_StereoCenter_Base::IsBipyramid(void) const
{
    return m_choice == e_Bipyramid;
}

inline
bool CPC_StereoCenter_Base::IsTshape(void) const
{
    return m_choice == e_Tshape;
}

inline
bool CPC_StereoCenter_Base::IsPentagonal(void) const
{
    return m_choice == e_Pentagonal;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_STEREOCENTER_BASE_HPP
