/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PC_StereoOctahedral_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pcsubstance.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PCSUBSTANCE_PC_STEREOOCTAHEDRAL_BASE_HPP
#define OBJECTS_PCSUBSTANCE_PC_STEREOOCTAHEDRAL_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Octahedral (OC-6) and Square Pyramid (SPY-5) StereoCenters
///   [Using IUPAC Stereogenic Center recommendations and terminology]
///   [Note: "-1" can be used for the Atom Identifier to represent a lone-pair or implicit hydrogen]
class NCBI_PCSUBSTANCE_EXPORT CPC_StereoOctahedral_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPC_StereoOctahedral_Base(void);
    // destructor
    virtual ~CPC_StereoOctahedral_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TCenter;
    typedef int TTop;
    typedef int TBottom;
    typedef int TLabove;
    typedef int TLbelow;
    typedef int TRabove;
    typedef int TRbelow;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_center,
        e_top,
        e_bottom,
        e_labove,
        e_lbelow,
        e_rabove,
        e_rbelow
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// Atom ID of Atom Center
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TCenter
    ///  Check whether the Center data member has been assigned a value.
    bool IsSetCenter(void) const;
    /// Check whether it is safe or not to call GetCenter method.
    bool CanGetCenter(void) const;
    void ResetCenter(void);
    TCenter GetCenter(void) const;
    void SetCenter(TCenter value);
    TCenter& SetCenter(void);

    /// Atom ID of Atom In-Plane and at the Top
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TTop
    ///  Check whether the Top data member has been assigned a value.
    bool IsSetTop(void) const;
    /// Check whether it is safe or not to call GetTop method.
    bool CanGetTop(void) const;
    void ResetTop(void);
    TTop GetTop(void) const;
    void SetTop(TTop value);
    TTop& SetTop(void);

    /// Atom ID of Atom In-Plane and at the Bottom
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TBottom
    ///  Check whether the Bottom data member has been assigned a value.
    bool IsSetBottom(void) const;
    /// Check whether it is safe or not to call GetBottom method.
    bool CanGetBottom(void) const;
    void ResetBottom(void);
    TBottom GetBottom(void) const;
    void SetBottom(TBottom value);
    TBottom& SetBottom(void);

    /// Atom ID of Atom Above the Plane on the Left
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TLabove
    ///  Check whether the Labove data member has been assigned a value.
    bool IsSetLabove(void) const;
    /// Check whether it is safe or not to call GetLabove method.
    bool CanGetLabove(void) const;
    void ResetLabove(void);
    TLabove GetLabove(void) const;
    void SetLabove(TLabove value);
    TLabove& SetLabove(void);

    /// Atom ID of Atom Below the Plane on the Left
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TLbelow
    ///  Check whether the Lbelow data member has been assigned a value.
    bool IsSetLbelow(void) const;
    /// Check whether it is safe or not to call GetLbelow method.
    bool CanGetLbelow(void) const;
    void ResetLbelow(void);
    TLbelow GetLbelow(void) const;
    void SetLbelow(TLbelow value);
    TLbelow& SetLbelow(void);

    /// Atom ID of Atom Above the Plane on the Right
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TRabove
    ///  Check whether the Rabove data member has been assigned a value.
    bool IsSetRabove(void) const;
    /// Check whether it is safe or not to call GetRabove method.
    bool CanGetRabove(void) const;
    void ResetRabove(void);
    TRabove GetRabove(void) const;
    void SetRabove(TRabove value);
    TRabove& SetRabove(void);

    /// Atom ID of Atom Below the Plane on the Right
    ///   Note: Atom ID's must be greater than "0"
    /// mandatory
    /// typedef int TRbelow
    ///  Check whether the Rbelow data member has been assigned a value.
    bool IsSetRbelow(void) const;
    /// Check whether it is safe or not to call GetRbelow method.
    bool CanGetRbelow(void) const;
    void ResetRbelow(void);
    TRbelow GetRbelow(void) const;
    void SetRbelow(TRbelow value);
    TRbelow& SetRbelow(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPC_StereoOctahedral_Base(const CPC_StereoOctahedral_Base&);
    CPC_StereoOctahedral_Base& operator=(const CPC_StereoOctahedral_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Center;
    int m_Top;
    int m_Bottom;
    int m_Labove;
    int m_Lbelow;
    int m_Rabove;
    int m_Rbelow;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPC_StereoOctahedral_Base::IsSetCenter(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPC_StereoOctahedral_Base::CanGetCenter(void) const
{
    return IsSetCenter();
}

inline
void CPC_StereoOctahedral_Base::ResetCenter(void)
{
    m_Center = 0;
    m_set_State[0] &= ~0x3;
}

inline
CPC_StereoOctahedral_Base::TCenter CPC_StereoOctahedral_Base::GetCenter(void) const
{
    if (!CanGetCenter()) {
        ThrowUnassigned(0);
    }
    return m_Center;
}

inline
void CPC_StereoOctahedral_Base::SetCenter(CPC_StereoOctahedral_Base::TCenter value)
{
    m_Center = value;
    m_set_State[0] |= 0x3;
}

inline
CPC_StereoOctahedral_Base::TCenter& CPC_StereoOctahedral_Base::SetCenter(void)
{
#ifdef _DEBUG
    if (!IsSetCenter()) {
        memset(&m_Center,UnassignedByte(),sizeof(m_Center));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Center;
}

inline
bool CPC_StereoOctahedral_Base::IsSetTop(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPC_StereoOctahedral_Base::CanGetTop(void) const
{
    return IsSetTop();
}

inline
void CPC_StereoOctahedral_Base::ResetTop(void)
{
    m_Top = 0;
    m_set_State[0] &= ~0xc;
}

inline
CPC_StereoOctahedral_Base::TTop CPC_StereoOctahedral_Base::GetTop(void) const
{
    if (!CanGetTop()) {
        ThrowUnassigned(1);
    }
    return m_Top;
}

inline
void CPC_StereoOctahedral_Base::SetTop(CPC_StereoOctahedral_Base::TTop value)
{
    m_Top = value;
    m_set_State[0] |= 0xc;
}

inline
CPC_StereoOctahedral_Base::TTop& CPC_StereoOctahedral_Base::SetTop(void)
{
#ifdef _DEBUG
    if (!IsSetTop()) {
        memset(&m_Top,UnassignedByte(),sizeof(m_Top));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Top;
}

inline
bool CPC_StereoOctahedral_Base::IsSetBottom(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPC_StereoOctahedral_Base::CanGetBottom(void) const
{
    return IsSetBottom();
}

inline
void CPC_StereoOctahedral_Base::ResetBottom(void)
{
    m_Bottom = 0;
    m_set_State[0] &= ~0x30;
}

inline
CPC_StereoOctahedral_Base::TBottom CPC_StereoOctahedral_Base::GetBottom(void) const
{
    if (!CanGetBottom()) {
        ThrowUnassigned(2);
    }
    return m_Bottom;
}

inline
void CPC_StereoOctahedral_Base::SetBottom(CPC_StereoOctahedral_Base::TBottom value)
{
    m_Bottom = value;
    m_set_State[0] |= 0x30;
}

inline
CPC_StereoOctahedral_Base::TBottom& CPC_StereoOctahedral_Base::SetBottom(void)
{
#ifdef _DEBUG
    if (!IsSetBottom()) {
        memset(&m_Bottom,UnassignedByte(),sizeof(m_Bottom));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Bottom;
}

inline
bool CPC_StereoOctahedral_Base::IsSetLabove(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPC_StereoOctahedral_Base::CanGetLabove(void) const
{
    return IsSetLabove();
}

inline
void CPC_StereoOctahedral_Base::ResetLabove(void)
{
    m_Labove = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CPC_StereoOctahedral_Base::TLabove CPC_StereoOctahedral_Base::GetLabove(void) const
{
    if (!CanGetLabove()) {
        ThrowUnassigned(3);
    }
    return m_Labove;
}

inline
void CPC_StereoOctahedral_Base::SetLabove(CPC_StereoOctahedral_Base::TLabove value)
{
    m_Labove = value;
    m_set_State[0] |= 0xc0;
}

inline
CPC_StereoOctahedral_Base::TLabove& CPC_StereoOctahedral_Base::SetLabove(void)
{
#ifdef _DEBUG
    if (!IsSetLabove()) {
        memset(&m_Labove,UnassignedByte(),sizeof(m_Labove));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Labove;
}

inline
bool CPC_StereoOctahedral_Base::IsSetLbelow(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPC_StereoOctahedral_Base::CanGetLbelow(void) const
{
    return IsSetLbelow();
}

inline
void CPC_StereoOctahedral_Base::ResetLbelow(void)
{
    m_Lbelow = 0;
    m_set_State[0] &= ~0x300;
}

inline
CPC_StereoOctahedral_Base::TLbelow CPC_StereoOctahedral_Base::GetLbelow(void) const
{
    if (!CanGetLbelow()) {
        ThrowUnassigned(4);
    }
    return m_Lbelow;
}

inline
void CPC_StereoOctahedral_Base::SetLbelow(CPC_StereoOctahedral_Base::TLbelow value)
{
    m_Lbelow = value;
    m_set_State[0] |= 0x300;
}

inline
CPC_StereoOctahedral_Base::TLbelow& CPC_StereoOctahedral_Base::SetLbelow(void)
{
#ifdef _DEBUG
    if (!IsSetLbelow()) {
        memset(&m_Lbelow,UnassignedByte(),sizeof(m_Lbelow));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Lbelow;
}

inline
bool CPC_StereoOctahedral_Base::IsSetRabove(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CPC_StereoOctahedral_Base::CanGetRabove(void) const
{
    return IsSetRabove();
}

inline
void CPC_StereoOctahedral_Base::ResetRabove(void)
{
    m_Rabove = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CPC_StereoOctahedral_Base::TRabove CPC_StereoOctahedral_Base::GetRabove(void) const
{
    if (!CanGetRabove()) {
        ThrowUnassigned(5);
    }
    return m_Rabove;
}

inline
void CPC_StereoOctahedral_Base::SetRabove(CPC_StereoOctahedral_Base::TRabove value)
{
    m_Rabove = value;
    m_set_State[0] |= 0xc00;
}

inline
CPC_StereoOctahedral_Base::TRabove& CPC_StereoOctahedral_Base::SetRabove(void)
{
#ifdef _DEBUG
    if (!IsSetRabove()) {
        memset(&m_Rabove,UnassignedByte(),sizeof(m_Rabove));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Rabove;
}

inline
bool CPC_StereoOctahedral_Base::IsSetRbelow(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CPC_StereoOctahedral_Base::CanGetRbelow(void) const
{
    return IsSetRbelow();
}

inline
void CPC_StereoOctahedral_Base::ResetRbelow(void)
{
    m_Rbelow = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CPC_StereoOctahedral_Base::TRbelow CPC_StereoOctahedral_Base::GetRbelow(void) const
{
    if (!CanGetRbelow()) {
        ThrowUnassigned(6);
    }
    return m_Rbelow;
}

inline
void CPC_StereoOctahedral_Base::SetRbelow(CPC_StereoOctahedral_Base::TRbelow value)
{
    m_Rbelow = value;
    m_set_State[0] |= 0x3000;
}

inline
CPC_StereoOctahedral_Base::TRbelow& CPC_StereoOctahedral_Base::SetRbelow(void)
{
#ifdef _DEBUG
    if (!IsSetRbelow()) {
        memset(&m_Rbelow,UnassignedByte(),sizeof(m_Rbelow));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Rbelow;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PCSUBSTANCE_PC_STEREOOCTAHEDRAL_BASE_HPP
