/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Project_descr_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'proj.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PROJ_PROJECT_DESCR_BASE_HPP
#define OBJECTS_PROJ_PROJECT_DESCR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objects/proj/Project_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CProjdesc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_PROJ_EXPORT CProject_descr_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CProject_descr_Base(void);
    // destructor
    virtual ~CProject_descr_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< CProject_id > TId;
    typedef string TName;
    typedef list< CRef< CProjdesc > > TDescr;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_name,
        e_descr
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef list< CProject_id > TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    TId& SetId(void);

    /// optional
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// optional
    /// typedef list< CRef< CProjdesc > > TDescr
    ///  Check whether the Descr data member has been assigned a value.
    bool IsSetDescr(void) const;
    /// Check whether it is safe or not to call GetDescr method.
    bool CanGetDescr(void) const;
    void ResetDescr(void);
    const TDescr& GetDescr(void) const;
    TDescr& SetDescr(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CProject_descr_Base(const CProject_descr_Base&);
    CProject_descr_Base& operator=(const CProject_descr_Base&);

    // data
    Uint4 m_set_State[1];
    list< CProject_id > m_Id;
    string m_Name;
    list< CRef< CProjdesc > > m_Descr;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CProject_descr_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CProject_descr_Base::CanGetId(void) const
{
    return true;
}

inline
const CProject_descr_Base::TId& CProject_descr_Base::GetId(void) const
{
    return m_Id;
}

inline
CProject_descr_Base::TId& CProject_descr_Base::SetId(void)
{
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CProject_descr_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CProject_descr_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CProject_descr_Base::TName& CProject_descr_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(1);
    }
    return m_Name;
}

inline
void CProject_descr_Base::SetName(const CProject_descr_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0xc;
}

inline
void CProject_descr_Base::SetName(CProject_descr_Base::TName&& value)
{
    m_Name = std::forward<CProject_descr_Base::TName>(value);
    m_set_State[0] |= 0xc;
}

inline
CProject_descr_Base::TName& CProject_descr_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Name;
}

inline
bool CProject_descr_Base::IsSetDescr(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CProject_descr_Base::CanGetDescr(void) const
{
    return true;
}

inline
const CProject_descr_Base::TDescr& CProject_descr_Base::GetDescr(void) const
{
    return m_Descr;
}

inline
CProject_descr_Base::TDescr& CProject_descr_Base::SetDescr(void)
{
    m_set_State[0] |= 0x10;
    return m_Descr;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PROJ_PROJECT_DESCR_BASE_HPP
