/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Pubmed_entry_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'pubmed.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_PUBMED_PUBMED_ENTRY_BASE_HPP
#define OBJECTS_PUBMED_PUBMED_ENTRY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>
#include <objects/biblio/PubMedId.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CMedline_entry;
class CPubmed_url;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// a PubMed entry
/// PUBMED records must include the PubMedId
class NCBI_PUBMED_EXPORT CPubmed_entry_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPubmed_entry_Base(void);
    // destructor
    virtual ~CPubmed_entry_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CPubMedId TPmid;
    typedef CMedline_entry TMedent;
    typedef string TPublisher;
    typedef list< CRef< CPubmed_url > > TUrls;
    typedef string TPubid;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_pmid,
        e_medent,
        e_publisher,
        e_urls,
        e_pubid
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CPubMedId TPmid
    ///  Check whether the Pmid data member has been assigned a value.
    bool IsSetPmid(void) const;
    /// Check whether it is safe or not to call GetPmid method.
    bool CanGetPmid(void) const;
    void ResetPmid(void);
    const TPmid& GetPmid(void) const;
    void SetPmid(const TPmid& value);
    TPmid& SetPmid(void);

    /// Medline entry information
    /// optional
    /// typedef CMedline_entry TMedent
    ///  Check whether the Medent data member has been assigned a value.
    bool IsSetMedent(void) const;
    /// Check whether it is safe or not to call GetMedent method.
    bool CanGetMedent(void) const;
    void ResetMedent(void);
    const TMedent& GetMedent(void) const;
    void SetMedent(TMedent& value);
    TMedent& SetMedent(void);

    /// Publisher name
    /// optional
    /// typedef string TPublisher
    ///  Check whether the Publisher data member has been assigned a value.
    bool IsSetPublisher(void) const;
    /// Check whether it is safe or not to call GetPublisher method.
    bool CanGetPublisher(void) const;
    void ResetPublisher(void);
    const TPublisher& GetPublisher(void) const;
    void SetPublisher(const TPublisher& value);
    void SetPublisher(TPublisher&& value);
    TPublisher& SetPublisher(void);

    /// List of URL to publisher cite
    /// optional
    /// typedef list< CRef< CPubmed_url > > TUrls
    ///  Check whether the Urls data member has been assigned a value.
    bool IsSetUrls(void) const;
    /// Check whether it is safe or not to call GetUrls method.
    bool CanGetUrls(void) const;
    void ResetUrls(void);
    const TUrls& GetUrls(void) const;
    TUrls& SetUrls(void);

    /// Publisher's article identifier
    /// optional
    /// typedef string TPubid
    ///  Check whether the Pubid data member has been assigned a value.
    bool IsSetPubid(void) const;
    /// Check whether it is safe or not to call GetPubid method.
    bool CanGetPubid(void) const;
    void ResetPubid(void);
    const TPubid& GetPubid(void) const;
    void SetPubid(const TPubid& value);
    void SetPubid(TPubid&& value);
    TPubid& SetPubid(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPubmed_entry_Base(const CPubmed_entry_Base&);
    CPubmed_entry_Base& operator=(const CPubmed_entry_Base&);

    // data
    Uint4 m_set_State[1];
    CPubMedId m_Pmid;
    CRef< TMedent > m_Medent;
    string m_Publisher;
    list< CRef< CPubmed_url > > m_Urls;
    string m_Pubid;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPubmed_entry_Base::IsSetPmid(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPubmed_entry_Base::CanGetPmid(void) const
{
    return IsSetPmid();
}

inline
void CPubmed_entry_Base::ResetPmid(void)
{
    m_Pmid = CPubMedId(0);
    m_set_State[0] &= ~0x3;
}

inline
const CPubmed_entry_Base::TPmid& CPubmed_entry_Base::GetPmid(void) const
{
    if (!CanGetPmid()) {
        ThrowUnassigned(0);
    }
    return m_Pmid;
}

inline
void CPubmed_entry_Base::SetPmid(const CPubmed_entry_Base::TPmid& value)
{
    m_Pmid = value;
    m_set_State[0] |= 0x3;
}

inline
CPubmed_entry_Base::TPmid& CPubmed_entry_Base::SetPmid(void)
{
    m_set_State[0] |= 0x1;
    return m_Pmid;
}

inline
bool CPubmed_entry_Base::IsSetMedent(void) const
{
    return m_Medent.NotEmpty();
}

inline
bool CPubmed_entry_Base::CanGetMedent(void) const
{
    return IsSetMedent();
}

inline
const CPubmed_entry_Base::TMedent& CPubmed_entry_Base::GetMedent(void) const
{
    if (!CanGetMedent()) {
        ThrowUnassigned(1);
    }
    return (*m_Medent);
}

inline
bool CPubmed_entry_Base::IsSetPublisher(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPubmed_entry_Base::CanGetPublisher(void) const
{
    return IsSetPublisher();
}

inline
const CPubmed_entry_Base::TPublisher& CPubmed_entry_Base::GetPublisher(void) const
{
    if (!CanGetPublisher()) {
        ThrowUnassigned(2);
    }
    return m_Publisher;
}

inline
void CPubmed_entry_Base::SetPublisher(const CPubmed_entry_Base::TPublisher& value)
{
    m_Publisher = value;
    m_set_State[0] |= 0x30;
}

inline
void CPubmed_entry_Base::SetPublisher(CPubmed_entry_Base::TPublisher&& value)
{
    m_Publisher = std::forward<CPubmed_entry_Base::TPublisher>(value);
    m_set_State[0] |= 0x30;
}

inline
CPubmed_entry_Base::TPublisher& CPubmed_entry_Base::SetPublisher(void)
{
#ifdef _DEBUG
    if (!IsSetPublisher()) {
        m_Publisher = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Publisher;
}

inline
bool CPubmed_entry_Base::IsSetUrls(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPubmed_entry_Base::CanGetUrls(void) const
{
    return true;
}

inline
const CPubmed_entry_Base::TUrls& CPubmed_entry_Base::GetUrls(void) const
{
    return m_Urls;
}

inline
CPubmed_entry_Base::TUrls& CPubmed_entry_Base::SetUrls(void)
{
    m_set_State[0] |= 0x40;
    return m_Urls;
}

inline
bool CPubmed_entry_Base::IsSetPubid(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPubmed_entry_Base::CanGetPubid(void) const
{
    return IsSetPubid();
}

inline
const CPubmed_entry_Base::TPubid& CPubmed_entry_Base::GetPubid(void) const
{
    if (!CanGetPubid()) {
        ThrowUnassigned(4);
    }
    return m_Pubid;
}

inline
void CPubmed_entry_Base::SetPubid(const CPubmed_entry_Base::TPubid& value)
{
    m_Pubid = value;
    m_set_State[0] |= 0x300;
}

inline
void CPubmed_entry_Base::SetPubid(CPubmed_entry_Base::TPubid&& value)
{
    m_Pubid = std::forward<CPubmed_entry_Base::TPubid>(value);
    m_set_State[0] |= 0x300;
}

inline
CPubmed_entry_Base::TPubid& CPubmed_entry_Base::SetPubid(void)
{
#ifdef _DEBUG
    if (!IsSetPubid()) {
        m_Pubid = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Pubid;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_PUBMED_PUBMED_ENTRY_BASE_HPP
