/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file BlockProperty_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'scoremat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SCOREMAT_BLOCKPROPERTY_BASE_HPP
#define OBJECTS_SCOREMAT_BLOCKPROPERTY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// a rudimentary block/core-model, to be used with block-based alignment 
/// routines and threading
class NCBI_SCOREMAT_EXPORT CBlockProperty_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlockProperty_Base(void);
    // destructor
    virtual ~CBlockProperty_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EType {
        eType_unassigned  =   0,
        eType_threshold   =   1,  ///< score threshold for heuristics
        eType_minscore    =   2,  ///< observed minimum score in CD
        eType_maxscore    =   3,  ///< observed maximum score in CD
        eType_meanscore   =   4,  ///< observed mean score in CD
        eType_variance    =   5,  ///< observed score variance
        eType_name        =  10,  ///< just name the block
        eType_is_optional =  20,  ///< block may not have to be used    
        eType_other       = 255
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    // types
    typedef int TType;
    typedef int TIntvalue;
    typedef string TTextvalue;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_intvalue,
        e_textvalue
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// optional
    /// typedef int TIntvalue
    ///  Check whether the Intvalue data member has been assigned a value.
    bool IsSetIntvalue(void) const;
    /// Check whether it is safe or not to call GetIntvalue method.
    bool CanGetIntvalue(void) const;
    void ResetIntvalue(void);
    TIntvalue GetIntvalue(void) const;
    void SetIntvalue(TIntvalue value);
    TIntvalue& SetIntvalue(void);

    /// optional
    /// typedef string TTextvalue
    ///  Check whether the Textvalue data member has been assigned a value.
    bool IsSetTextvalue(void) const;
    /// Check whether it is safe or not to call GetTextvalue method.
    bool CanGetTextvalue(void) const;
    void ResetTextvalue(void);
    const TTextvalue& GetTextvalue(void) const;
    void SetTextvalue(const TTextvalue& value);
    void SetTextvalue(TTextvalue&& value);
    TTextvalue& SetTextvalue(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlockProperty_Base(const CBlockProperty_Base&);
    CBlockProperty_Base& operator=(const CBlockProperty_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Type;
    int m_Intvalue;
    string m_Textvalue;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlockProperty_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBlockProperty_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CBlockProperty_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0x3;
}

inline
CBlockProperty_Base::TType CBlockProperty_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CBlockProperty_Base::SetType(CBlockProperty_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CBlockProperty_Base::TType& CBlockProperty_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CBlockProperty_Base::IsSetIntvalue(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBlockProperty_Base::CanGetIntvalue(void) const
{
    return IsSetIntvalue();
}

inline
void CBlockProperty_Base::ResetIntvalue(void)
{
    m_Intvalue = 0;
    m_set_State[0] &= ~0xc;
}

inline
CBlockProperty_Base::TIntvalue CBlockProperty_Base::GetIntvalue(void) const
{
    if (!CanGetIntvalue()) {
        ThrowUnassigned(1);
    }
    return m_Intvalue;
}

inline
void CBlockProperty_Base::SetIntvalue(CBlockProperty_Base::TIntvalue value)
{
    m_Intvalue = value;
    m_set_State[0] |= 0xc;
}

inline
CBlockProperty_Base::TIntvalue& CBlockProperty_Base::SetIntvalue(void)
{
#ifdef _DEBUG
    if (!IsSetIntvalue()) {
        memset(&m_Intvalue,UnassignedByte(),sizeof(m_Intvalue));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Intvalue;
}

inline
bool CBlockProperty_Base::IsSetTextvalue(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CBlockProperty_Base::CanGetTextvalue(void) const
{
    return IsSetTextvalue();
}

inline
const CBlockProperty_Base::TTextvalue& CBlockProperty_Base::GetTextvalue(void) const
{
    if (!CanGetTextvalue()) {
        ThrowUnassigned(2);
    }
    return m_Textvalue;
}

inline
void CBlockProperty_Base::SetTextvalue(const CBlockProperty_Base::TTextvalue& value)
{
    m_Textvalue = value;
    m_set_State[0] |= 0x30;
}

inline
void CBlockProperty_Base::SetTextvalue(CBlockProperty_Base::TTextvalue&& value)
{
    m_Textvalue = std::forward<CBlockProperty_Base::TTextvalue>(value);
    m_set_State[0] |= 0x30;
}

inline
CBlockProperty_Base::TTextvalue& CBlockProperty_Base::SetTextvalue(void)
{
#ifdef _DEBUG
    if (!IsSetTextvalue()) {
        m_Textvalue = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Textvalue;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SCOREMAT_BLOCKPROPERTY_BASE_HPP
