/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file PssmFinalData_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'scoremat.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_SCOREMAT_PSSMFINALDATA_BASE_HPP
#define OBJECTS_SCOREMAT_PSSMFINALDATA_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// ===========================================================================
/// PSI-BLAST, formatrpsdb, RPS-BLAST workflow:
/// ===========================================
///
/// Two possible inputs to PSI-BLAST and formatrpsdb:
/// 1) PssmWithParams where pssm field contains intermediate PSSM data (matrix 
///    of frequency ratios)
/// 2) PssmWithParams where pssm field contains final PSSM data (matrix of 
///    scores and statistical parameters) - such as written by cddumper
///
/// In case 1, PSI-BLAST's PSSM engine is invoked to create the PSSM and perform
/// the PSI-BLAST search or build the PSSM to then build the RPS-BLAST database.
/// In case 2, PSI-BLAST's PSSM engine is not invoked and the matrix of scores
/// statistical parameters are used to perform the search in PSI-BLAST and the
/// same data and the data in PssmWithParams::params::rpsdbparams is used to
/// build the PSSM and ultimately the RPS-BLAST database
/// 
/// 
///                 reads    ++++++++++++++ writes
/// PssmWithParams  ====>    + PSI-BLAST  + =====> PssmWithParams
///                          ++++++++++++++             |  ^
///         ^                                           |  |
///         |                                           |  |
///         +===========================================+  |
///                                                     |  |
///         +===========================================+  |
///         |                                              |
/// reads   |                                              | 
///         v                                              |
///  +++++++++++++++ writes +++++++++++++++++++++++        |
///  | formatrpsdb | =====> | RPS-BLAST databases |        |
///  +++++++++++++++        +++++++++++++++++++++++        |
///                                   ^                    |
///                                   |                    |
///                                   | reads              |
///                             +++++++++++++              |
///                             | RPS-BLAST |              |
///                             +++++++++++++              |
///                                                        |
///       reads  ++++++++++++               writes         |
///  Cdd ======> | cddumper | =============================+
///              ++++++++++++
///
/// ===========================================================================
/// Contains the PSSM's scores and its associated statistical parameters. 
/// Dimensions and order in which scores are stored must be the same as that 
/// specified in Pssm::numRows, Pssm::numColumns, and Pssm::byrow
class NCBI_SCOREMAT_EXPORT CPssmFinalData_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CPssmFinalData_Base(void);
    // destructor
    virtual ~CPssmFinalData_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< int > TScores;
    typedef double TLambda;
    typedef double TKappa;
    typedef double TH;
    typedef int TScalingFactor;
    typedef double TLambdaUngapped;
    typedef double TKappaUngapped;
    typedef double THUngapped;
    typedef double TWordScoreThreshold;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_scores,
        e_lambda,
        e_kappa,
        e_h,
        e_scalingFactor,
        e_lambdaUngapped,
        e_kappaUngapped,
        e_hUngapped,
        e_wordScoreThreshold
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 10> TmemberIndex;

    // getters
    // setters

    /// PSSM's scores
    /// mandatory
    /// typedef list< int > TScores
    ///  Check whether the Scores data member has been assigned a value.
    bool IsSetScores(void) const;
    /// Check whether it is safe or not to call GetScores method.
    bool CanGetScores(void) const;
    void ResetScores(void);
    const TScores& GetScores(void) const;
    TScores& SetScores(void);

    /// Karlin & Altschul parameter produced during the PSSM's calculation
    /// mandatory
    /// typedef double TLambda
    ///  Check whether the Lambda data member has been assigned a value.
    bool IsSetLambda(void) const;
    /// Check whether it is safe or not to call GetLambda method.
    bool CanGetLambda(void) const;
    void ResetLambda(void);
    TLambda GetLambda(void) const;
    void SetLambda(TLambda value);
    TLambda& SetLambda(void);

    /// Karlin & Altschul parameter produced during the PSSM's calculation
    /// mandatory
    /// typedef double TKappa
    ///  Check whether the Kappa data member has been assigned a value.
    bool IsSetKappa(void) const;
    /// Check whether it is safe or not to call GetKappa method.
    bool CanGetKappa(void) const;
    void ResetKappa(void);
    TKappa GetKappa(void) const;
    void SetKappa(TKappa value);
    TKappa& SetKappa(void);

    /// Karlin & Altschul parameter produced during the PSSM's calculation
    /// mandatory
    /// typedef double TH
    ///  Check whether the H data member has been assigned a value.
    bool IsSetH(void) const;
    /// Check whether it is safe or not to call GetH method.
    bool CanGetH(void) const;
    void ResetH(void);
    TH GetH(void) const;
    void SetH(TH value);
    TH& SetH(void);

    /// scaling factor used to obtain more precision when building the PSSM.
    /// (i.e.: scores are scaled by this value). By default, PSI-BLAST's PSSM
    /// engine generates PSSMs which are not scaled-up, however, if PSI-BLAST is
    /// given a PSSM which contains a scaled-up PSSM (indicated by having a
    /// scalingFactor greater than 1), then it will scale down the PSSM to
    /// perform the initial stages of the search with it.
    /// N.B.: When building RPS-BLAST databases, if formatrpsdb is provided 
    /// scaled-up PSSMs, it will ensure that all PSSMs used to build the 
    /// RPS-BLAST database are scaled by the same factor (otherwise, RPS-BLAST 
    /// will silently produce incorrect results).
    /// optional with default 1
    /// typedef int TScalingFactor
    ///  Check whether the ScalingFactor data member has been assigned a value.
    bool IsSetScalingFactor(void) const;
    /// Check whether it is safe or not to call GetScalingFactor method.
    bool CanGetScalingFactor(void) const;
    void ResetScalingFactor(void);
    void SetDefaultScalingFactor(void);
    TScalingFactor GetScalingFactor(void) const;
    void SetScalingFactor(TScalingFactor value);
    TScalingFactor& SetScalingFactor(void);

    /// Karlin & Altschul parameter produced during the PSSM's calculation
    /// optional
    /// typedef double TLambdaUngapped
    ///  Check whether the LambdaUngapped data member has been assigned a value.
    bool IsSetLambdaUngapped(void) const;
    /// Check whether it is safe or not to call GetLambdaUngapped method.
    bool CanGetLambdaUngapped(void) const;
    void ResetLambdaUngapped(void);
    TLambdaUngapped GetLambdaUngapped(void) const;
    void SetLambdaUngapped(TLambdaUngapped value);
    TLambdaUngapped& SetLambdaUngapped(void);

    /// Karlin & Altschul parameter produced during the PSSM's calculation
    /// optional
    /// typedef double TKappaUngapped
    ///  Check whether the KappaUngapped data member has been assigned a value.
    bool IsSetKappaUngapped(void) const;
    /// Check whether it is safe or not to call GetKappaUngapped method.
    bool CanGetKappaUngapped(void) const;
    void ResetKappaUngapped(void);
    TKappaUngapped GetKappaUngapped(void) const;
    void SetKappaUngapped(TKappaUngapped value);
    TKappaUngapped& SetKappaUngapped(void);

    /// Karlin & Altschul parameter produced during the PSSM's calculation
    /// optional
    /// typedef double THUngapped
    ///  Check whether the HUngapped data member has been assigned a value.
    bool IsSetHUngapped(void) const;
    /// Check whether it is safe or not to call GetHUngapped method.
    bool CanGetHUngapped(void) const;
    void ResetHUngapped(void);
    THUngapped GetHUngapped(void) const;
    void SetHUngapped(THUngapped value);
    THUngapped& SetHUngapped(void);

    /// Word score threshold
    /// optional
    /// typedef double TWordScoreThreshold
    ///  Check whether the WordScoreThreshold data member has been assigned a value.
    bool IsSetWordScoreThreshold(void) const;
    /// Check whether it is safe or not to call GetWordScoreThreshold method.
    bool CanGetWordScoreThreshold(void) const;
    void ResetWordScoreThreshold(void);
    TWordScoreThreshold GetWordScoreThreshold(void) const;
    void SetWordScoreThreshold(TWordScoreThreshold value);
    TWordScoreThreshold& SetWordScoreThreshold(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CPssmFinalData_Base(const CPssmFinalData_Base&);
    CPssmFinalData_Base& operator=(const CPssmFinalData_Base&);

    // data
    Uint4 m_set_State[1];
    list< int > m_Scores;
    double m_Lambda;
    double m_Kappa;
    double m_H;
    int m_ScalingFactor;
    double m_LambdaUngapped;
    double m_KappaUngapped;
    double m_HUngapped;
    double m_WordScoreThreshold;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CPssmFinalData_Base::IsSetScores(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CPssmFinalData_Base::CanGetScores(void) const
{
    return true;
}

inline
const CPssmFinalData_Base::TScores& CPssmFinalData_Base::GetScores(void) const
{
    return m_Scores;
}

inline
CPssmFinalData_Base::TScores& CPssmFinalData_Base::SetScores(void)
{
    m_set_State[0] |= 0x1;
    return m_Scores;
}

inline
bool CPssmFinalData_Base::IsSetLambda(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CPssmFinalData_Base::CanGetLambda(void) const
{
    return IsSetLambda();
}

inline
void CPssmFinalData_Base::ResetLambda(void)
{
    m_Lambda = 0;
    m_set_State[0] &= ~0xc;
}

inline
CPssmFinalData_Base::TLambda CPssmFinalData_Base::GetLambda(void) const
{
    if (!CanGetLambda()) {
        ThrowUnassigned(1);
    }
    return m_Lambda;
}

inline
void CPssmFinalData_Base::SetLambda(CPssmFinalData_Base::TLambda value)
{
    m_Lambda = value;
    m_set_State[0] |= 0xc;
}

inline
CPssmFinalData_Base::TLambda& CPssmFinalData_Base::SetLambda(void)
{
#ifdef _DEBUG
    if (!IsSetLambda()) {
        memset(&m_Lambda,UnassignedByte(),sizeof(m_Lambda));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Lambda;
}

inline
bool CPssmFinalData_Base::IsSetKappa(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CPssmFinalData_Base::CanGetKappa(void) const
{
    return IsSetKappa();
}

inline
void CPssmFinalData_Base::ResetKappa(void)
{
    m_Kappa = 0;
    m_set_State[0] &= ~0x30;
}

inline
CPssmFinalData_Base::TKappa CPssmFinalData_Base::GetKappa(void) const
{
    if (!CanGetKappa()) {
        ThrowUnassigned(2);
    }
    return m_Kappa;
}

inline
void CPssmFinalData_Base::SetKappa(CPssmFinalData_Base::TKappa value)
{
    m_Kappa = value;
    m_set_State[0] |= 0x30;
}

inline
CPssmFinalData_Base::TKappa& CPssmFinalData_Base::SetKappa(void)
{
#ifdef _DEBUG
    if (!IsSetKappa()) {
        memset(&m_Kappa,UnassignedByte(),sizeof(m_Kappa));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Kappa;
}

inline
bool CPssmFinalData_Base::IsSetH(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CPssmFinalData_Base::CanGetH(void) const
{
    return IsSetH();
}

inline
void CPssmFinalData_Base::ResetH(void)
{
    m_H = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CPssmFinalData_Base::TH CPssmFinalData_Base::GetH(void) const
{
    if (!CanGetH()) {
        ThrowUnassigned(3);
    }
    return m_H;
}

inline
void CPssmFinalData_Base::SetH(CPssmFinalData_Base::TH value)
{
    m_H = value;
    m_set_State[0] |= 0xc0;
}

inline
CPssmFinalData_Base::TH& CPssmFinalData_Base::SetH(void)
{
#ifdef _DEBUG
    if (!IsSetH()) {
        memset(&m_H,UnassignedByte(),sizeof(m_H));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_H;
}

inline
bool CPssmFinalData_Base::IsSetScalingFactor(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CPssmFinalData_Base::CanGetScalingFactor(void) const
{
    return true;
}

inline
void CPssmFinalData_Base::ResetScalingFactor(void)
{
    m_ScalingFactor = 1;
    m_set_State[0] &= ~0x300;
}

inline
void CPssmFinalData_Base::SetDefaultScalingFactor(void)
{
    ResetScalingFactor();
}

inline
CPssmFinalData_Base::TScalingFactor CPssmFinalData_Base::GetScalingFactor(void) const
{
    return m_ScalingFactor;
}

inline
void CPssmFinalData_Base::SetScalingFactor(CPssmFinalData_Base::TScalingFactor value)
{
    m_ScalingFactor = value;
    m_set_State[0] |= 0x300;
}

inline
CPssmFinalData_Base::TScalingFactor& CPssmFinalData_Base::SetScalingFactor(void)
{
#ifdef _DEBUG
    if (!IsSetScalingFactor()) {
        memset(&m_ScalingFactor,UnassignedByte(),sizeof(m_ScalingFactor));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_ScalingFactor;
}

inline
bool CPssmFinalData_Base::IsSetLambdaUngapped(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CPssmFinalData_Base::CanGetLambdaUngapped(void) const
{
    return IsSetLambdaUngapped();
}

inline
void CPssmFinalData_Base::ResetLambdaUngapped(void)
{
    m_LambdaUngapped = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CPssmFinalData_Base::TLambdaUngapped CPssmFinalData_Base::GetLambdaUngapped(void) const
{
    if (!CanGetLambdaUngapped()) {
        ThrowUnassigned(5);
    }
    return m_LambdaUngapped;
}

inline
void CPssmFinalData_Base::SetLambdaUngapped(CPssmFinalData_Base::TLambdaUngapped value)
{
    m_LambdaUngapped = value;
    m_set_State[0] |= 0xc00;
}

inline
CPssmFinalData_Base::TLambdaUngapped& CPssmFinalData_Base::SetLambdaUngapped(void)
{
#ifdef _DEBUG
    if (!IsSetLambdaUngapped()) {
        memset(&m_LambdaUngapped,UnassignedByte(),sizeof(m_LambdaUngapped));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_LambdaUngapped;
}

inline
bool CPssmFinalData_Base::IsSetKappaUngapped(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CPssmFinalData_Base::CanGetKappaUngapped(void) const
{
    return IsSetKappaUngapped();
}

inline
void CPssmFinalData_Base::ResetKappaUngapped(void)
{
    m_KappaUngapped = 0;
    m_set_State[0] &= ~0x3000;
}

inline
CPssmFinalData_Base::TKappaUngapped CPssmFinalData_Base::GetKappaUngapped(void) const
{
    if (!CanGetKappaUngapped()) {
        ThrowUnassigned(6);
    }
    return m_KappaUngapped;
}

inline
void CPssmFinalData_Base::SetKappaUngapped(CPssmFinalData_Base::TKappaUngapped value)
{
    m_KappaUngapped = value;
    m_set_State[0] |= 0x3000;
}

inline
CPssmFinalData_Base::TKappaUngapped& CPssmFinalData_Base::SetKappaUngapped(void)
{
#ifdef _DEBUG
    if (!IsSetKappaUngapped()) {
        memset(&m_KappaUngapped,UnassignedByte(),sizeof(m_KappaUngapped));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_KappaUngapped;
}

inline
bool CPssmFinalData_Base::IsSetHUngapped(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CPssmFinalData_Base::CanGetHUngapped(void) const
{
    return IsSetHUngapped();
}

inline
void CPssmFinalData_Base::ResetHUngapped(void)
{
    m_HUngapped = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CPssmFinalData_Base::THUngapped CPssmFinalData_Base::GetHUngapped(void) const
{
    if (!CanGetHUngapped()) {
        ThrowUnassigned(7);
    }
    return m_HUngapped;
}

inline
void CPssmFinalData_Base::SetHUngapped(CPssmFinalData_Base::THUngapped value)
{
    m_HUngapped = value;
    m_set_State[0] |= 0xc000;
}

inline
CPssmFinalData_Base::THUngapped& CPssmFinalData_Base::SetHUngapped(void)
{
#ifdef _DEBUG
    if (!IsSetHUngapped()) {
        memset(&m_HUngapped,UnassignedByte(),sizeof(m_HUngapped));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_HUngapped;
}

inline
bool CPssmFinalData_Base::IsSetWordScoreThreshold(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CPssmFinalData_Base::CanGetWordScoreThreshold(void) const
{
    return IsSetWordScoreThreshold();
}

inline
void CPssmFinalData_Base::ResetWordScoreThreshold(void)
{
    m_WordScoreThreshold = 0;
    m_set_State[0] &= ~0x30000;
}

inline
CPssmFinalData_Base::TWordScoreThreshold CPssmFinalData_Base::GetWordScoreThreshold(void) const
{
    if (!CanGetWordScoreThreshold()) {
        ThrowUnassigned(8);
    }
    return m_WordScoreThreshold;
}

inline
void CPssmFinalData_Base::SetWordScoreThreshold(CPssmFinalData_Base::TWordScoreThreshold value)
{
    m_WordScoreThreshold = value;
    m_set_State[0] |= 0x30000;
}

inline
CPssmFinalData_Base::TWordScoreThreshold& CPssmFinalData_Base::SetWordScoreThreshold(void)
{
#ifdef _DEBUG
    if (!IsSetWordScoreThreshold()) {
        memset(&m_WordScoreThreshold,UnassignedByte(),sizeof(m_WordScoreThreshold));
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_WordScoreThreshold;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SCOREMAT_PSSMFINALDATA_BASE_HPP
